# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AnthosClusterResponse',
    'AuditConfigResponse',
    'AuditLogConfigResponse',
    'BindingResponse',
    'BuildArtifactResponse',
    'CloudRunLocationResponse',
    'CloudRunMetadataResponse',
    'DefaultPoolResponse',
    'DeliveryPipelineResponse',
    'DeployJobResponse',
    'DeploymentJobsResponse',
    'ExecutionConfigResponse',
    'ExprResponse',
    'GkeClusterResponse',
    'JobResponse',
    'MetadataResponse',
    'PhaseResponse',
    'PipelineConditionResponse',
    'PipelineReadyConditionResponse',
    'PrivatePoolResponse',
    'SerialPipelineResponse',
    'StageResponse',
    'StandardResponse',
    'StrategyResponse',
    'TargetResponse',
    'TargetsPresentConditionResponse',
    'VerifyJobResponse',
]

@pulumi.output_type
class AnthosClusterResponse(dict):
    """
    Information specifying an Anthos Cluster.
    """
    def __init__(__self__, *,
                 membership: str):
        """
        Information specifying an Anthos Cluster.
        :param str membership: Membership of the GKE Hub-registered cluster to which to apply the Skaffold configuration. Format is `projects/{project}/locations/{location}/memberships/{membership_name}`.
        """
        pulumi.set(__self__, "membership", membership)

    @property
    @pulumi.getter
    def membership(self) -> str:
        """
        Membership of the GKE Hub-registered cluster to which to apply the Skaffold configuration. Format is `projects/{project}/locations/{location}/memberships/{membership_name}`.
        """
        return pulumi.get(self, "membership")


@pulumi.output_type
class AuditConfigResponse(dict):
    """
    Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogConfigs":
            suggest = "audit_log_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.AuditLogConfigResponse'],
                 service: str):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param Sequence['AuditLogConfigResponse'] audit_log_configs: The configuration for logging of each type of permission.
        :param str service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.AuditLogConfigResponse']:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class AuditLogConfigResponse(dict):
    """
    Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exemptedMembers":
            suggest = "exempted_members"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditLogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exempted_members: Sequence[str],
                 log_type: str):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param Sequence[str] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param str log_type: The log type that this config enables.
        """
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param 'ExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class BuildArtifactResponse(dict):
    """
    Description of an a image to use during Skaffold rendering.
    """
    def __init__(__self__, *,
                 image: str,
                 tag: str):
        """
        Description of an a image to use during Skaffold rendering.
        :param str image: Image name in Skaffold configuration.
        :param str tag: Image tag to use. This will generally be the full path to an image, such as "gcr.io/my-project/busybox:1.2.3" or "gcr.io/my-project/busybox@sha256:abc123".
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        Image name in Skaffold configuration.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def tag(self) -> str:
        """
        Image tag to use. This will generally be the full path to an image, such as "gcr.io/my-project/busybox:1.2.3" or "gcr.io/my-project/busybox@sha256:abc123".
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class CloudRunLocationResponse(dict):
    """
    Information specifying where to deploy a Cloud Run Service.
    """
    def __init__(__self__, *,
                 location: str):
        """
        Information specifying where to deploy a Cloud Run Service.
        :param str location: The location for the Cloud Run Service. Format must be `projects/{project}/locations/{location}`.
        """
        pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The location for the Cloud Run Service. Format must be `projects/{project}/locations/{location}`.
        """
        return pulumi.get(self, "location")


@pulumi.output_type
class CloudRunMetadataResponse(dict):
    """
    CloudRunMetadata contains information from a Cloud Run deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceUrls":
            suggest = "service_urls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudRunMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudRunMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudRunMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 revision: str,
                 service: str,
                 service_urls: Sequence[str]):
        """
        CloudRunMetadata contains information from a Cloud Run deployment.
        :param str revision: The Cloud Run Revision id associated with a `Rollout`.
        :param str service: The name of the Cloud Run Service that is associated with a `Rollout`. Format is projects/{project}/locations/{location}/services/{service}.
        :param Sequence[str] service_urls: The Cloud Run Service urls that are associated with a `Rollout`.
        """
        pulumi.set(__self__, "revision", revision)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "service_urls", service_urls)

    @property
    @pulumi.getter
    def revision(self) -> str:
        """
        The Cloud Run Revision id associated with a `Rollout`.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        The name of the Cloud Run Service that is associated with a `Rollout`. Format is projects/{project}/locations/{location}/services/{service}.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="serviceUrls")
    def service_urls(self) -> Sequence[str]:
        """
        The Cloud Run Service urls that are associated with a `Rollout`.
        """
        return pulumi.get(self, "service_urls")


@pulumi.output_type
class DefaultPoolResponse(dict):
    """
    Execution using the default Cloud Build pool.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactStorage":
            suggest = "artifact_storage"
        elif key == "serviceAccount":
            suggest = "service_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefaultPoolResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefaultPoolResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefaultPoolResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_storage: str,
                 service_account: str):
        """
        Execution using the default Cloud Build pool.
        :param str artifact_storage: Optional. Cloud Storage location where execution outputs should be stored. This can either be a bucket ("gs://my-bucket") or a path within a bucket ("gs://my-bucket/my-dir"). If unspecified, a default bucket located in the same region will be used.
        :param str service_account: Optional. Google service account to use for execution. If unspecified, the project execution service account (-compute@developer.gserviceaccount.com) will be used.
        """
        pulumi.set(__self__, "artifact_storage", artifact_storage)
        pulumi.set(__self__, "service_account", service_account)

    @property
    @pulumi.getter(name="artifactStorage")
    def artifact_storage(self) -> str:
        """
        Optional. Cloud Storage location where execution outputs should be stored. This can either be a bucket ("gs://my-bucket") or a path within a bucket ("gs://my-bucket/my-dir"). If unspecified, a default bucket located in the same region will be used.
        """
        return pulumi.get(self, "artifact_storage")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        Optional. Google service account to use for execution. If unspecified, the project execution service account (-compute@developer.gserviceaccount.com) will be used.
        """
        return pulumi.get(self, "service_account")


@pulumi.output_type
class DeliveryPipelineResponse(dict):
    """
    A `DeliveryPipeline` resource in the Google Cloud Deploy API. A `DeliveryPipeline` defines a pipeline through which a Skaffold configuration can progress.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createTime":
            suggest = "create_time"
        elif key == "serialPipeline":
            suggest = "serial_pipeline"
        elif key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryPipelineResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryPipelineResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryPipelineResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotations: Mapping[str, str],
                 condition: 'outputs.PipelineConditionResponse',
                 create_time: str,
                 description: str,
                 etag: str,
                 labels: Mapping[str, str],
                 name: str,
                 serial_pipeline: 'outputs.SerialPipelineResponse',
                 suspended: bool,
                 uid: str,
                 update_time: str):
        """
        A `DeliveryPipeline` resource in the Google Cloud Deploy API. A `DeliveryPipeline` defines a pipeline through which a Skaffold configuration can progress.
        :param Mapping[str, str] annotations: User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy.
        :param 'PipelineConditionResponse' condition: Information around the state of the Delivery Pipeline.
        :param str create_time: Time at which the pipeline was created.
        :param str description: Description of the `DeliveryPipeline`. Max length is 255 characters.
        :param str etag: This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        :param Mapping[str, str] labels: Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
        :param str name: Optional. Name of the `DeliveryPipeline`. Format is projects/{project}/ locations/{location}/deliveryPipelines/a-z{0,62}.
        :param 'SerialPipelineResponse' serial_pipeline: SerialPipeline defines a sequential set of stages for a `DeliveryPipeline`.
        :param bool suspended: When suspended, no new releases or rollouts can be created, but in-progress ones will complete.
        :param str uid: Unique identifier of the `DeliveryPipeline`.
        :param str update_time: Most recent time at which the pipeline was updated.
        """
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "serial_pipeline", serial_pipeline)
        pulumi.set(__self__, "suspended", suspended)
        pulumi.set(__self__, "uid", uid)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def annotations(self) -> Mapping[str, str]:
        """
        User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.PipelineConditionResponse':
        """
        Information around the state of the Delivery Pipeline.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Time at which the pipeline was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the `DeliveryPipeline`. Max length is 255 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. Name of the `DeliveryPipeline`. Format is projects/{project}/ locations/{location}/deliveryPipelines/a-z{0,62}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serialPipeline")
    def serial_pipeline(self) -> 'outputs.SerialPipelineResponse':
        """
        SerialPipeline defines a sequential set of stages for a `DeliveryPipeline`.
        """
        return pulumi.get(self, "serial_pipeline")

    @property
    @pulumi.getter
    def suspended(self) -> bool:
        """
        When suspended, no new releases or rollouts can be created, but in-progress ones will complete.
        """
        return pulumi.get(self, "suspended")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        Unique identifier of the `DeliveryPipeline`.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Most recent time at which the pipeline was updated.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class DeployJobResponse(dict):
    """
    A deploy Job.
    """
    def __init__(__self__):
        """
        A deploy Job.
        """
        pass


@pulumi.output_type
class DeploymentJobsResponse(dict):
    """
    Deployment job composition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployJob":
            suggest = "deploy_job"
        elif key == "verifyJob":
            suggest = "verify_job"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentJobsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentJobsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentJobsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deploy_job: 'outputs.JobResponse',
                 verify_job: 'outputs.JobResponse'):
        """
        Deployment job composition.
        :param 'JobResponse' deploy_job: The deploy Job. This is the first job run in the phase.
        :param 'JobResponse' verify_job: The verify Job. Runs after a deploy if the deploy succeeds.
        """
        pulumi.set(__self__, "deploy_job", deploy_job)
        pulumi.set(__self__, "verify_job", verify_job)

    @property
    @pulumi.getter(name="deployJob")
    def deploy_job(self) -> 'outputs.JobResponse':
        """
        The deploy Job. This is the first job run in the phase.
        """
        return pulumi.get(self, "deploy_job")

    @property
    @pulumi.getter(name="verifyJob")
    def verify_job(self) -> 'outputs.JobResponse':
        """
        The verify Job. Runs after a deploy if the deploy succeeds.
        """
        return pulumi.get(self, "verify_job")


@pulumi.output_type
class ExecutionConfigResponse(dict):
    """
    Configuration of the environment to use when calling Skaffold.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactStorage":
            suggest = "artifact_storage"
        elif key == "defaultPool":
            suggest = "default_pool"
        elif key == "executionTimeout":
            suggest = "execution_timeout"
        elif key == "privatePool":
            suggest = "private_pool"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "workerPool":
            suggest = "worker_pool"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExecutionConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExecutionConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExecutionConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_storage: str,
                 default_pool: 'outputs.DefaultPoolResponse',
                 execution_timeout: str,
                 private_pool: 'outputs.PrivatePoolResponse',
                 service_account: str,
                 usages: Sequence[str],
                 worker_pool: str):
        """
        Configuration of the environment to use when calling Skaffold.
        :param str artifact_storage: Optional. Cloud Storage location in which to store execution outputs. This can either be a bucket ("gs://my-bucket") or a path within a bucket ("gs://my-bucket/my-dir"). If unspecified, a default bucket located in the same region will be used.
        :param 'DefaultPoolResponse' default_pool: Optional. Use default Cloud Build pool.
        :param str execution_timeout: Optional. Execution timeout for a Cloud Build Execution. This must be between 10m and 24h in seconds format. If unspecified, a default timeout of 1h is used.
        :param 'PrivatePoolResponse' private_pool: Optional. Use private Cloud Build pool.
        :param str service_account: Optional. Google service account to use for execution. If unspecified, the project execution service account (-compute@developer.gserviceaccount.com) is used.
        :param Sequence[str] usages: Usages when this configuration should be applied.
        :param str worker_pool: Optional. The resource name of the `WorkerPool`, with the format `projects/{project}/locations/{location}/workerPools/{worker_pool}`. If this optional field is unspecified, the default Cloud Build pool will be used.
        """
        pulumi.set(__self__, "artifact_storage", artifact_storage)
        pulumi.set(__self__, "default_pool", default_pool)
        pulumi.set(__self__, "execution_timeout", execution_timeout)
        pulumi.set(__self__, "private_pool", private_pool)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "usages", usages)
        pulumi.set(__self__, "worker_pool", worker_pool)

    @property
    @pulumi.getter(name="artifactStorage")
    def artifact_storage(self) -> str:
        """
        Optional. Cloud Storage location in which to store execution outputs. This can either be a bucket ("gs://my-bucket") or a path within a bucket ("gs://my-bucket/my-dir"). If unspecified, a default bucket located in the same region will be used.
        """
        return pulumi.get(self, "artifact_storage")

    @property
    @pulumi.getter(name="defaultPool")
    def default_pool(self) -> 'outputs.DefaultPoolResponse':
        """
        Optional. Use default Cloud Build pool.
        """
        return pulumi.get(self, "default_pool")

    @property
    @pulumi.getter(name="executionTimeout")
    def execution_timeout(self) -> str:
        """
        Optional. Execution timeout for a Cloud Build Execution. This must be between 10m and 24h in seconds format. If unspecified, a default timeout of 1h is used.
        """
        return pulumi.get(self, "execution_timeout")

    @property
    @pulumi.getter(name="privatePool")
    def private_pool(self) -> 'outputs.PrivatePoolResponse':
        """
        Optional. Use private Cloud Build pool.
        """
        return pulumi.get(self, "private_pool")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        Optional. Google service account to use for execution. If unspecified, the project execution service account (-compute@developer.gserviceaccount.com) is used.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter
    def usages(self) -> Sequence[str]:
        """
        Usages when this configuration should be applied.
        """
        return pulumi.get(self, "usages")

    @property
    @pulumi.getter(name="workerPool")
    def worker_pool(self) -> str:
        """
        Optional. The resource name of the `WorkerPool`, with the format `projects/{project}/locations/{location}/workerPools/{worker_pool}`. If this optional field is unspecified, the default Cloud Build pool will be used.
        """
        return pulumi.get(self, "worker_pool")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GkeClusterResponse(dict):
    """
    Information specifying a GKE Cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "internalIp":
            suggest = "internal_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GkeClusterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GkeClusterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GkeClusterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster: str,
                 internal_ip: bool):
        """
        Information specifying a GKE Cluster.
        :param str cluster: Information specifying a GKE Cluster. Format is `projects/{project_id}/locations/{location_id}/clusters/{cluster_id}.
        :param bool internal_ip: Optional. If true, `cluster` is accessed using the private IP address of the control plane endpoint. Otherwise, the default IP address of the control plane endpoint is used. The default IP address is the private IP address for clusters with private control-plane endpoints and the public IP address otherwise. Only specify this option when `cluster` is a [private GKE cluster](https://cloud.google.com/kubernetes-engine/docs/concepts/private-cluster-concept).
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "internal_ip", internal_ip)

    @property
    @pulumi.getter
    def cluster(self) -> str:
        """
        Information specifying a GKE Cluster. Format is `projects/{project_id}/locations/{location_id}/clusters/{cluster_id}.
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> bool:
        """
        Optional. If true, `cluster` is accessed using the private IP address of the control plane endpoint. Otherwise, the default IP address of the control plane endpoint is used. The default IP address is the private IP address for clusters with private control-plane endpoints and the public IP address otherwise. Only specify this option when `cluster` is a [private GKE cluster](https://cloud.google.com/kubernetes-engine/docs/concepts/private-cluster-concept).
        """
        return pulumi.get(self, "internal_ip")


@pulumi.output_type
class JobResponse(dict):
    """
    Job represents an operation for a `Rollout`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployJob":
            suggest = "deploy_job"
        elif key == "jobRun":
            suggest = "job_run"
        elif key == "verifyJob":
            suggest = "verify_job"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deploy_job: 'outputs.DeployJobResponse',
                 job_run: str,
                 state: str,
                 verify_job: 'outputs.VerifyJobResponse'):
        """
        Job represents an operation for a `Rollout`.
        :param 'DeployJobResponse' deploy_job: A deploy Job.
        :param str job_run: The name of the `JobRun` responsible for the most recent invocation of this Job.
        :param str state: The current state of the Job.
        :param 'VerifyJobResponse' verify_job: A verify Job.
        """
        pulumi.set(__self__, "deploy_job", deploy_job)
        pulumi.set(__self__, "job_run", job_run)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "verify_job", verify_job)

    @property
    @pulumi.getter(name="deployJob")
    def deploy_job(self) -> 'outputs.DeployJobResponse':
        """
        A deploy Job.
        """
        return pulumi.get(self, "deploy_job")

    @property
    @pulumi.getter(name="jobRun")
    def job_run(self) -> str:
        """
        The name of the `JobRun` responsible for the most recent invocation of this Job.
        """
        return pulumi.get(self, "job_run")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Job.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="verifyJob")
    def verify_job(self) -> 'outputs.VerifyJobResponse':
        """
        A verify Job.
        """
        return pulumi.get(self, "verify_job")


@pulumi.output_type
class MetadataResponse(dict):
    """
    Metadata includes information associated with a `Rollout`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudRun":
            suggest = "cloud_run"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_run: 'outputs.CloudRunMetadataResponse'):
        """
        Metadata includes information associated with a `Rollout`.
        :param 'CloudRunMetadataResponse' cloud_run: The name of the Cloud Run Service that is associated with a `Rollout`.
        """
        pulumi.set(__self__, "cloud_run", cloud_run)

    @property
    @pulumi.getter(name="cloudRun")
    def cloud_run(self) -> 'outputs.CloudRunMetadataResponse':
        """
        The name of the Cloud Run Service that is associated with a `Rollout`.
        """
        return pulumi.get(self, "cloud_run")


@pulumi.output_type
class PhaseResponse(dict):
    """
    Phase represents a collection of jobs that are logically grouped together for a `Rollout`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deploymentJobs":
            suggest = "deployment_jobs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PhaseResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PhaseResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PhaseResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deployment_jobs: 'outputs.DeploymentJobsResponse',
                 state: str):
        """
        Phase represents a collection of jobs that are logically grouped together for a `Rollout`.
        :param 'DeploymentJobsResponse' deployment_jobs: Deployment job composition.
        :param str state: Current state of the Phase.
        """
        pulumi.set(__self__, "deployment_jobs", deployment_jobs)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="deploymentJobs")
    def deployment_jobs(self) -> 'outputs.DeploymentJobsResponse':
        """
        Deployment job composition.
        """
        return pulumi.get(self, "deployment_jobs")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Current state of the Phase.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class PipelineConditionResponse(dict):
    """
    PipelineCondition contains all conditions relevant to a Delivery Pipeline.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pipelineReadyCondition":
            suggest = "pipeline_ready_condition"
        elif key == "targetsPresentCondition":
            suggest = "targets_present_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pipeline_ready_condition: 'outputs.PipelineReadyConditionResponse',
                 targets_present_condition: 'outputs.TargetsPresentConditionResponse'):
        """
        PipelineCondition contains all conditions relevant to a Delivery Pipeline.
        :param 'PipelineReadyConditionResponse' pipeline_ready_condition: Details around the Pipeline's overall status.
        :param 'TargetsPresentConditionResponse' targets_present_condition: Detalis around targets enumerated in the pipeline.
        """
        pulumi.set(__self__, "pipeline_ready_condition", pipeline_ready_condition)
        pulumi.set(__self__, "targets_present_condition", targets_present_condition)

    @property
    @pulumi.getter(name="pipelineReadyCondition")
    def pipeline_ready_condition(self) -> 'outputs.PipelineReadyConditionResponse':
        """
        Details around the Pipeline's overall status.
        """
        return pulumi.get(self, "pipeline_ready_condition")

    @property
    @pulumi.getter(name="targetsPresentCondition")
    def targets_present_condition(self) -> 'outputs.TargetsPresentConditionResponse':
        """
        Detalis around targets enumerated in the pipeline.
        """
        return pulumi.get(self, "targets_present_condition")


@pulumi.output_type
class PipelineReadyConditionResponse(dict):
    """
    PipelineReadyCondition contains information around the status of the Pipeline.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineReadyConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineReadyConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineReadyConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: bool,
                 update_time: str):
        """
        PipelineReadyCondition contains information around the status of the Pipeline.
        :param bool status: True if the Pipeline is in a valid state. Otherwise at least one condition in `PipelineCondition` is in an invalid state. Iterate over those conditions and see which condition(s) has status = false to find out what is wrong with the Pipeline.
        :param str update_time: Last time the condition was updated.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def status(self) -> bool:
        """
        True if the Pipeline is in a valid state. Otherwise at least one condition in `PipelineCondition` is in an invalid state. Iterate over those conditions and see which condition(s) has status = false to find out what is wrong with the Pipeline.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Last time the condition was updated.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class PrivatePoolResponse(dict):
    """
    Execution using a private Cloud Build pool.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactStorage":
            suggest = "artifact_storage"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "workerPool":
            suggest = "worker_pool"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivatePoolResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivatePoolResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivatePoolResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_storage: str,
                 service_account: str,
                 worker_pool: str):
        """
        Execution using a private Cloud Build pool.
        :param str artifact_storage: Optional. Cloud Storage location where execution outputs should be stored. This can either be a bucket ("gs://my-bucket") or a path within a bucket ("gs://my-bucket/my-dir"). If unspecified, a default bucket located in the same region will be used.
        :param str service_account: Optional. Google service account to use for execution. If unspecified, the project execution service account (-compute@developer.gserviceaccount.com) will be used.
        :param str worker_pool: Resource name of the Cloud Build worker pool to use. The format is `projects/{project}/locations/{location}/workerPools/{pool}`.
        """
        pulumi.set(__self__, "artifact_storage", artifact_storage)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "worker_pool", worker_pool)

    @property
    @pulumi.getter(name="artifactStorage")
    def artifact_storage(self) -> str:
        """
        Optional. Cloud Storage location where execution outputs should be stored. This can either be a bucket ("gs://my-bucket") or a path within a bucket ("gs://my-bucket/my-dir"). If unspecified, a default bucket located in the same region will be used.
        """
        return pulumi.get(self, "artifact_storage")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        Optional. Google service account to use for execution. If unspecified, the project execution service account (-compute@developer.gserviceaccount.com) will be used.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="workerPool")
    def worker_pool(self) -> str:
        """
        Resource name of the Cloud Build worker pool to use. The format is `projects/{project}/locations/{location}/workerPools/{pool}`.
        """
        return pulumi.get(self, "worker_pool")


@pulumi.output_type
class SerialPipelineResponse(dict):
    """
    SerialPipeline defines a sequential set of stages for a `DeliveryPipeline`.
    """
    def __init__(__self__, *,
                 stages: Sequence['outputs.StageResponse']):
        """
        SerialPipeline defines a sequential set of stages for a `DeliveryPipeline`.
        :param Sequence['StageResponse'] stages: Each stage specifies configuration for a `Target`. The ordering of this list defines the promotion flow.
        """
        pulumi.set(__self__, "stages", stages)

    @property
    @pulumi.getter
    def stages(self) -> Sequence['outputs.StageResponse']:
        """
        Each stage specifies configuration for a `Target`. The ordering of this list defines the promotion flow.
        """
        return pulumi.get(self, "stages")


@pulumi.output_type
class StageResponse(dict):
    """
    Stage specifies a location to which to deploy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetId":
            suggest = "target_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 profiles: Sequence[str],
                 strategy: 'outputs.StrategyResponse',
                 target_id: str):
        """
        Stage specifies a location to which to deploy.
        :param Sequence[str] profiles: Skaffold profiles to use when rendering the manifest for this stage's `Target`.
        :param 'StrategyResponse' strategy: Optional. The strategy to use for a `Rollout` to this stage.
        :param str target_id: The target_id to which this stage points. This field refers exclusively to the last segment of a target name. For example, this field would just be `my-target` (rather than `projects/project/locations/location/targets/my-target`). The location of the `Target` is inferred to be the same as the location of the `DeliveryPipeline` that contains this `Stage`.
        """
        pulumi.set(__self__, "profiles", profiles)
        pulumi.set(__self__, "strategy", strategy)
        pulumi.set(__self__, "target_id", target_id)

    @property
    @pulumi.getter
    def profiles(self) -> Sequence[str]:
        """
        Skaffold profiles to use when rendering the manifest for this stage's `Target`.
        """
        return pulumi.get(self, "profiles")

    @property
    @pulumi.getter
    def strategy(self) -> 'outputs.StrategyResponse':
        """
        Optional. The strategy to use for a `Rollout` to this stage.
        """
        return pulumi.get(self, "strategy")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> str:
        """
        The target_id to which this stage points. This field refers exclusively to the last segment of a target name. For example, this field would just be `my-target` (rather than `projects/project/locations/location/targets/my-target`). The location of the `Target` is inferred to be the same as the location of the `DeliveryPipeline` that contains this `Stage`.
        """
        return pulumi.get(self, "target_id")


@pulumi.output_type
class StandardResponse(dict):
    """
    Standard represents the standard deployment strategy.
    """
    def __init__(__self__, *,
                 verify: bool):
        """
        Standard represents the standard deployment strategy.
        :param bool verify: Whether to verify a deployment.
        """
        pulumi.set(__self__, "verify", verify)

    @property
    @pulumi.getter
    def verify(self) -> bool:
        """
        Whether to verify a deployment.
        """
        return pulumi.get(self, "verify")


@pulumi.output_type
class StrategyResponse(dict):
    """
    Strategy contains deployment strategy information.
    """
    def __init__(__self__, *,
                 standard: 'outputs.StandardResponse'):
        """
        Strategy contains deployment strategy information.
        :param 'StandardResponse' standard: Standard deployment strategy executes a single deploy and allows verifying the deployment.
        """
        pulumi.set(__self__, "standard", standard)

    @property
    @pulumi.getter
    def standard(self) -> 'outputs.StandardResponse':
        """
        Standard deployment strategy executes a single deploy and allows verifying the deployment.
        """
        return pulumi.get(self, "standard")


@pulumi.output_type
class TargetResponse(dict):
    """
    A `Target` resource in the Google Cloud Deploy API. A `Target` defines a location to which a Skaffold configuration can be deployed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "anthosCluster":
            suggest = "anthos_cluster"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "executionConfigs":
            suggest = "execution_configs"
        elif key == "requireApproval":
            suggest = "require_approval"
        elif key == "targetId":
            suggest = "target_id"
        elif key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotations: Mapping[str, str],
                 anthos_cluster: 'outputs.AnthosClusterResponse',
                 create_time: str,
                 description: str,
                 etag: str,
                 execution_configs: Sequence['outputs.ExecutionConfigResponse'],
                 gke: 'outputs.GkeClusterResponse',
                 labels: Mapping[str, str],
                 name: str,
                 require_approval: bool,
                 run: 'outputs.CloudRunLocationResponse',
                 target_id: str,
                 uid: str,
                 update_time: str):
        """
        A `Target` resource in the Google Cloud Deploy API. A `Target` defines a location to which a Skaffold configuration can be deployed.
        :param Mapping[str, str] annotations: Optional. User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
        :param 'AnthosClusterResponse' anthos_cluster: Information specifying an Anthos Cluster.
        :param str create_time: Time at which the `Target` was created.
        :param str description: Optional. Description of the `Target`. Max length is 255 characters.
        :param str etag: Optional. This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        :param Sequence['ExecutionConfigResponse'] execution_configs: Configurations for all execution that relates to this `Target`. Each `ExecutionEnvironmentUsage` value may only be used in a single configuration; using the same value multiple times is an error. When one or more configurations are specified, they must include the `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values. When no configurations are specified, execution will use the default specified in `DefaultPool`.
        :param 'GkeClusterResponse' gke: Information specifying a GKE Cluster.
        :param Mapping[str, str] labels: Optional. Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
        :param str name: Optional. Name of the `Target`. Format is projects/{project}/locations/{location}/targets/a-z{0,62}.
        :param bool require_approval: Optional. Whether or not the `Target` requires approval.
        :param 'CloudRunLocationResponse' run: Information specifying a Cloud Run deployment target.
        :param str target_id: Resource id of the `Target`.
        :param str uid: Unique identifier of the `Target`.
        :param str update_time: Most recent time at which the `Target` was updated.
        """
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "anthos_cluster", anthos_cluster)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "execution_configs", execution_configs)
        pulumi.set(__self__, "gke", gke)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "require_approval", require_approval)
        pulumi.set(__self__, "run", run)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "uid", uid)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def annotations(self) -> Mapping[str, str]:
        """
        Optional. User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="anthosCluster")
    def anthos_cluster(self) -> 'outputs.AnthosClusterResponse':
        """
        Information specifying an Anthos Cluster.
        """
        return pulumi.get(self, "anthos_cluster")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Time at which the `Target` was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the `Target`. Max length is 255 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        Optional. This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="executionConfigs")
    def execution_configs(self) -> Sequence['outputs.ExecutionConfigResponse']:
        """
        Configurations for all execution that relates to this `Target`. Each `ExecutionEnvironmentUsage` value may only be used in a single configuration; using the same value multiple times is an error. When one or more configurations are specified, they must include the `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values. When no configurations are specified, execution will use the default specified in `DefaultPool`.
        """
        return pulumi.get(self, "execution_configs")

    @property
    @pulumi.getter
    def gke(self) -> 'outputs.GkeClusterResponse':
        """
        Information specifying a GKE Cluster.
        """
        return pulumi.get(self, "gke")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Optional. Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. Name of the `Target`. Format is projects/{project}/locations/{location}/targets/a-z{0,62}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="requireApproval")
    def require_approval(self) -> bool:
        """
        Optional. Whether or not the `Target` requires approval.
        """
        return pulumi.get(self, "require_approval")

    @property
    @pulumi.getter
    def run(self) -> 'outputs.CloudRunLocationResponse':
        """
        Information specifying a Cloud Run deployment target.
        """
        return pulumi.get(self, "run")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> str:
        """
        Resource id of the `Target`.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        Unique identifier of the `Target`.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Most recent time at which the `Target` was updated.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class TargetsPresentConditionResponse(dict):
    """
    TargetsPresentCondition contains information on any Targets defined in the Delivery Pipeline that do not actually exist.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "missingTargets":
            suggest = "missing_targets"
        elif key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetsPresentConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetsPresentConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetsPresentConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 missing_targets: Sequence[str],
                 status: bool,
                 update_time: str):
        """
        TargetsPresentCondition contains information on any Targets defined in the Delivery Pipeline that do not actually exist.
        :param Sequence[str] missing_targets: The list of Target names that are missing. For example, projects/{project_id}/locations/{location_name}/targets/{target_name}.
        :param bool status: True if there aren't any missing Targets.
        :param str update_time: Last time the condition was updated.
        """
        pulumi.set(__self__, "missing_targets", missing_targets)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="missingTargets")
    def missing_targets(self) -> Sequence[str]:
        """
        The list of Target names that are missing. For example, projects/{project_id}/locations/{location_name}/targets/{target_name}.
        """
        return pulumi.get(self, "missing_targets")

    @property
    @pulumi.getter
    def status(self) -> bool:
        """
        True if there aren't any missing Targets.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Last time the condition was updated.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class VerifyJobResponse(dict):
    """
    A verify Job.
    """
    def __init__(__self__):
        """
        A verify Job.
        """
        pass


