# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = ['ChannelPartnerLinkArgs', 'ChannelPartnerLink']

@pulumi.input_type
class ChannelPartnerLinkArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[str],
                 link_state: pulumi.Input['ChannelPartnerLinkLinkState'],
                 reseller_cloud_identity_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a ChannelPartnerLink resource.
        :param pulumi.Input['ChannelPartnerLinkLinkState'] link_state: State of the channel partner link.
        :param pulumi.Input[str] reseller_cloud_identity_id: Cloud Identity ID of the linked reseller.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "link_state", link_state)
        pulumi.set(__self__, "reseller_cloud_identity_id", reseller_cloud_identity_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="linkState")
    def link_state(self) -> pulumi.Input['ChannelPartnerLinkLinkState']:
        """
        State of the channel partner link.
        """
        return pulumi.get(self, "link_state")

    @link_state.setter
    def link_state(self, value: pulumi.Input['ChannelPartnerLinkLinkState']):
        pulumi.set(self, "link_state", value)

    @property
    @pulumi.getter(name="resellerCloudIdentityId")
    def reseller_cloud_identity_id(self) -> pulumi.Input[str]:
        """
        Cloud Identity ID of the linked reseller.
        """
        return pulumi.get(self, "reseller_cloud_identity_id")

    @reseller_cloud_identity_id.setter
    def reseller_cloud_identity_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "reseller_cloud_identity_id", value)


class ChannelPartnerLink(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 link_state: Optional[pulumi.Input['ChannelPartnerLinkLinkState']] = None,
                 reseller_cloud_identity_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Initiates a channel partner link between a distributor and a reseller, or between resellers in an n-tier reseller channel. Invited partners need to follow the invite_link_uri provided in the response to accept. After accepting the invitation, a link is set up between the two parties. You must be a distributor to call this method. Possible error codes: * PERMISSION_DENIED: The reseller account making the request is different from the reseller account in the API request. * INVALID_ARGUMENT: Required request parameters are missing or invalid. * ALREADY_EXISTS: The ChannelPartnerLink sent in the request already exists. * NOT_FOUND: No Cloud Identity customer exists for provided domain. * INTERNAL: Any non-user error related to a technical issue in the backend. Contact Cloud Channel support. * UNKNOWN: Any non-user error related to a technical issue in the backend. Contact Cloud Channel support. Return value: The new ChannelPartnerLink resource.
        Auto-naming is currently not supported for this resource.
        Note - this resource's API doesn't support deletion. When deleted, the resource will persist
        on Google Cloud even though it will be deleted from Pulumi state.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input['ChannelPartnerLinkLinkState'] link_state: State of the channel partner link.
        :param pulumi.Input[str] reseller_cloud_identity_id: Cloud Identity ID of the linked reseller.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ChannelPartnerLinkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Initiates a channel partner link between a distributor and a reseller, or between resellers in an n-tier reseller channel. Invited partners need to follow the invite_link_uri provided in the response to accept. After accepting the invitation, a link is set up between the two parties. You must be a distributor to call this method. Possible error codes: * PERMISSION_DENIED: The reseller account making the request is different from the reseller account in the API request. * INVALID_ARGUMENT: Required request parameters are missing or invalid. * ALREADY_EXISTS: The ChannelPartnerLink sent in the request already exists. * NOT_FOUND: No Cloud Identity customer exists for provided domain. * INTERNAL: Any non-user error related to a technical issue in the backend. Contact Cloud Channel support. * UNKNOWN: Any non-user error related to a technical issue in the backend. Contact Cloud Channel support. Return value: The new ChannelPartnerLink resource.
        Auto-naming is currently not supported for this resource.
        Note - this resource's API doesn't support deletion. When deleted, the resource will persist
        on Google Cloud even though it will be deleted from Pulumi state.

        :param str resource_name: The name of the resource.
        :param ChannelPartnerLinkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ChannelPartnerLinkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 link_state: Optional[pulumi.Input['ChannelPartnerLinkLinkState']] = None,
                 reseller_cloud_identity_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ChannelPartnerLinkArgs.__new__(ChannelPartnerLinkArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if link_state is None and not opts.urn:
                raise TypeError("Missing required property 'link_state'")
            __props__.__dict__["link_state"] = link_state
            if reseller_cloud_identity_id is None and not opts.urn:
                raise TypeError("Missing required property 'reseller_cloud_identity_id'")
            __props__.__dict__["reseller_cloud_identity_id"] = reseller_cloud_identity_id
            __props__.__dict__["channel_partner_cloud_identity_info"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["invite_link_uri"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["public_id"] = None
            __props__.__dict__["update_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["account_id"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ChannelPartnerLink, __self__).__init__(
            'google-native:cloudchannel/v1:ChannelPartnerLink',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ChannelPartnerLink':
        """
        Get an existing ChannelPartnerLink resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ChannelPartnerLinkArgs.__new__(ChannelPartnerLinkArgs)

        __props__.__dict__["account_id"] = None
        __props__.__dict__["channel_partner_cloud_identity_info"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["invite_link_uri"] = None
        __props__.__dict__["link_state"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["public_id"] = None
        __props__.__dict__["reseller_cloud_identity_id"] = None
        __props__.__dict__["update_time"] = None
        return ChannelPartnerLink(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="channelPartnerCloudIdentityInfo")
    def channel_partner_cloud_identity_info(self) -> pulumi.Output['outputs.GoogleCloudChannelV1CloudIdentityInfoResponse']:
        """
        Cloud Identity info of the channel partner (IR).
        """
        return pulumi.get(self, "channel_partner_cloud_identity_info")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Timestamp of when the channel partner link is created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="inviteLinkUri")
    def invite_link_uri(self) -> pulumi.Output[str]:
        """
        URI of the web page where partner accepts the link invitation.
        """
        return pulumi.get(self, "invite_link_uri")

    @property
    @pulumi.getter(name="linkState")
    def link_state(self) -> pulumi.Output[str]:
        """
        State of the channel partner link.
        """
        return pulumi.get(self, "link_state")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name for the channel partner link, in the format accounts/{account_id}/channelPartnerLinks/{id}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicId")
    def public_id(self) -> pulumi.Output[str]:
        """
        Public identifier that a customer must use to generate a transfer token to move to this distributor-reseller combination.
        """
        return pulumi.get(self, "public_id")

    @property
    @pulumi.getter(name="resellerCloudIdentityId")
    def reseller_cloud_identity_id(self) -> pulumi.Output[str]:
        """
        Cloud Identity ID of the linked reseller.
        """
        return pulumi.get(self, "reseller_cloud_identity_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Timestamp of when the channel partner link is updated.
        """
        return pulumi.get(self, "update_time")

