# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetGitLabConfigResult',
    'AwaitableGetGitLabConfigResult',
    'get_git_lab_config',
    'get_git_lab_config_output',
]

@pulumi.output_type
class GetGitLabConfigResult:
    def __init__(__self__, connected_repositories=None, create_time=None, enterprise_config=None, name=None, secrets=None, username=None, webhook_key=None):
        if connected_repositories and not isinstance(connected_repositories, list):
            raise TypeError("Expected argument 'connected_repositories' to be a list")
        pulumi.set(__self__, "connected_repositories", connected_repositories)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if enterprise_config and not isinstance(enterprise_config, dict):
            raise TypeError("Expected argument 'enterprise_config' to be a dict")
        pulumi.set(__self__, "enterprise_config", enterprise_config)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if secrets and not isinstance(secrets, dict):
            raise TypeError("Expected argument 'secrets' to be a dict")
        pulumi.set(__self__, "secrets", secrets)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)
        if webhook_key and not isinstance(webhook_key, str):
            raise TypeError("Expected argument 'webhook_key' to be a str")
        pulumi.set(__self__, "webhook_key", webhook_key)

    @property
    @pulumi.getter(name="connectedRepositories")
    def connected_repositories(self) -> Sequence['outputs.GitLabRepositoryIdResponse']:
        """
        Connected GitLab.com or GitLabEnterprise repositories for this config.
        """
        return pulumi.get(self, "connected_repositories")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Time when the config was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="enterpriseConfig")
    def enterprise_config(self) -> 'outputs.GitLabEnterpriseConfigResponse':
        """
        Optional. GitLabEnterprise config.
        """
        return pulumi.get(self, "enterprise_config")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name for the config.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def secrets(self) -> 'outputs.GitLabSecretsResponse':
        """
        Secret Manager secrets needed by the config.
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Username of the GitLab.com or GitLab Enterprise account Cloud Build will use.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="webhookKey")
    def webhook_key(self) -> str:
        """
        UUID included in webhook requests. The UUID is used to look up the corresponding config.
        """
        return pulumi.get(self, "webhook_key")


class AwaitableGetGitLabConfigResult(GetGitLabConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGitLabConfigResult(
            connected_repositories=self.connected_repositories,
            create_time=self.create_time,
            enterprise_config=self.enterprise_config,
            name=self.name,
            secrets=self.secrets,
            username=self.username,
            webhook_key=self.webhook_key)


def get_git_lab_config(git_lab_config_id: Optional[str] = None,
                       location: Optional[str] = None,
                       project: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGitLabConfigResult:
    """
    Retrieves a `GitLabConfig`. This API is experimental
    """
    __args__ = dict()
    __args__['gitLabConfigId'] = git_lab_config_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:cloudbuild/v1:getGitLabConfig', __args__, opts=opts, typ=GetGitLabConfigResult).value

    return AwaitableGetGitLabConfigResult(
        connected_repositories=__ret__.connected_repositories,
        create_time=__ret__.create_time,
        enterprise_config=__ret__.enterprise_config,
        name=__ret__.name,
        secrets=__ret__.secrets,
        username=__ret__.username,
        webhook_key=__ret__.webhook_key)


@_utilities.lift_output_func(get_git_lab_config)
def get_git_lab_config_output(git_lab_config_id: Optional[pulumi.Input[str]] = None,
                              location: Optional[pulumi.Input[str]] = None,
                              project: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGitLabConfigResult]:
    """
    Retrieves a `GitLabConfig`. This API is experimental
    """
    ...
