# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['CertificateIssuanceConfigArgs', 'CertificateIssuanceConfig']

@pulumi.input_type
class CertificateIssuanceConfigArgs:
    def __init__(__self__, *,
                 certificate_authority_config: pulumi.Input['CertificateAuthorityConfigArgs'],
                 certificate_issuance_config_id: pulumi.Input[str],
                 key_algorithm: pulumi.Input['CertificateIssuanceConfigKeyAlgorithm'],
                 lifetime: pulumi.Input[str],
                 rotation_window_percentage: pulumi.Input[int],
                 description: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CertificateIssuanceConfig resource.
        :param pulumi.Input['CertificateAuthorityConfigArgs'] certificate_authority_config: The CA that issues the workload certificate. It includes the CA address, type, authentication to CA service, etc.
        :param pulumi.Input[str] certificate_issuance_config_id: Required. A user-provided name of the certificate config.
        :param pulumi.Input['CertificateIssuanceConfigKeyAlgorithm'] key_algorithm: The key algorithm to use when generating the private key.
        :param pulumi.Input[str] lifetime: Workload certificate lifetime requested.
        :param pulumi.Input[int] rotation_window_percentage: Specifies the percentage of elapsed time of the certificate lifetime to wait before renewing the certificate. Must be a number between 1-99, inclusive.
        :param pulumi.Input[str] description: One or more paragraphs of text description of a CertificateIssuanceConfig.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of labels associated with a CertificateIssuanceConfig.
        :param pulumi.Input[str] name: A user-defined name of the certificate issuance config. CertificateIssuanceConfig names must be unique globally and match pattern `projects/*/locations/*/certificateIssuanceConfigs/*`.
        """
        pulumi.set(__self__, "certificate_authority_config", certificate_authority_config)
        pulumi.set(__self__, "certificate_issuance_config_id", certificate_issuance_config_id)
        pulumi.set(__self__, "key_algorithm", key_algorithm)
        pulumi.set(__self__, "lifetime", lifetime)
        pulumi.set(__self__, "rotation_window_percentage", rotation_window_percentage)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="certificateAuthorityConfig")
    def certificate_authority_config(self) -> pulumi.Input['CertificateAuthorityConfigArgs']:
        """
        The CA that issues the workload certificate. It includes the CA address, type, authentication to CA service, etc.
        """
        return pulumi.get(self, "certificate_authority_config")

    @certificate_authority_config.setter
    def certificate_authority_config(self, value: pulumi.Input['CertificateAuthorityConfigArgs']):
        pulumi.set(self, "certificate_authority_config", value)

    @property
    @pulumi.getter(name="certificateIssuanceConfigId")
    def certificate_issuance_config_id(self) -> pulumi.Input[str]:
        """
        Required. A user-provided name of the certificate config.
        """
        return pulumi.get(self, "certificate_issuance_config_id")

    @certificate_issuance_config_id.setter
    def certificate_issuance_config_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_issuance_config_id", value)

    @property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> pulumi.Input['CertificateIssuanceConfigKeyAlgorithm']:
        """
        The key algorithm to use when generating the private key.
        """
        return pulumi.get(self, "key_algorithm")

    @key_algorithm.setter
    def key_algorithm(self, value: pulumi.Input['CertificateIssuanceConfigKeyAlgorithm']):
        pulumi.set(self, "key_algorithm", value)

    @property
    @pulumi.getter
    def lifetime(self) -> pulumi.Input[str]:
        """
        Workload certificate lifetime requested.
        """
        return pulumi.get(self, "lifetime")

    @lifetime.setter
    def lifetime(self, value: pulumi.Input[str]):
        pulumi.set(self, "lifetime", value)

    @property
    @pulumi.getter(name="rotationWindowPercentage")
    def rotation_window_percentage(self) -> pulumi.Input[int]:
        """
        Specifies the percentage of elapsed time of the certificate lifetime to wait before renewing the certificate. Must be a number between 1-99, inclusive.
        """
        return pulumi.get(self, "rotation_window_percentage")

    @rotation_window_percentage.setter
    def rotation_window_percentage(self, value: pulumi.Input[int]):
        pulumi.set(self, "rotation_window_percentage", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        One or more paragraphs of text description of a CertificateIssuanceConfig.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Set of labels associated with a CertificateIssuanceConfig.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-defined name of the certificate issuance config. CertificateIssuanceConfig names must be unique globally and match pattern `projects/*/locations/*/certificateIssuanceConfigs/*`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


class CertificateIssuanceConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_authority_config: Optional[pulumi.Input[pulumi.InputType['CertificateAuthorityConfigArgs']]] = None,
                 certificate_issuance_config_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 key_algorithm: Optional[pulumi.Input['CertificateIssuanceConfigKeyAlgorithm']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lifetime: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 rotation_window_percentage: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Creates a new CertificateIssuanceConfig in a given project and location.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['CertificateAuthorityConfigArgs']] certificate_authority_config: The CA that issues the workload certificate. It includes the CA address, type, authentication to CA service, etc.
        :param pulumi.Input[str] certificate_issuance_config_id: Required. A user-provided name of the certificate config.
        :param pulumi.Input[str] description: One or more paragraphs of text description of a CertificateIssuanceConfig.
        :param pulumi.Input['CertificateIssuanceConfigKeyAlgorithm'] key_algorithm: The key algorithm to use when generating the private key.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of labels associated with a CertificateIssuanceConfig.
        :param pulumi.Input[str] lifetime: Workload certificate lifetime requested.
        :param pulumi.Input[str] name: A user-defined name of the certificate issuance config. CertificateIssuanceConfig names must be unique globally and match pattern `projects/*/locations/*/certificateIssuanceConfigs/*`.
        :param pulumi.Input[int] rotation_window_percentage: Specifies the percentage of elapsed time of the certificate lifetime to wait before renewing the certificate. Must be a number between 1-99, inclusive.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateIssuanceConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new CertificateIssuanceConfig in a given project and location.

        :param str resource_name: The name of the resource.
        :param CertificateIssuanceConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateIssuanceConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_authority_config: Optional[pulumi.Input[pulumi.InputType['CertificateAuthorityConfigArgs']]] = None,
                 certificate_issuance_config_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 key_algorithm: Optional[pulumi.Input['CertificateIssuanceConfigKeyAlgorithm']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lifetime: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 rotation_window_percentage: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateIssuanceConfigArgs.__new__(CertificateIssuanceConfigArgs)

            if certificate_authority_config is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_authority_config'")
            __props__.__dict__["certificate_authority_config"] = certificate_authority_config
            if certificate_issuance_config_id is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_issuance_config_id'")
            __props__.__dict__["certificate_issuance_config_id"] = certificate_issuance_config_id
            __props__.__dict__["description"] = description
            if key_algorithm is None and not opts.urn:
                raise TypeError("Missing required property 'key_algorithm'")
            __props__.__dict__["key_algorithm"] = key_algorithm
            __props__.__dict__["labels"] = labels
            if lifetime is None and not opts.urn:
                raise TypeError("Missing required property 'lifetime'")
            __props__.__dict__["lifetime"] = lifetime
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if rotation_window_percentage is None and not opts.urn:
                raise TypeError("Missing required property 'rotation_window_percentage'")
            __props__.__dict__["rotation_window_percentage"] = rotation_window_percentage
            __props__.__dict__["create_time"] = None
            __props__.__dict__["update_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["certificate_issuance_config_id", "location", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(CertificateIssuanceConfig, __self__).__init__(
            'google-native:certificatemanager/v1:CertificateIssuanceConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'CertificateIssuanceConfig':
        """
        Get an existing CertificateIssuanceConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CertificateIssuanceConfigArgs.__new__(CertificateIssuanceConfigArgs)

        __props__.__dict__["certificate_authority_config"] = None
        __props__.__dict__["certificate_issuance_config_id"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["key_algorithm"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["lifetime"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["rotation_window_percentage"] = None
        __props__.__dict__["update_time"] = None
        return CertificateIssuanceConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateAuthorityConfig")
    def certificate_authority_config(self) -> pulumi.Output['outputs.CertificateAuthorityConfigResponse']:
        """
        The CA that issues the workload certificate. It includes the CA address, type, authentication to CA service, etc.
        """
        return pulumi.get(self, "certificate_authority_config")

    @property
    @pulumi.getter(name="certificateIssuanceConfigId")
    def certificate_issuance_config_id(self) -> pulumi.Output[str]:
        """
        Required. A user-provided name of the certificate config.
        """
        return pulumi.get(self, "certificate_issuance_config_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The creation timestamp of a CertificateIssuanceConfig.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        One or more paragraphs of text description of a CertificateIssuanceConfig.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> pulumi.Output[str]:
        """
        The key algorithm to use when generating the private key.
        """
        return pulumi.get(self, "key_algorithm")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Set of labels associated with a CertificateIssuanceConfig.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def lifetime(self) -> pulumi.Output[str]:
        """
        Workload certificate lifetime requested.
        """
        return pulumi.get(self, "lifetime")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A user-defined name of the certificate issuance config. CertificateIssuanceConfig names must be unique globally and match pattern `projects/*/locations/*/certificateIssuanceConfigs/*`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="rotationWindowPercentage")
    def rotation_window_percentage(self) -> pulumi.Output[int]:
        """
        Specifies the percentage of elapsed time of the certificate lifetime to wait before renewing the certificate. Must be a number between 1-99, inclusive.
        """
        return pulumi.get(self, "rotation_window_percentage")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The last update timestamp of a CertificateIssuanceConfig.
        """
        return pulumi.get(self, "update_time")

