# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AcceleratorResponse',
    'ActionConditionResponse',
    'AllocationPolicyResponse',
    'AttachedDiskResponse',
    'AuditConfigResponse',
    'AuditLogConfigResponse',
    'BarrierResponse',
    'BindingResponse',
    'ComputeResourceResponse',
    'ContainerResponse',
    'DiskResponse',
    'EnvironmentResponse',
    'ExprResponse',
    'GCSResponse',
    'InstancePolicyOrTemplateResponse',
    'InstancePolicyResponse',
    'JobNotificationResponse',
    'JobStatusResponse',
    'LifecyclePolicyResponse',
    'LocationPolicyResponse',
    'LogsPolicyResponse',
    'MessageResponse',
    'NFSResponse',
    'NetworkInterfaceResponse',
    'NetworkPolicyResponse',
    'RunnableResponse',
    'ScriptResponse',
    'ServiceAccountResponse',
    'StatusEventResponse',
    'TaskExecutionResponse',
    'TaskGroupResponse',
    'TaskSpecResponse',
    'VolumeResponse',
]

@pulumi.output_type
class AcceleratorResponse(dict):
    """
    Accelerator describes Compute Engine accelerators to be attached to the VM.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "installGpuDrivers":
            suggest = "install_gpu_drivers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AcceleratorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AcceleratorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AcceleratorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: str,
                 install_gpu_drivers: bool,
                 type: str):
        """
        Accelerator describes Compute Engine accelerators to be attached to the VM.
        :param str count: The number of accelerators of this type.
        :param bool install_gpu_drivers: Deprecated: please use instances[0].install_gpu_drivers instead.
        :param str type: The accelerator type. For example, "nvidia-tesla-t4". See `gcloud compute accelerator-types list`.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "install_gpu_drivers", install_gpu_drivers)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def count(self) -> str:
        """
        The number of accelerators of this type.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="installGpuDrivers")
    def install_gpu_drivers(self) -> bool:
        """
        Deprecated: please use instances[0].install_gpu_drivers instead.
        """
        return pulumi.get(self, "install_gpu_drivers")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The accelerator type. For example, "nvidia-tesla-t4". See `gcloud compute accelerator-types list`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ActionConditionResponse(dict):
    """
    Conditions for actions to deal with task failures.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exitCodes":
            suggest = "exit_codes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActionConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActionConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActionConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exit_codes: Sequence[int]):
        """
        Conditions for actions to deal with task failures.
        :param Sequence[int] exit_codes: Exit codes of a task execution. If there are more than 1 exit codes, when task executes with any of the exit code in the list, the condition is met and the action will be executed.
        """
        pulumi.set(__self__, "exit_codes", exit_codes)

    @property
    @pulumi.getter(name="exitCodes")
    def exit_codes(self) -> Sequence[int]:
        """
        Exit codes of a task execution. If there are more than 1 exit codes, when task executes with any of the exit code in the list, the condition is met and the action will be executed.
        """
        return pulumi.get(self, "exit_codes")


@pulumi.output_type
class AllocationPolicyResponse(dict):
    """
    A Job's resource allocation policy describes when, where, and how compute resources should be allocated for the Job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAccount":
            suggest = "service_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AllocationPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AllocationPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AllocationPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instances: Sequence['outputs.InstancePolicyOrTemplateResponse'],
                 labels: Mapping[str, str],
                 location: 'outputs.LocationPolicyResponse',
                 network: 'outputs.NetworkPolicyResponse',
                 service_account: 'outputs.ServiceAccountResponse'):
        """
        A Job's resource allocation policy describes when, where, and how compute resources should be allocated for the Job.
        :param Sequence['InstancePolicyOrTemplateResponse'] instances: Describe instances that can be created by this AllocationPolicy. Only instances[0] is supported now.
        :param Mapping[str, str] labels: Labels applied to all VM instances and other resources created by AllocationPolicy. Labels could be user provided or system generated. You can assign up to 64 labels. [Google Compute Engine label restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions) apply. Label names that start with "goog-" or "google-" are reserved.
        :param 'LocationPolicyResponse' location: Location where compute resources should be allocated for the Job.
        :param 'NetworkPolicyResponse' network: The network policy.
        :param 'ServiceAccountResponse' service_account: Service account that VMs will run as.
        """
        pulumi.set(__self__, "instances", instances)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "service_account", service_account)

    @property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.InstancePolicyOrTemplateResponse']:
        """
        Describe instances that can be created by this AllocationPolicy. Only instances[0] is supported now.
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels applied to all VM instances and other resources created by AllocationPolicy. Labels could be user provided or system generated. You can assign up to 64 labels. [Google Compute Engine label restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions) apply. Label names that start with "goog-" or "google-" are reserved.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> 'outputs.LocationPolicyResponse':
        """
        Location where compute resources should be allocated for the Job.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def network(self) -> 'outputs.NetworkPolicyResponse':
        """
        The network policy.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> 'outputs.ServiceAccountResponse':
        """
        Service account that VMs will run as.
        """
        return pulumi.get(self, "service_account")


@pulumi.output_type
class AttachedDiskResponse(dict):
    """
    A new or an existing persistent disk (PD) or a local ssd attached to a VM instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"
        elif key == "existingDisk":
            suggest = "existing_disk"
        elif key == "newDisk":
            suggest = "new_disk"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AttachedDiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AttachedDiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AttachedDiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: str,
                 existing_disk: str,
                 new_disk: 'outputs.DiskResponse'):
        """
        A new or an existing persistent disk (PD) or a local ssd attached to a VM instance.
        :param str device_name: Device name that the guest operating system will see. It is used by Runnable.volumes field to mount disks. So please specify the device_name if you want Batch to help mount the disk, and it should match the device_name field in volumes.
        :param str existing_disk: Name of an existing PD.
        """
        pulumi.set(__self__, "device_name", device_name)
        pulumi.set(__self__, "existing_disk", existing_disk)
        pulumi.set(__self__, "new_disk", new_disk)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> str:
        """
        Device name that the guest operating system will see. It is used by Runnable.volumes field to mount disks. So please specify the device_name if you want Batch to help mount the disk, and it should match the device_name field in volumes.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter(name="existingDisk")
    def existing_disk(self) -> str:
        """
        Name of an existing PD.
        """
        return pulumi.get(self, "existing_disk")

    @property
    @pulumi.getter(name="newDisk")
    def new_disk(self) -> 'outputs.DiskResponse':
        return pulumi.get(self, "new_disk")


@pulumi.output_type
class AuditConfigResponse(dict):
    """
    Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogConfigs":
            suggest = "audit_log_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.AuditLogConfigResponse'],
                 service: str):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param Sequence['AuditLogConfigResponse'] audit_log_configs: The configuration for logging of each type of permission.
        :param str service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.AuditLogConfigResponse']:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class AuditLogConfigResponse(dict):
    """
    Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exemptedMembers":
            suggest = "exempted_members"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditLogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exempted_members: Sequence[str],
                 log_type: str):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param Sequence[str] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param str log_type: The log type that this config enables.
        """
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class BarrierResponse(dict):
    """
    Barrier runnable blocks until all tasks in a taskgroup reach it.
    """
    def __init__(__self__, *,
                 name: str):
        """
        Barrier runnable blocks until all tasks in a taskgroup reach it.
        :param str name: Barriers are identified by their index in runnable list. Names are not required, but if present should be an identifier.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Barriers are identified by their index in runnable list. Names are not required, but if present should be an identifier.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param 'ExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class ComputeResourceResponse(dict):
    """
    Compute resource requirements
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootDiskMib":
            suggest = "boot_disk_mib"
        elif key == "cpuMilli":
            suggest = "cpu_milli"
        elif key == "memoryMib":
            suggest = "memory_mib"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeResourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeResourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeResourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot_disk_mib: str,
                 cpu_milli: str,
                 memory_mib: str):
        """
        Compute resource requirements
        :param str boot_disk_mib: Extra boot disk size in MiB for each task.
        :param str cpu_milli: The milliCPU count.
        :param str memory_mib: Memory in MiB.
        """
        pulumi.set(__self__, "boot_disk_mib", boot_disk_mib)
        pulumi.set(__self__, "cpu_milli", cpu_milli)
        pulumi.set(__self__, "memory_mib", memory_mib)

    @property
    @pulumi.getter(name="bootDiskMib")
    def boot_disk_mib(self) -> str:
        """
        Extra boot disk size in MiB for each task.
        """
        return pulumi.get(self, "boot_disk_mib")

    @property
    @pulumi.getter(name="cpuMilli")
    def cpu_milli(self) -> str:
        """
        The milliCPU count.
        """
        return pulumi.get(self, "cpu_milli")

    @property
    @pulumi.getter(name="memoryMib")
    def memory_mib(self) -> str:
        """
        Memory in MiB.
        """
        return pulumi.get(self, "memory_mib")


@pulumi.output_type
class ContainerResponse(dict):
    """
    Container runnable.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockExternalNetwork":
            suggest = "block_external_network"
        elif key == "imageUri":
            suggest = "image_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 block_external_network: bool,
                 commands: Sequence[str],
                 entrypoint: str,
                 image_uri: str,
                 options: str,
                 password: str,
                 username: str,
                 volumes: Sequence[str]):
        """
        Container runnable.
        :param bool block_external_network: If set to true, external network access to and from container will be blocked. The container will use the default internal network 'goog-internal'.
        :param Sequence[str] commands: Overrides the `CMD` specified in the container. If there is an ENTRYPOINT (either in the container image or with the entrypoint field below) then commands are appended as arguments to the ENTRYPOINT.
        :param str entrypoint: Overrides the `ENTRYPOINT` specified in the container.
        :param str image_uri: The URI to pull the container image from.
        :param str options: Arbitrary additional options to include in the "docker run" command when running this container, e.g. "--network host".
        :param str password: Optional password for logging in to a docker registry. If password matches "projects/*/secrets/*/versions/*" then Batch will read the password from the Secret Manager;
        :param str username: Optional username for logging in to a docker registry. If username matches "projects/*/secrets/*/versions/*" then Batch will read the username from the Secret Manager.
        :param Sequence[str] volumes: Volumes to mount (bind mount) from the host machine files or directories into the container, formatted to match docker run's --volume option, e.g. /foo:/bar, or /foo:/bar:ro
        """
        pulumi.set(__self__, "block_external_network", block_external_network)
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "entrypoint", entrypoint)
        pulumi.set(__self__, "image_uri", image_uri)
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="blockExternalNetwork")
    def block_external_network(self) -> bool:
        """
        If set to true, external network access to and from container will be blocked. The container will use the default internal network 'goog-internal'.
        """
        return pulumi.get(self, "block_external_network")

    @property
    @pulumi.getter
    def commands(self) -> Sequence[str]:
        """
        Overrides the `CMD` specified in the container. If there is an ENTRYPOINT (either in the container image or with the entrypoint field below) then commands are appended as arguments to the ENTRYPOINT.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def entrypoint(self) -> str:
        """
        Overrides the `ENTRYPOINT` specified in the container.
        """
        return pulumi.get(self, "entrypoint")

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> str:
        """
        The URI to pull the container image from.
        """
        return pulumi.get(self, "image_uri")

    @property
    @pulumi.getter
    def options(self) -> str:
        """
        Arbitrary additional options to include in the "docker run" command when running this container, e.g. "--network host".
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Optional password for logging in to a docker registry. If password matches "projects/*/secrets/*/versions/*" then Batch will read the password from the Secret Manager;
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Optional username for logging in to a docker registry. If username matches "projects/*/secrets/*/versions/*" then Batch will read the username from the Secret Manager.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def volumes(self) -> Sequence[str]:
        """
        Volumes to mount (bind mount) from the host machine files or directories into the container, formatted to match docker run's --volume option, e.g. /foo:/bar, or /foo:/bar:ro
        """
        return pulumi.get(self, "volumes")


@pulumi.output_type
class DiskResponse(dict):
    """
    A new persistent disk or a local ssd. A VM can only have one local SSD setting but multiple local SSD partitions. https://cloud.google.com/compute/docs/disks#pdspecs. https://cloud.google.com/compute/docs/disks#localssds.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskInterface":
            suggest = "disk_interface"
        elif key == "sizeGb":
            suggest = "size_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_interface: str,
                 image: str,
                 size_gb: str,
                 snapshot: str,
                 type: str):
        """
        A new persistent disk or a local ssd. A VM can only have one local SSD setting but multiple local SSD partitions. https://cloud.google.com/compute/docs/disks#pdspecs. https://cloud.google.com/compute/docs/disks#localssds.
        :param str disk_interface: Local SSDs are available through both "SCSI" and "NVMe" interfaces. If not indicated, "NVMe" will be the default one for local ssds. We only support "SCSI" for persistent disks now.
        :param str image: Name of a public or custom image used as the data source.
        :param str size_gb: Disk size in GB. This field is ignored if `data_source` is `disk` or `image`. If `type` is `local-ssd`, size_gb should be a multiple of 375GB, otherwise, the final size will be the next greater multiple of 375 GB.
        :param str snapshot: Name of a snapshot used as the data source.
        :param str type: Disk type as shown in `gcloud compute disk-types list` For example, "pd-ssd", "pd-standard", "pd-balanced", "local-ssd".
        """
        pulumi.set(__self__, "disk_interface", disk_interface)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "size_gb", size_gb)
        pulumi.set(__self__, "snapshot", snapshot)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="diskInterface")
    def disk_interface(self) -> str:
        """
        Local SSDs are available through both "SCSI" and "NVMe" interfaces. If not indicated, "NVMe" will be the default one for local ssds. We only support "SCSI" for persistent disks now.
        """
        return pulumi.get(self, "disk_interface")

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        Name of a public or custom image used as the data source.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> str:
        """
        Disk size in GB. This field is ignored if `data_source` is `disk` or `image`. If `type` is `local-ssd`, size_gb should be a multiple of 375GB, otherwise, the final size will be the next greater multiple of 375 GB.
        """
        return pulumi.get(self, "size_gb")

    @property
    @pulumi.getter
    def snapshot(self) -> str:
        """
        Name of a snapshot used as the data source.
        """
        return pulumi.get(self, "snapshot")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Disk type as shown in `gcloud compute disk-types list` For example, "pd-ssd", "pd-standard", "pd-balanced", "local-ssd".
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class EnvironmentResponse(dict):
    """
    An Environment describes a collection of environment variables to set when executing Tasks.
    """
    def __init__(__self__, *,
                 variables: Mapping[str, str]):
        """
        An Environment describes a collection of environment variables to set when executing Tasks.
        :param Mapping[str, str] variables: A map of environment variable names to values.
        """
        pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter
    def variables(self) -> Mapping[str, str]:
        """
        A map of environment variable names to values.
        """
        return pulumi.get(self, "variables")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GCSResponse(dict):
    """
    Represents a Google Cloud Storage volume.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "remotePath":
            suggest = "remote_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GCSResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GCSResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GCSResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 remote_path: str):
        """
        Represents a Google Cloud Storage volume.
        :param str remote_path: Remote path, either a bucket name or a subdirectory of a bucket, e.g.: bucket_name, bucket_name/subdirectory/
        """
        pulumi.set(__self__, "remote_path", remote_path)

    @property
    @pulumi.getter(name="remotePath")
    def remote_path(self) -> str:
        """
        Remote path, either a bucket name or a subdirectory of a bucket, e.g.: bucket_name, bucket_name/subdirectory/
        """
        return pulumi.get(self, "remote_path")


@pulumi.output_type
class InstancePolicyOrTemplateResponse(dict):
    """
    Either an InstancePolicy or an instance template.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "installGpuDrivers":
            suggest = "install_gpu_drivers"
        elif key == "instanceTemplate":
            suggest = "instance_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePolicyOrTemplateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePolicyOrTemplateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePolicyOrTemplateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 install_gpu_drivers: bool,
                 instance_template: str,
                 policy: 'outputs.InstancePolicyResponse'):
        """
        Either an InstancePolicy or an instance template.
        :param bool install_gpu_drivers: Set this field true if users want Batch to help fetch drivers from a third party location and install them for GPUs specified in policy.accelerators or instance_template on their behalf. Default is false.
        :param str instance_template: Name of an instance template used to create VMs. Named the field as 'instance_template' instead of 'template' to avoid c++ keyword conflict.
        :param 'InstancePolicyResponse' policy: InstancePolicy.
        """
        pulumi.set(__self__, "install_gpu_drivers", install_gpu_drivers)
        pulumi.set(__self__, "instance_template", instance_template)
        pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter(name="installGpuDrivers")
    def install_gpu_drivers(self) -> bool:
        """
        Set this field true if users want Batch to help fetch drivers from a third party location and install them for GPUs specified in policy.accelerators or instance_template on their behalf. Default is false.
        """
        return pulumi.get(self, "install_gpu_drivers")

    @property
    @pulumi.getter(name="instanceTemplate")
    def instance_template(self) -> str:
        """
        Name of an instance template used to create VMs. Named the field as 'instance_template' instead of 'template' to avoid c++ keyword conflict.
        """
        return pulumi.get(self, "instance_template")

    @property
    @pulumi.getter
    def policy(self) -> 'outputs.InstancePolicyResponse':
        """
        InstancePolicy.
        """
        return pulumi.get(self, "policy")


@pulumi.output_type
class InstancePolicyResponse(dict):
    """
    InstancePolicy describes an instance type and resources attached to each VM created by this InstancePolicy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "machineType":
            suggest = "machine_type"
        elif key == "minCpuPlatform":
            suggest = "min_cpu_platform"
        elif key == "provisioningModel":
            suggest = "provisioning_model"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerators: Sequence['outputs.AcceleratorResponse'],
                 disks: Sequence['outputs.AttachedDiskResponse'],
                 machine_type: str,
                 min_cpu_platform: str,
                 provisioning_model: str):
        """
        InstancePolicy describes an instance type and resources attached to each VM created by this InstancePolicy.
        :param Sequence['AcceleratorResponse'] accelerators: The accelerators attached to each VM instance.
        :param Sequence['AttachedDiskResponse'] disks: Non-boot disks to be attached for each VM created by this InstancePolicy. New disks will be deleted when the VM is deleted.
        :param str machine_type: The Compute Engine machine type.
        :param str min_cpu_platform: The minimum CPU platform. See `https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform`. Not yet implemented.
        :param str provisioning_model: The provisioning model.
        """
        pulumi.set(__self__, "accelerators", accelerators)
        pulumi.set(__self__, "disks", disks)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        pulumi.set(__self__, "provisioning_model", provisioning_model)

    @property
    @pulumi.getter
    def accelerators(self) -> Sequence['outputs.AcceleratorResponse']:
        """
        The accelerators attached to each VM instance.
        """
        return pulumi.get(self, "accelerators")

    @property
    @pulumi.getter
    def disks(self) -> Sequence['outputs.AttachedDiskResponse']:
        """
        Non-boot disks to be attached for each VM created by this InstancePolicy. New disks will be deleted when the VM is deleted.
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> str:
        """
        The Compute Engine machine type.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> str:
        """
        The minimum CPU platform. See `https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform`. Not yet implemented.
        """
        return pulumi.get(self, "min_cpu_platform")

    @property
    @pulumi.getter(name="provisioningModel")
    def provisioning_model(self) -> str:
        """
        The provisioning model.
        """
        return pulumi.get(self, "provisioning_model")


@pulumi.output_type
class JobNotificationResponse(dict):
    """
    Notification configurations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pubsubTopic":
            suggest = "pubsub_topic"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobNotificationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobNotificationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobNotificationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message: 'outputs.MessageResponse',
                 pubsub_topic: str):
        """
        Notification configurations.
        :param 'MessageResponse' message: The attribute requirements of messages to be sent to this Pub/Sub topic. Without this field, no message will be sent.
        :param str pubsub_topic: The Pub/Sub topic where notifications like the job state changes will be published. This topic exist in the same project as the job and billings will be charged to this project. If not specified, no Pub/Sub messages will be sent. Topic format: `projects/{project}/topics/{topic}`.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "pubsub_topic", pubsub_topic)

    @property
    @pulumi.getter
    def message(self) -> 'outputs.MessageResponse':
        """
        The attribute requirements of messages to be sent to this Pub/Sub topic. Without this field, no message will be sent.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> str:
        """
        The Pub/Sub topic where notifications like the job state changes will be published. This topic exist in the same project as the job and billings will be charged to this project. If not specified, no Pub/Sub messages will be sent. Topic format: `projects/{project}/topics/{topic}`.
        """
        return pulumi.get(self, "pubsub_topic")


@pulumi.output_type
class JobStatusResponse(dict):
    """
    Job status.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runDuration":
            suggest = "run_duration"
        elif key == "statusEvents":
            suggest = "status_events"
        elif key == "taskGroups":
            suggest = "task_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 run_duration: str,
                 state: str,
                 status_events: Sequence['outputs.StatusEventResponse'],
                 task_groups: Mapping[str, str]):
        """
        Job status.
        :param str run_duration: The duration of time that the Job spent in status RUNNING.
        :param str state: Job state
        :param Sequence['StatusEventResponse'] status_events: Job status events
        :param Mapping[str, str] task_groups: Aggregated task status for each TaskGroup in the Job. The map key is TaskGroup ID.
        """
        pulumi.set(__self__, "run_duration", run_duration)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "status_events", status_events)
        pulumi.set(__self__, "task_groups", task_groups)

    @property
    @pulumi.getter(name="runDuration")
    def run_duration(self) -> str:
        """
        The duration of time that the Job spent in status RUNNING.
        """
        return pulumi.get(self, "run_duration")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Job state
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="statusEvents")
    def status_events(self) -> Sequence['outputs.StatusEventResponse']:
        """
        Job status events
        """
        return pulumi.get(self, "status_events")

    @property
    @pulumi.getter(name="taskGroups")
    def task_groups(self) -> Mapping[str, str]:
        """
        Aggregated task status for each TaskGroup in the Job. The map key is TaskGroup ID.
        """
        return pulumi.get(self, "task_groups")


@pulumi.output_type
class LifecyclePolicyResponse(dict):
    """
    LifecyclePolicy describes how to deal with task failures based on different conditions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionCondition":
            suggest = "action_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 action_condition: 'outputs.ActionConditionResponse'):
        """
        LifecyclePolicy describes how to deal with task failures based on different conditions.
        :param str action: Action to execute when ActionCondition is true.
        :param 'ActionConditionResponse' action_condition: Conditions that decide why a task failure is dealt with a specific action.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "action_condition", action_condition)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Action to execute when ActionCondition is true.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="actionCondition")
    def action_condition(self) -> 'outputs.ActionConditionResponse':
        """
        Conditions that decide why a task failure is dealt with a specific action.
        """
        return pulumi.get(self, "action_condition")


@pulumi.output_type
class LocationPolicyResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedLocations":
            suggest = "allowed_locations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocationPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocationPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocationPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_locations: Sequence[str]):
        """
        :param Sequence[str] allowed_locations: A list of allowed location names represented by internal URLs. Each location can be a region or a zone. Only one region or multiple zones in one region is supported now. For example, ["regions/us-central1"] allow VMs in any zones in region us-central1. ["zones/us-central1-a", "zones/us-central1-c"] only allow VMs in zones us-central1-a and us-central1-c. All locations end up in different regions would cause errors. For example, ["regions/us-central1", "zones/us-central1-a", "zones/us-central1-b", "zones/us-west1-a"] contains 2 regions "us-central1" and "us-west1". An error is expected in this case.
        """
        pulumi.set(__self__, "allowed_locations", allowed_locations)

    @property
    @pulumi.getter(name="allowedLocations")
    def allowed_locations(self) -> Sequence[str]:
        """
        A list of allowed location names represented by internal URLs. Each location can be a region or a zone. Only one region or multiple zones in one region is supported now. For example, ["regions/us-central1"] allow VMs in any zones in region us-central1. ["zones/us-central1-a", "zones/us-central1-c"] only allow VMs in zones us-central1-a and us-central1-c. All locations end up in different regions would cause errors. For example, ["regions/us-central1", "zones/us-central1-a", "zones/us-central1-b", "zones/us-west1-a"] contains 2 regions "us-central1" and "us-west1". An error is expected in this case.
        """
        return pulumi.get(self, "allowed_locations")


@pulumi.output_type
class LogsPolicyResponse(dict):
    """
    LogsPolicy describes how outputs from a Job's Tasks (stdout/stderr) will be preserved.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logsPath":
            suggest = "logs_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogsPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogsPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogsPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: str,
                 logs_path: str):
        """
        LogsPolicy describes how outputs from a Job's Tasks (stdout/stderr) will be preserved.
        :param str destination: Where logs should be saved.
        :param str logs_path: The path to which logs are saved when the destination = PATH. This can be a local file path on the VM, or under the mount point of a Persistent Disk or Filestore, or a Cloud Storage path.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "logs_path", logs_path)

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        Where logs should be saved.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="logsPath")
    def logs_path(self) -> str:
        """
        The path to which logs are saved when the destination = PATH. This can be a local file path on the VM, or under the mount point of a Persistent Disk or Filestore, or a Cloud Storage path.
        """
        return pulumi.get(self, "logs_path")


@pulumi.output_type
class MessageResponse(dict):
    """
    Message details. Describe the attribute that a message should have. Without specified message attributes, no message will be sent by default.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "newJobState":
            suggest = "new_job_state"
        elif key == "newTaskState":
            suggest = "new_task_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MessageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MessageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MessageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 new_job_state: str,
                 new_task_state: str,
                 type: str):
        """
        Message details. Describe the attribute that a message should have. Without specified message attributes, no message will be sent by default.
        :param str new_job_state: The new job state.
        :param str new_task_state: The new task state.
        :param str type: The message type.
        """
        pulumi.set(__self__, "new_job_state", new_job_state)
        pulumi.set(__self__, "new_task_state", new_task_state)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="newJobState")
    def new_job_state(self) -> str:
        """
        The new job state.
        """
        return pulumi.get(self, "new_job_state")

    @property
    @pulumi.getter(name="newTaskState")
    def new_task_state(self) -> str:
        """
        The new task state.
        """
        return pulumi.get(self, "new_task_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The message type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class NFSResponse(dict):
    """
    Represents an NFS volume.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "remotePath":
            suggest = "remote_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NFSResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NFSResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NFSResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 remote_path: str,
                 server: str):
        """
        Represents an NFS volume.
        :param str remote_path: Remote source path exported from the NFS, e.g., "/share".
        :param str server: The IP address of the NFS.
        """
        pulumi.set(__self__, "remote_path", remote_path)
        pulumi.set(__self__, "server", server)

    @property
    @pulumi.getter(name="remotePath")
    def remote_path(self) -> str:
        """
        Remote source path exported from the NFS, e.g., "/share".
        """
        return pulumi.get(self, "remote_path")

    @property
    @pulumi.getter
    def server(self) -> str:
        """
        The IP address of the NFS.
        """
        return pulumi.get(self, "server")


@pulumi.output_type
class NetworkInterfaceResponse(dict):
    """
    A network interface.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "noExternalIpAddress":
            suggest = "no_external_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkInterfaceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkInterfaceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkInterfaceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network: str,
                 no_external_ip_address: bool,
                 subnetwork: str):
        """
        A network interface.
        :param str network: The URL of the network resource.
        :param bool no_external_ip_address: Default is false (with an external IP address). Required if no external public IP address is attached to the VM. If no external public IP address, additional configuration is required to allow the VM to access Google Services. See https://cloud.google.com/vpc/docs/configure-private-google-access and https://cloud.google.com/nat/docs/gce-example#create-nat for more information.
        :param str subnetwork: The URL of the Subnetwork resource.
        """
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "no_external_ip_address", no_external_ip_address)
        pulumi.set(__self__, "subnetwork", subnetwork)

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        The URL of the network resource.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="noExternalIpAddress")
    def no_external_ip_address(self) -> bool:
        """
        Default is false (with an external IP address). Required if no external public IP address is attached to the VM. If no external public IP address, additional configuration is required to allow the VM to access Google Services. See https://cloud.google.com/vpc/docs/configure-private-google-access and https://cloud.google.com/nat/docs/gce-example#create-nat for more information.
        """
        return pulumi.get(self, "no_external_ip_address")

    @property
    @pulumi.getter
    def subnetwork(self) -> str:
        """
        The URL of the Subnetwork resource.
        """
        return pulumi.get(self, "subnetwork")


@pulumi.output_type
class NetworkPolicyResponse(dict):
    """
    NetworkPolicy describes VM instance network configurations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkInterfaces":
            suggest = "network_interfaces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_interfaces: Sequence['outputs.NetworkInterfaceResponse']):
        """
        NetworkPolicy describes VM instance network configurations.
        :param Sequence['NetworkInterfaceResponse'] network_interfaces: Network configurations.
        """
        pulumi.set(__self__, "network_interfaces", network_interfaces)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Sequence['outputs.NetworkInterfaceResponse']:
        """
        Network configurations.
        """
        return pulumi.get(self, "network_interfaces")


@pulumi.output_type
class RunnableResponse(dict):
    """
    Runnable describes instructions for executing a specific script or container as part of a Task.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alwaysRun":
            suggest = "always_run"
        elif key == "ignoreExitStatus":
            suggest = "ignore_exit_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RunnableResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RunnableResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RunnableResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 always_run: bool,
                 background: bool,
                 barrier: 'outputs.BarrierResponse',
                 container: 'outputs.ContainerResponse',
                 environment: 'outputs.EnvironmentResponse',
                 ignore_exit_status: bool,
                 script: 'outputs.ScriptResponse',
                 timeout: str):
        """
        Runnable describes instructions for executing a specific script or container as part of a Task.
        :param bool always_run: By default, after a Runnable fails, no further Runnable are executed. This flag indicates that this Runnable must be run even if the Task has already failed. This is useful for Runnables that copy output files off of the VM or for debugging. The always_run flag does not override the Task's overall max_run_duration. If the max_run_duration has expired then no further Runnables will execute, not even always_run Runnables.
        :param bool background: This flag allows a Runnable to continue running in the background while the Task executes subsequent Runnables. This is useful to provide services to other Runnables (or to provide debugging support tools like SSH servers).
        :param 'BarrierResponse' barrier: Barrier runnable.
        :param 'ContainerResponse' container: Container runnable.
        :param 'EnvironmentResponse' environment: Environment variables for this Runnable (overrides variables set for the whole Task or TaskGroup).
        :param bool ignore_exit_status: Normally, a non-zero exit status causes the Task to fail. This flag allows execution of other Runnables to continue instead.
        :param 'ScriptResponse' script: Script runnable.
        :param str timeout: Timeout for this Runnable.
        """
        pulumi.set(__self__, "always_run", always_run)
        pulumi.set(__self__, "background", background)
        pulumi.set(__self__, "barrier", barrier)
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "ignore_exit_status", ignore_exit_status)
        pulumi.set(__self__, "script", script)
        pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="alwaysRun")
    def always_run(self) -> bool:
        """
        By default, after a Runnable fails, no further Runnable are executed. This flag indicates that this Runnable must be run even if the Task has already failed. This is useful for Runnables that copy output files off of the VM or for debugging. The always_run flag does not override the Task's overall max_run_duration. If the max_run_duration has expired then no further Runnables will execute, not even always_run Runnables.
        """
        return pulumi.get(self, "always_run")

    @property
    @pulumi.getter
    def background(self) -> bool:
        """
        This flag allows a Runnable to continue running in the background while the Task executes subsequent Runnables. This is useful to provide services to other Runnables (or to provide debugging support tools like SSH servers).
        """
        return pulumi.get(self, "background")

    @property
    @pulumi.getter
    def barrier(self) -> 'outputs.BarrierResponse':
        """
        Barrier runnable.
        """
        return pulumi.get(self, "barrier")

    @property
    @pulumi.getter
    def container(self) -> 'outputs.ContainerResponse':
        """
        Container runnable.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter
    def environment(self) -> 'outputs.EnvironmentResponse':
        """
        Environment variables for this Runnable (overrides variables set for the whole Task or TaskGroup).
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="ignoreExitStatus")
    def ignore_exit_status(self) -> bool:
        """
        Normally, a non-zero exit status causes the Task to fail. This flag allows execution of other Runnables to continue instead.
        """
        return pulumi.get(self, "ignore_exit_status")

    @property
    @pulumi.getter
    def script(self) -> 'outputs.ScriptResponse':
        """
        Script runnable.
        """
        return pulumi.get(self, "script")

    @property
    @pulumi.getter
    def timeout(self) -> str:
        """
        Timeout for this Runnable.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ScriptResponse(dict):
    """
    Script runnable.
    """
    def __init__(__self__, *,
                 path: str,
                 text: str):
        """
        Script runnable.
        :param str path: Script file path on the host VM.
        :param str text: Shell script text.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Script file path on the host VM.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        Shell script text.
        """
        return pulumi.get(self, "text")


@pulumi.output_type
class ServiceAccountResponse(dict):
    """
    Carries information about a Google Cloud service account.
    """
    def __init__(__self__, *,
                 email: str):
        """
        Carries information about a Google Cloud service account.
        :param str email: Email address of the service account. If not specified, the default Compute Engine service account for the project will be used. If instance template is being used, the service account has to be specified in the instance template and it has to match the email field here.
        """
        pulumi.set(__self__, "email", email)

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        Email address of the service account. If not specified, the default Compute Engine service account for the project will be used. If instance template is being used, the service account has to be specified in the instance template and it has to match the email field here.
        """
        return pulumi.get(self, "email")


@pulumi.output_type
class StatusEventResponse(dict):
    """
    Status event
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventTime":
            suggest = "event_time"
        elif key == "taskExecution":
            suggest = "task_execution"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StatusEventResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StatusEventResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StatusEventResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 event_time: str,
                 task_execution: 'outputs.TaskExecutionResponse',
                 type: str):
        """
        Status event
        :param str description: Description of the event.
        :param str event_time: The time this event occurred.
        :param 'TaskExecutionResponse' task_execution: Task Execution
        :param str type: Type of the event.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "event_time", event_time)
        pulumi.set(__self__, "task_execution", task_execution)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the event.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eventTime")
    def event_time(self) -> str:
        """
        The time this event occurred.
        """
        return pulumi.get(self, "event_time")

    @property
    @pulumi.getter(name="taskExecution")
    def task_execution(self) -> 'outputs.TaskExecutionResponse':
        """
        Task Execution
        """
        return pulumi.get(self, "task_execution")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the event.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class TaskExecutionResponse(dict):
    """
    This Task Execution field includes detail information for task execution procedures, based on StatusEvent types.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exitCode":
            suggest = "exit_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskExecutionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskExecutionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskExecutionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exit_code: int):
        """
        This Task Execution field includes detail information for task execution procedures, based on StatusEvent types.
        :param int exit_code: When task is completed as the status of FAILED or SUCCEEDED, exit code is for one task execution result, default is 0 as success.
        """
        pulumi.set(__self__, "exit_code", exit_code)

    @property
    @pulumi.getter(name="exitCode")
    def exit_code(self) -> int:
        """
        When task is completed as the status of FAILED or SUCCEEDED, exit code is for one task execution result, default is 0 as success.
        """
        return pulumi.get(self, "exit_code")


@pulumi.output_type
class TaskGroupResponse(dict):
    """
    A TaskGroup contains one or multiple Tasks that share the same Runnable but with different runtime parameters.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "permissiveSsh":
            suggest = "permissive_ssh"
        elif key == "requireHostsFile":
            suggest = "require_hosts_file"
        elif key == "taskCount":
            suggest = "task_count"
        elif key == "taskCountPerNode":
            suggest = "task_count_per_node"
        elif key == "taskEnvironments":
            suggest = "task_environments"
        elif key == "taskSpec":
            suggest = "task_spec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 parallelism: str,
                 permissive_ssh: bool,
                 require_hosts_file: bool,
                 task_count: str,
                 task_count_per_node: str,
                 task_environments: Sequence['outputs.EnvironmentResponse'],
                 task_spec: 'outputs.TaskSpecResponse'):
        """
        A TaskGroup contains one or multiple Tasks that share the same Runnable but with different runtime parameters.
        :param str name: TaskGroup name. The system generates this field based on parent Job name. For example: "projects/123456/locations/us-west1/jobs/job01/taskGroups/group01".
        :param str parallelism: Max number of tasks that can run in parallel. Default to min(task_count, 1000).
        :param bool permissive_ssh: When true, Batch will configure SSH to allow passwordless login between VMs running the Batch tasks in the same TaskGroup.
        :param bool require_hosts_file: When true, Batch will populate a file with a list of all VMs assigned to the TaskGroup and set the BATCH_HOSTS_FILE environment variable to the path of that file. Defaults to false.
        :param str task_count: Number of Tasks in the TaskGroup. default is 1
        :param str task_count_per_node: Max number of tasks that can be run on a VM at the same time. If not specified, the system will decide a value based on available compute resources on a VM and task requirements.
        :param Sequence['EnvironmentResponse'] task_environments: An array of environment variable mappings, which are passed to Tasks with matching indices. If task_environments is used then task_count should not be specified in the request (and will be ignored). Task count will be the length of task_environments. Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in addition to any environment variables set in task_environments, specifying the number of Tasks in the Task's parent TaskGroup, and the specific Task's index in the TaskGroup (0 through BATCH_TASK_COUNT - 1). task_environments supports up to 200 entries.
        :param 'TaskSpecResponse' task_spec: Tasks in the group share the same task spec.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parallelism", parallelism)
        pulumi.set(__self__, "permissive_ssh", permissive_ssh)
        pulumi.set(__self__, "require_hosts_file", require_hosts_file)
        pulumi.set(__self__, "task_count", task_count)
        pulumi.set(__self__, "task_count_per_node", task_count_per_node)
        pulumi.set(__self__, "task_environments", task_environments)
        pulumi.set(__self__, "task_spec", task_spec)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        TaskGroup name. The system generates this field based on parent Job name. For example: "projects/123456/locations/us-west1/jobs/job01/taskGroups/group01".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parallelism(self) -> str:
        """
        Max number of tasks that can run in parallel. Default to min(task_count, 1000).
        """
        return pulumi.get(self, "parallelism")

    @property
    @pulumi.getter(name="permissiveSsh")
    def permissive_ssh(self) -> bool:
        """
        When true, Batch will configure SSH to allow passwordless login between VMs running the Batch tasks in the same TaskGroup.
        """
        return pulumi.get(self, "permissive_ssh")

    @property
    @pulumi.getter(name="requireHostsFile")
    def require_hosts_file(self) -> bool:
        """
        When true, Batch will populate a file with a list of all VMs assigned to the TaskGroup and set the BATCH_HOSTS_FILE environment variable to the path of that file. Defaults to false.
        """
        return pulumi.get(self, "require_hosts_file")

    @property
    @pulumi.getter(name="taskCount")
    def task_count(self) -> str:
        """
        Number of Tasks in the TaskGroup. default is 1
        """
        return pulumi.get(self, "task_count")

    @property
    @pulumi.getter(name="taskCountPerNode")
    def task_count_per_node(self) -> str:
        """
        Max number of tasks that can be run on a VM at the same time. If not specified, the system will decide a value based on available compute resources on a VM and task requirements.
        """
        return pulumi.get(self, "task_count_per_node")

    @property
    @pulumi.getter(name="taskEnvironments")
    def task_environments(self) -> Sequence['outputs.EnvironmentResponse']:
        """
        An array of environment variable mappings, which are passed to Tasks with matching indices. If task_environments is used then task_count should not be specified in the request (and will be ignored). Task count will be the length of task_environments. Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in addition to any environment variables set in task_environments, specifying the number of Tasks in the Task's parent TaskGroup, and the specific Task's index in the TaskGroup (0 through BATCH_TASK_COUNT - 1). task_environments supports up to 200 entries.
        """
        return pulumi.get(self, "task_environments")

    @property
    @pulumi.getter(name="taskSpec")
    def task_spec(self) -> 'outputs.TaskSpecResponse':
        """
        Tasks in the group share the same task spec.
        """
        return pulumi.get(self, "task_spec")


@pulumi.output_type
class TaskSpecResponse(dict):
    """
    Spec of a task
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeResource":
            suggest = "compute_resource"
        elif key == "lifecyclePolicies":
            suggest = "lifecycle_policies"
        elif key == "maxRetryCount":
            suggest = "max_retry_count"
        elif key == "maxRunDuration":
            suggest = "max_run_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_resource: 'outputs.ComputeResourceResponse',
                 environment: 'outputs.EnvironmentResponse',
                 environments: Mapping[str, str],
                 lifecycle_policies: Sequence['outputs.LifecyclePolicyResponse'],
                 max_retry_count: int,
                 max_run_duration: str,
                 runnables: Sequence['outputs.RunnableResponse'],
                 volumes: Sequence['outputs.VolumeResponse']):
        """
        Spec of a task
        :param 'ComputeResourceResponse' compute_resource: ComputeResource requirements.
        :param 'EnvironmentResponse' environment: Environment variables to set before running the Task.
        :param Mapping[str, str] environments: Environment variables to set before running the Task. You can set up to 100 environments.
        :param Sequence['LifecyclePolicyResponse'] lifecycle_policies: Lifecycle management schema when any task in a task group is failed. The valid size of lifecycle policies are [0, 10]. For each lifecycle policy, when the condition is met, the action in that policy will execute. If there are multiple policies that the task execution result matches, we use the action from the first matched policy. If task execution result does not meet with any of the defined lifecycle policy, we consider it as the default policy. Default policy means if the exit code is 0, exit task. If task ends with non-zero exit code, retry the task with max_retry_count.
        :param int max_retry_count: Maximum number of retries on failures. The default, 0, which means never retry. The valid value range is [0, 10].
        :param str max_run_duration: Maximum duration the task should run. The task will be killed and marked as FAILED if over this limit.
        :param Sequence['RunnableResponse'] runnables: The sequence of scripts or containers to run for this Task. Each Task using this TaskSpec executes its list of runnables in order. The Task succeeds if all of its runnables either exit with a zero status or any that exit with a non-zero status have the ignore_exit_status flag. Background runnables are killed automatically (if they have not already exited) a short time after all foreground runnables have completed. Even though this is likely to result in a non-zero exit status for the background runnable, these automatic kills are not treated as Task failures.
        :param Sequence['VolumeResponse'] volumes: Volumes to mount before running Tasks using this TaskSpec.
        """
        pulumi.set(__self__, "compute_resource", compute_resource)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "environments", environments)
        pulumi.set(__self__, "lifecycle_policies", lifecycle_policies)
        pulumi.set(__self__, "max_retry_count", max_retry_count)
        pulumi.set(__self__, "max_run_duration", max_run_duration)
        pulumi.set(__self__, "runnables", runnables)
        pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="computeResource")
    def compute_resource(self) -> 'outputs.ComputeResourceResponse':
        """
        ComputeResource requirements.
        """
        return pulumi.get(self, "compute_resource")

    @property
    @pulumi.getter
    def environment(self) -> 'outputs.EnvironmentResponse':
        """
        Environment variables to set before running the Task.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def environments(self) -> Mapping[str, str]:
        """
        Environment variables to set before running the Task. You can set up to 100 environments.
        """
        return pulumi.get(self, "environments")

    @property
    @pulumi.getter(name="lifecyclePolicies")
    def lifecycle_policies(self) -> Sequence['outputs.LifecyclePolicyResponse']:
        """
        Lifecycle management schema when any task in a task group is failed. The valid size of lifecycle policies are [0, 10]. For each lifecycle policy, when the condition is met, the action in that policy will execute. If there are multiple policies that the task execution result matches, we use the action from the first matched policy. If task execution result does not meet with any of the defined lifecycle policy, we consider it as the default policy. Default policy means if the exit code is 0, exit task. If task ends with non-zero exit code, retry the task with max_retry_count.
        """
        return pulumi.get(self, "lifecycle_policies")

    @property
    @pulumi.getter(name="maxRetryCount")
    def max_retry_count(self) -> int:
        """
        Maximum number of retries on failures. The default, 0, which means never retry. The valid value range is [0, 10].
        """
        return pulumi.get(self, "max_retry_count")

    @property
    @pulumi.getter(name="maxRunDuration")
    def max_run_duration(self) -> str:
        """
        Maximum duration the task should run. The task will be killed and marked as FAILED if over this limit.
        """
        return pulumi.get(self, "max_run_duration")

    @property
    @pulumi.getter
    def runnables(self) -> Sequence['outputs.RunnableResponse']:
        """
        The sequence of scripts or containers to run for this Task. Each Task using this TaskSpec executes its list of runnables in order. The Task succeeds if all of its runnables either exit with a zero status or any that exit with a non-zero status have the ignore_exit_status flag. Background runnables are killed automatically (if they have not already exited) a short time after all foreground runnables have completed. Even though this is likely to result in a non-zero exit status for the background runnable, these automatic kills are not treated as Task failures.
        """
        return pulumi.get(self, "runnables")

    @property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.VolumeResponse']:
        """
        Volumes to mount before running Tasks using this TaskSpec.
        """
        return pulumi.get(self, "volumes")


@pulumi.output_type
class VolumeResponse(dict):
    """
    Volume describes a volume and parameters for it to be mounted to a VM.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"
        elif key == "mountOptions":
            suggest = "mount_options"
        elif key == "mountPath":
            suggest = "mount_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: str,
                 gcs: 'outputs.GCSResponse',
                 mount_options: Sequence[str],
                 mount_path: str,
                 nfs: 'outputs.NFSResponse'):
        """
        Volume describes a volume and parameters for it to be mounted to a VM.
        :param str device_name: Device name of an attached disk volume, which should align with a device_name specified by job.allocation_policy.instances[0].policy.disks[i].device_name or defined by the given instance template in job.allocation_policy.instances[0].instance_template.
        :param 'GCSResponse' gcs: A Google Cloud Storage (GCS) volume.
        :param Sequence[str] mount_options: For Google Cloud Storage (GCS), mount options are the options supported by the gcsfuse tool (https://github.com/GoogleCloudPlatform/gcsfuse). For existing persistent disks, mount options provided by the mount command (https://man7.org/linux/man-pages/man8/mount.8.html) except writing are supported. This is due to restrictions of multi-writer mode (https://cloud.google.com/compute/docs/disks/sharing-disks-between-vms). For other attached disks and Network File System (NFS), mount options are these supported by the mount command (https://man7.org/linux/man-pages/man8/mount.8.html).
        :param str mount_path: The mount path for the volume, e.g. /mnt/disks/share.
        :param 'NFSResponse' nfs: A Network File System (NFS) volume. For example, a Filestore file share.
        """
        pulumi.set(__self__, "device_name", device_name)
        pulumi.set(__self__, "gcs", gcs)
        pulumi.set(__self__, "mount_options", mount_options)
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "nfs", nfs)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> str:
        """
        Device name of an attached disk volume, which should align with a device_name specified by job.allocation_policy.instances[0].policy.disks[i].device_name or defined by the given instance template in job.allocation_policy.instances[0].instance_template.
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter
    def gcs(self) -> 'outputs.GCSResponse':
        """
        A Google Cloud Storage (GCS) volume.
        """
        return pulumi.get(self, "gcs")

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Sequence[str]:
        """
        For Google Cloud Storage (GCS), mount options are the options supported by the gcsfuse tool (https://github.com/GoogleCloudPlatform/gcsfuse). For existing persistent disks, mount options provided by the mount command (https://man7.org/linux/man-pages/man8/mount.8.html) except writing are supported. This is due to restrictions of multi-writer mode (https://cloud.google.com/compute/docs/disks/sharing-disks-between-vms). For other attached disks and Network File System (NFS), mount options are these supported by the mount command (https://man7.org/linux/man-pages/man8/mount.8.html).
        """
        return pulumi.get(self, "mount_options")

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> str:
        """
        The mount path for the volume, e.g. /mnt/disks/share.
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter
    def nfs(self) -> 'outputs.NFSResponse':
        """
        A Network File System (NFS) volume. For example, a Filestore file share.
        """
        return pulumi.get(self, "nfs")


