# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AllowedClientResponse',
    'GoogleCloudBaremetalsolutionV2LogicalInterfaceResponse',
    'InstanceConfigResponse',
    'IntakeVlanAttachmentResponse',
    'LogicalNetworkInterfaceResponse',
    'LunRangeResponse',
    'LunResponse',
    'NetworkAddressReservationResponse',
    'NetworkAddressResponse',
    'NetworkConfigResponse',
    'NetworkMountPointResponse',
    'NetworkResponse',
    'NfsExportResponse',
    'QosPolicyResponse',
    'SnapshotReservationDetailResponse',
    'VRFResponse',
    'VlanAttachmentResponse',
    'VolumeConfigResponse',
    'VolumeResponse',
]

@pulumi.output_type
class AllowedClientResponse(dict):
    """
    Represents an 'access point' for the share.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowDev":
            suggest = "allow_dev"
        elif key == "allowSuid":
            suggest = "allow_suid"
        elif key == "allowedClientsCidr":
            suggest = "allowed_clients_cidr"
        elif key == "mountPermissions":
            suggest = "mount_permissions"
        elif key == "nfsPath":
            suggest = "nfs_path"
        elif key == "noRootSquash":
            suggest = "no_root_squash"
        elif key == "shareIp":
            suggest = "share_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AllowedClientResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AllowedClientResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AllowedClientResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_dev: bool,
                 allow_suid: bool,
                 allowed_clients_cidr: str,
                 mount_permissions: str,
                 network: str,
                 nfs_path: str,
                 no_root_squash: bool,
                 share_ip: str):
        """
        Represents an 'access point' for the share.
        :param bool allow_dev: Allow dev flag. Which controls whether to allow creation of devices.
        :param bool allow_suid: Allow the setuid flag.
        :param str allowed_clients_cidr: The subnet of IP addresses permitted to access the share.
        :param str mount_permissions: Mount permissions.
        :param str network: The network the access point sits on.
        :param str nfs_path: The path to access NFS, in format shareIP:/InstanceID InstanceID is the generated ID instead of customer provided name. example like "10.0.0.0:/g123456789-nfs001"
        :param bool no_root_squash: Disable root squashing, which is a feature of NFS. Root squash is a special mapping of the remote superuser (root) identity when using identity authentication.
        :param str share_ip: The IP address of the share on this network. Assigned automatically during provisioning based on the network's services_cidr.
        """
        pulumi.set(__self__, "allow_dev", allow_dev)
        pulumi.set(__self__, "allow_suid", allow_suid)
        pulumi.set(__self__, "allowed_clients_cidr", allowed_clients_cidr)
        pulumi.set(__self__, "mount_permissions", mount_permissions)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "nfs_path", nfs_path)
        pulumi.set(__self__, "no_root_squash", no_root_squash)
        pulumi.set(__self__, "share_ip", share_ip)

    @property
    @pulumi.getter(name="allowDev")
    def allow_dev(self) -> bool:
        """
        Allow dev flag. Which controls whether to allow creation of devices.
        """
        return pulumi.get(self, "allow_dev")

    @property
    @pulumi.getter(name="allowSuid")
    def allow_suid(self) -> bool:
        """
        Allow the setuid flag.
        """
        return pulumi.get(self, "allow_suid")

    @property
    @pulumi.getter(name="allowedClientsCidr")
    def allowed_clients_cidr(self) -> str:
        """
        The subnet of IP addresses permitted to access the share.
        """
        return pulumi.get(self, "allowed_clients_cidr")

    @property
    @pulumi.getter(name="mountPermissions")
    def mount_permissions(self) -> str:
        """
        Mount permissions.
        """
        return pulumi.get(self, "mount_permissions")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        The network the access point sits on.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="nfsPath")
    def nfs_path(self) -> str:
        """
        The path to access NFS, in format shareIP:/InstanceID InstanceID is the generated ID instead of customer provided name. example like "10.0.0.0:/g123456789-nfs001"
        """
        return pulumi.get(self, "nfs_path")

    @property
    @pulumi.getter(name="noRootSquash")
    def no_root_squash(self) -> bool:
        """
        Disable root squashing, which is a feature of NFS. Root squash is a special mapping of the remote superuser (root) identity when using identity authentication.
        """
        return pulumi.get(self, "no_root_squash")

    @property
    @pulumi.getter(name="shareIp")
    def share_ip(self) -> str:
        """
        The IP address of the share on this network. Assigned automatically during provisioning based on the network's services_cidr.
        """
        return pulumi.get(self, "share_ip")


@pulumi.output_type
class GoogleCloudBaremetalsolutionV2LogicalInterfaceResponse(dict):
    """
    Each logical interface represents a logical abstraction of the underlying physical interface (for eg. bond, nic) of the instance. Each logical interface can effectively map to multiple network-IP pairs and still be mapped to one underlying physical interface.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "interfaceIndex":
            suggest = "interface_index"
        elif key == "logicalNetworkInterfaces":
            suggest = "logical_network_interfaces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudBaremetalsolutionV2LogicalInterfaceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudBaremetalsolutionV2LogicalInterfaceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudBaremetalsolutionV2LogicalInterfaceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interface_index: int,
                 logical_network_interfaces: Sequence['outputs.LogicalNetworkInterfaceResponse'],
                 name: str):
        """
        Each logical interface represents a logical abstraction of the underlying physical interface (for eg. bond, nic) of the instance. Each logical interface can effectively map to multiple network-IP pairs and still be mapped to one underlying physical interface.
        :param int interface_index: The index of the logical interface mapping to the index of the hardware bond or nic on the chosen network template. This field is deprecated.
        :param Sequence['LogicalNetworkInterfaceResponse'] logical_network_interfaces: List of logical network interfaces within a logical interface.
        :param str name: Interface name. This is of syntax or and forms part of the network template name.
        """
        pulumi.set(__self__, "interface_index", interface_index)
        pulumi.set(__self__, "logical_network_interfaces", logical_network_interfaces)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="interfaceIndex")
    def interface_index(self) -> int:
        """
        The index of the logical interface mapping to the index of the hardware bond or nic on the chosen network template. This field is deprecated.
        """
        return pulumi.get(self, "interface_index")

    @property
    @pulumi.getter(name="logicalNetworkInterfaces")
    def logical_network_interfaces(self) -> Sequence['outputs.LogicalNetworkInterfaceResponse']:
        """
        List of logical network interfaces within a logical interface.
        """
        return pulumi.get(self, "logical_network_interfaces")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Interface name. This is of syntax or and forms part of the network template name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class InstanceConfigResponse(dict):
    """
    Configuration parameters for a new instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountNetworksEnabled":
            suggest = "account_networks_enabled"
        elif key == "clientNetwork":
            suggest = "client_network"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "logicalInterfaces":
            suggest = "logical_interfaces"
        elif key == "networkConfig":
            suggest = "network_config"
        elif key == "networkTemplate":
            suggest = "network_template"
        elif key == "osImage":
            suggest = "os_image"
        elif key == "privateNetwork":
            suggest = "private_network"
        elif key == "userNote":
            suggest = "user_note"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_networks_enabled: bool,
                 client_network: 'outputs.NetworkAddressResponse',
                 hyperthreading: bool,
                 instance_type: str,
                 logical_interfaces: Sequence['outputs.GoogleCloudBaremetalsolutionV2LogicalInterfaceResponse'],
                 name: str,
                 network_config: str,
                 network_template: str,
                 os_image: str,
                 private_network: 'outputs.NetworkAddressResponse',
                 user_note: str):
        """
        Configuration parameters for a new instance.
        :param bool account_networks_enabled: If true networks can be from different projects of the same vendor account.
        :param 'NetworkAddressResponse' client_network: Client network address. Filled if InstanceConfig.multivlan_config is false.
        :param bool hyperthreading: Whether the instance should be provisioned with Hyperthreading enabled.
        :param str instance_type: Instance type. [Available types](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
        :param Sequence['GoogleCloudBaremetalsolutionV2LogicalInterfaceResponse'] logical_interfaces: List of logical interfaces for the instance. The number of logical interfaces will be the same as number of hardware bond/nic on the chosen network template. Filled if InstanceConfig.multivlan_config is true.
        :param str name: The name of the instance config.
        :param str network_config: The type of network configuration on the instance.
        :param str network_template: Server network template name. Filled if InstanceConfig.multivlan_config is true.
        :param str os_image: OS image to initialize the instance. [Available images](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
        :param 'NetworkAddressResponse' private_network: Private network address, if any. Filled if InstanceConfig.multivlan_config is false.
        :param str user_note: User note field, it can be used by customers to add additional information for the BMS Ops team .
        """
        pulumi.set(__self__, "account_networks_enabled", account_networks_enabled)
        pulumi.set(__self__, "client_network", client_network)
        pulumi.set(__self__, "hyperthreading", hyperthreading)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "logical_interfaces", logical_interfaces)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_config", network_config)
        pulumi.set(__self__, "network_template", network_template)
        pulumi.set(__self__, "os_image", os_image)
        pulumi.set(__self__, "private_network", private_network)
        pulumi.set(__self__, "user_note", user_note)

    @property
    @pulumi.getter(name="accountNetworksEnabled")
    def account_networks_enabled(self) -> bool:
        """
        If true networks can be from different projects of the same vendor account.
        """
        return pulumi.get(self, "account_networks_enabled")

    @property
    @pulumi.getter(name="clientNetwork")
    def client_network(self) -> 'outputs.NetworkAddressResponse':
        """
        Client network address. Filled if InstanceConfig.multivlan_config is false.
        """
        return pulumi.get(self, "client_network")

    @property
    @pulumi.getter
    def hyperthreading(self) -> bool:
        """
        Whether the instance should be provisioned with Hyperthreading enabled.
        """
        return pulumi.get(self, "hyperthreading")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Instance type. [Available types](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="logicalInterfaces")
    def logical_interfaces(self) -> Sequence['outputs.GoogleCloudBaremetalsolutionV2LogicalInterfaceResponse']:
        """
        List of logical interfaces for the instance. The number of logical interfaces will be the same as number of hardware bond/nic on the chosen network template. Filled if InstanceConfig.multivlan_config is true.
        """
        return pulumi.get(self, "logical_interfaces")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the instance config.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> str:
        """
        The type of network configuration on the instance.
        """
        return pulumi.get(self, "network_config")

    @property
    @pulumi.getter(name="networkTemplate")
    def network_template(self) -> str:
        """
        Server network template name. Filled if InstanceConfig.multivlan_config is true.
        """
        return pulumi.get(self, "network_template")

    @property
    @pulumi.getter(name="osImage")
    def os_image(self) -> str:
        """
        OS image to initialize the instance. [Available images](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
        """
        return pulumi.get(self, "os_image")

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> 'outputs.NetworkAddressResponse':
        """
        Private network address, if any. Filled if InstanceConfig.multivlan_config is false.
        """
        return pulumi.get(self, "private_network")

    @property
    @pulumi.getter(name="userNote")
    def user_note(self) -> str:
        """
        User note field, it can be used by customers to add additional information for the BMS Ops team .
        """
        return pulumi.get(self, "user_note")


@pulumi.output_type
class IntakeVlanAttachmentResponse(dict):
    """
    A GCP vlan attachment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pairingKey":
            suggest = "pairing_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntakeVlanAttachmentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntakeVlanAttachmentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntakeVlanAttachmentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pairing_key: str):
        """
        A GCP vlan attachment.
        :param str pairing_key: Attachment pairing key.
        """
        pulumi.set(__self__, "pairing_key", pairing_key)

    @property
    @pulumi.getter(name="pairingKey")
    def pairing_key(self) -> str:
        """
        Attachment pairing key.
        """
        return pulumi.get(self, "pairing_key")


@pulumi.output_type
class LogicalNetworkInterfaceResponse(dict):
    """
    Each logical network interface is effectively a network and IP pair.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultGateway":
            suggest = "default_gateway"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "networkType":
            suggest = "network_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogicalNetworkInterfaceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogicalNetworkInterfaceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogicalNetworkInterfaceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_gateway: bool,
                 ip_address: str,
                 network: str,
                 network_type: str):
        """
        Each logical network interface is effectively a network and IP pair.
        :param bool default_gateway: Whether this interface is the default gateway for the instance. Only one interface can be the default gateway for the instance.
        :param str ip_address: IP address in the network
        :param str network: Name of the network
        :param str network_type: Type of network.
        """
        pulumi.set(__self__, "default_gateway", default_gateway)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "network_type", network_type)

    @property
    @pulumi.getter(name="defaultGateway")
    def default_gateway(self) -> bool:
        """
        Whether this interface is the default gateway for the instance. Only one interface can be the default gateway for the instance.
        """
        return pulumi.get(self, "default_gateway")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        IP address in the network
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        Name of the network
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> str:
        """
        Type of network.
        """
        return pulumi.get(self, "network_type")


@pulumi.output_type
class LunRangeResponse(dict):
    """
    A LUN(Logical Unit Number) range.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeGb":
            suggest = "size_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LunRangeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LunRangeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LunRangeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 quantity: int,
                 size_gb: int):
        """
        A LUN(Logical Unit Number) range.
        :param int quantity: Number of LUNs to create.
        :param int size_gb: The requested size of each LUN, in GB.
        """
        pulumi.set(__self__, "quantity", quantity)
        pulumi.set(__self__, "size_gb", size_gb)

    @property
    @pulumi.getter
    def quantity(self) -> int:
        """
        Number of LUNs to create.
        """
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> int:
        """
        The requested size of each LUN, in GB.
        """
        return pulumi.get(self, "size_gb")


@pulumi.output_type
class LunResponse(dict):
    """
    A storage volume logical unit number (LUN).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootLun":
            suggest = "boot_lun"
        elif key == "multiprotocolType":
            suggest = "multiprotocol_type"
        elif key == "sizeGb":
            suggest = "size_gb"
        elif key == "storageType":
            suggest = "storage_type"
        elif key == "storageVolume":
            suggest = "storage_volume"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LunResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LunResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LunResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot_lun: bool,
                 multiprotocol_type: str,
                 name: str,
                 shareable: bool,
                 size_gb: str,
                 state: str,
                 storage_type: str,
                 storage_volume: str,
                 wwid: str):
        """
        A storage volume logical unit number (LUN).
        :param bool boot_lun: Display if this LUN is a boot LUN.
        :param str multiprotocol_type: The LUN multiprotocol type ensures the characteristics of the LUN are optimized for each operating system.
        :param str name: The name of the LUN.
        :param bool shareable: Display if this LUN can be shared between multiple physical servers.
        :param str size_gb: The size of this LUN, in gigabytes.
        :param str state: The state of this storage volume.
        :param str storage_type: The storage type for this LUN.
        :param str storage_volume: Display the storage volume for this LUN.
        :param str wwid: The WWID for this LUN.
        """
        pulumi.set(__self__, "boot_lun", boot_lun)
        pulumi.set(__self__, "multiprotocol_type", multiprotocol_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "shareable", shareable)
        pulumi.set(__self__, "size_gb", size_gb)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "storage_type", storage_type)
        pulumi.set(__self__, "storage_volume", storage_volume)
        pulumi.set(__self__, "wwid", wwid)

    @property
    @pulumi.getter(name="bootLun")
    def boot_lun(self) -> bool:
        """
        Display if this LUN is a boot LUN.
        """
        return pulumi.get(self, "boot_lun")

    @property
    @pulumi.getter(name="multiprotocolType")
    def multiprotocol_type(self) -> str:
        """
        The LUN multiprotocol type ensures the characteristics of the LUN are optimized for each operating system.
        """
        return pulumi.get(self, "multiprotocol_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the LUN.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def shareable(self) -> bool:
        """
        Display if this LUN can be shared between multiple physical servers.
        """
        return pulumi.get(self, "shareable")

    @property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> str:
        """
        The size of this LUN, in gigabytes.
        """
        return pulumi.get(self, "size_gb")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of this storage volume.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> str:
        """
        The storage type for this LUN.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter(name="storageVolume")
    def storage_volume(self) -> str:
        """
        Display the storage volume for this LUN.
        """
        return pulumi.get(self, "storage_volume")

    @property
    @pulumi.getter
    def wwid(self) -> str:
        """
        The WWID for this LUN.
        """
        return pulumi.get(self, "wwid")


@pulumi.output_type
class NetworkAddressReservationResponse(dict):
    """
    A reservation of one or more addresses in a network.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endAddress":
            suggest = "end_address"
        elif key == "startAddress":
            suggest = "start_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkAddressReservationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkAddressReservationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkAddressReservationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_address: str,
                 note: str,
                 start_address: str):
        """
        A reservation of one or more addresses in a network.
        :param str end_address: The last address of this reservation block, inclusive. I.e., for cases when reservations are only single addresses, end_address and start_address will be the same. Must be specified as a single IPv4 address, e.g. 10.1.2.2.
        :param str note: A note about this reservation, intended for human consumption.
        :param str start_address: The first address of this reservation block. Must be specified as a single IPv4 address, e.g. 10.1.2.2.
        """
        pulumi.set(__self__, "end_address", end_address)
        pulumi.set(__self__, "note", note)
        pulumi.set(__self__, "start_address", start_address)

    @property
    @pulumi.getter(name="endAddress")
    def end_address(self) -> str:
        """
        The last address of this reservation block, inclusive. I.e., for cases when reservations are only single addresses, end_address and start_address will be the same. Must be specified as a single IPv4 address, e.g. 10.1.2.2.
        """
        return pulumi.get(self, "end_address")

    @property
    @pulumi.getter
    def note(self) -> str:
        """
        A note about this reservation, intended for human consumption.
        """
        return pulumi.get(self, "note")

    @property
    @pulumi.getter(name="startAddress")
    def start_address(self) -> str:
        """
        The first address of this reservation block. Must be specified as a single IPv4 address, e.g. 10.1.2.2.
        """
        return pulumi.get(self, "start_address")


@pulumi.output_type
class NetworkAddressResponse(dict):
    """
    A network.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "existingNetworkId":
            suggest = "existing_network_id"
        elif key == "networkId":
            suggest = "network_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkAddressResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkAddressResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkAddressResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 existing_network_id: str,
                 network_id: str):
        """
        A network.
        :param str address: IPv4 address to be assigned to the server.
        :param str existing_network_id: Name of the existing network to use.
        :param str network_id: Id of the network to use, within the same ProvisioningConfig request.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "existing_network_id", existing_network_id)
        pulumi.set(__self__, "network_id", network_id)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        IPv4 address to be assigned to the server.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="existingNetworkId")
    def existing_network_id(self) -> str:
        """
        Name of the existing network to use.
        """
        return pulumi.get(self, "existing_network_id")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> str:
        """
        Id of the network to use, within the same ProvisioningConfig request.
        """
        return pulumi.get(self, "network_id")


@pulumi.output_type
class NetworkConfigResponse(dict):
    """
    Configuration parameters for a new network.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gcpService":
            suggest = "gcp_service"
        elif key == "jumboFramesEnabled":
            suggest = "jumbo_frames_enabled"
        elif key == "serviceCidr":
            suggest = "service_cidr"
        elif key == "userNote":
            suggest = "user_note"
        elif key == "vlanAttachments":
            suggest = "vlan_attachments"
        elif key == "vlanSameProject":
            suggest = "vlan_same_project"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bandwidth: str,
                 cidr: str,
                 gcp_service: str,
                 jumbo_frames_enabled: bool,
                 name: str,
                 service_cidr: str,
                 type: str,
                 user_note: str,
                 vlan_attachments: Sequence['outputs.IntakeVlanAttachmentResponse'],
                 vlan_same_project: bool):
        """
        Configuration parameters for a new network.
        :param str bandwidth: Interconnect bandwidth. Set only when type is CLIENT.
        :param str cidr: CIDR range of the network.
        :param str gcp_service: The GCP service of the network. Available gcp_service are in https://cloud.google.com/bare-metal/docs/bms-planning.
        :param bool jumbo_frames_enabled: The JumboFramesEnabled option for customer to set.
        :param str name: The name of the network config.
        :param str service_cidr: Service CIDR, if any.
        :param str type: The type of this network, either Client or Private.
        :param str user_note: User note field, it can be used by customers to add additional information for the BMS Ops team .
        :param Sequence['IntakeVlanAttachmentResponse'] vlan_attachments: List of VLAN attachments. As of now there are always 2 attachments, but it is going to change in the future (multi vlan).
        :param bool vlan_same_project: Whether the VLAN attachment pair is located in the same project.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "gcp_service", gcp_service)
        pulumi.set(__self__, "jumbo_frames_enabled", jumbo_frames_enabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service_cidr", service_cidr)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user_note", user_note)
        pulumi.set(__self__, "vlan_attachments", vlan_attachments)
        pulumi.set(__self__, "vlan_same_project", vlan_same_project)

    @property
    @pulumi.getter
    def bandwidth(self) -> str:
        """
        Interconnect bandwidth. Set only when type is CLIENT.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter
    def cidr(self) -> str:
        """
        CIDR range of the network.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter(name="gcpService")
    def gcp_service(self) -> str:
        """
        The GCP service of the network. Available gcp_service are in https://cloud.google.com/bare-metal/docs/bms-planning.
        """
        return pulumi.get(self, "gcp_service")

    @property
    @pulumi.getter(name="jumboFramesEnabled")
    def jumbo_frames_enabled(self) -> bool:
        """
        The JumboFramesEnabled option for customer to set.
        """
        return pulumi.get(self, "jumbo_frames_enabled")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the network config.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> str:
        """
        Service CIDR, if any.
        """
        return pulumi.get(self, "service_cidr")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of this network, either Client or Private.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userNote")
    def user_note(self) -> str:
        """
        User note field, it can be used by customers to add additional information for the BMS Ops team .
        """
        return pulumi.get(self, "user_note")

    @property
    @pulumi.getter(name="vlanAttachments")
    def vlan_attachments(self) -> Sequence['outputs.IntakeVlanAttachmentResponse']:
        """
        List of VLAN attachments. As of now there are always 2 attachments, but it is going to change in the future (multi vlan).
        """
        return pulumi.get(self, "vlan_attachments")

    @property
    @pulumi.getter(name="vlanSameProject")
    def vlan_same_project(self) -> bool:
        """
        Whether the VLAN attachment pair is located in the same project.
        """
        return pulumi.get(self, "vlan_same_project")


@pulumi.output_type
class NetworkMountPointResponse(dict):
    """
    Mount point for a network.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultGateway":
            suggest = "default_gateway"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "logicalInterface":
            suggest = "logical_interface"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkMountPointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkMountPointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkMountPointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_gateway: bool,
                 instance: str,
                 ip_address: str,
                 logical_interface: str):
        """
        Mount point for a network.
        :param bool default_gateway: Network should be a default gateway.
        :param str instance: Instance to attach network to.
        :param str ip_address: Ip address of the server.
        :param str logical_interface: Logical interface to detach from.
        """
        pulumi.set(__self__, "default_gateway", default_gateway)
        pulumi.set(__self__, "instance", instance)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "logical_interface", logical_interface)

    @property
    @pulumi.getter(name="defaultGateway")
    def default_gateway(self) -> bool:
        """
        Network should be a default gateway.
        """
        return pulumi.get(self, "default_gateway")

    @property
    @pulumi.getter
    def instance(self) -> str:
        """
        Instance to attach network to.
        """
        return pulumi.get(self, "instance")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        Ip address of the server.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="logicalInterface")
    def logical_interface(self) -> str:
        """
        Logical interface to detach from.
        """
        return pulumi.get(self, "logical_interface")


@pulumi.output_type
class NetworkResponse(dict):
    """
    A Network.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gatewayIp":
            suggest = "gateway_ip"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "jumboFramesEnabled":
            suggest = "jumbo_frames_enabled"
        elif key == "macAddress":
            suggest = "mac_address"
        elif key == "mountPoints":
            suggest = "mount_points"
        elif key == "servicesCidr":
            suggest = "services_cidr"
        elif key == "vlanId":
            suggest = "vlan_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidr: str,
                 gateway_ip: str,
                 ip_address: str,
                 jumbo_frames_enabled: bool,
                 labels: Mapping[str, str],
                 mac_address: Sequence[str],
                 mount_points: Sequence['outputs.NetworkMountPointResponse'],
                 name: str,
                 pod: str,
                 reservations: Sequence['outputs.NetworkAddressReservationResponse'],
                 services_cidr: str,
                 state: str,
                 type: str,
                 vlan_id: str,
                 vrf: 'outputs.VRFResponse'):
        """
        A Network.
        :param str cidr: The cidr of the Network.
        :param str gateway_ip: Gateway ip address.
        :param str ip_address: IP address configured.
        :param bool jumbo_frames_enabled: Whether network uses standard frames or jumbo ones.
        :param Mapping[str, str] labels: Labels as key value pairs.
        :param Sequence[str] mac_address: List of physical interfaces.
        :param Sequence['NetworkMountPointResponse'] mount_points: Input only. List of mount points to attach the network to.
        :param str name: The resource name of this `Network`. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. Format: `projects/{project}/locations/{location}/networks/{network}`
        :param str pod: Pod name.
        :param Sequence['NetworkAddressReservationResponse'] reservations: List of IP address reservations in this network. When updating this field, an error will be generated if a reservation conflicts with an IP address already allocated to a physical server.
        :param str services_cidr: IP range for reserved for services (e.g. NFS).
        :param str state: The Network state.
        :param str type: The type of this network.
        :param str vlan_id: The vlan id of the Network.
        :param 'VRFResponse' vrf: The vrf for the Network.
        """
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "gateway_ip", gateway_ip)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "jumbo_frames_enabled", jumbo_frames_enabled)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "mac_address", mac_address)
        pulumi.set(__self__, "mount_points", mount_points)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pod", pod)
        pulumi.set(__self__, "reservations", reservations)
        pulumi.set(__self__, "services_cidr", services_cidr)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vlan_id", vlan_id)
        pulumi.set(__self__, "vrf", vrf)

    @property
    @pulumi.getter
    def cidr(self) -> str:
        """
        The cidr of the Network.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter(name="gatewayIp")
    def gateway_ip(self) -> str:
        """
        Gateway ip address.
        """
        return pulumi.get(self, "gateway_ip")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        IP address configured.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="jumboFramesEnabled")
    def jumbo_frames_enabled(self) -> bool:
        """
        Whether network uses standard frames or jumbo ones.
        """
        return pulumi.get(self, "jumbo_frames_enabled")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels as key value pairs.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Sequence[str]:
        """
        List of physical interfaces.
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter(name="mountPoints")
    def mount_points(self) -> Sequence['outputs.NetworkMountPointResponse']:
        """
        Input only. List of mount points to attach the network to.
        """
        return pulumi.get(self, "mount_points")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of this `Network`. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. Format: `projects/{project}/locations/{location}/networks/{network}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def pod(self) -> str:
        """
        Pod name.
        """
        return pulumi.get(self, "pod")

    @property
    @pulumi.getter
    def reservations(self) -> Sequence['outputs.NetworkAddressReservationResponse']:
        """
        List of IP address reservations in this network. When updating this field, an error will be generated if a reservation conflicts with an IP address already allocated to a physical server.
        """
        return pulumi.get(self, "reservations")

    @property
    @pulumi.getter(name="servicesCidr")
    def services_cidr(self) -> str:
        """
        IP range for reserved for services (e.g. NFS).
        """
        return pulumi.get(self, "services_cidr")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The Network state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of this network.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> str:
        """
        The vlan id of the Network.
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter
    def vrf(self) -> 'outputs.VRFResponse':
        """
        The vrf for the Network.
        """
        return pulumi.get(self, "vrf")


@pulumi.output_type
class NfsExportResponse(dict):
    """
    A NFS export entry.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowDev":
            suggest = "allow_dev"
        elif key == "allowSuid":
            suggest = "allow_suid"
        elif key == "machineId":
            suggest = "machine_id"
        elif key == "networkId":
            suggest = "network_id"
        elif key == "noRootSquash":
            suggest = "no_root_squash"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NfsExportResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NfsExportResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NfsExportResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_dev: bool,
                 allow_suid: bool,
                 cidr: str,
                 machine_id: str,
                 network_id: str,
                 no_root_squash: bool,
                 permissions: str):
        """
        A NFS export entry.
        :param bool allow_dev: Allow dev flag in NfsShare AllowedClientsRequest.
        :param bool allow_suid: Allow the setuid flag.
        :param str cidr: A CIDR range.
        :param str machine_id: Either a single machine, identified by an ID, or a comma-separated list of machine IDs.
        :param str network_id: Network to use to publish the export.
        :param bool no_root_squash: Disable root squashing, which is a feature of NFS. Root squash is a special mapping of the remote superuser (root) identity when using identity authentication.
        :param str permissions: Export permissions.
        """
        pulumi.set(__self__, "allow_dev", allow_dev)
        pulumi.set(__self__, "allow_suid", allow_suid)
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "machine_id", machine_id)
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "no_root_squash", no_root_squash)
        pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="allowDev")
    def allow_dev(self) -> bool:
        """
        Allow dev flag in NfsShare AllowedClientsRequest.
        """
        return pulumi.get(self, "allow_dev")

    @property
    @pulumi.getter(name="allowSuid")
    def allow_suid(self) -> bool:
        """
        Allow the setuid flag.
        """
        return pulumi.get(self, "allow_suid")

    @property
    @pulumi.getter
    def cidr(self) -> str:
        """
        A CIDR range.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter(name="machineId")
    def machine_id(self) -> str:
        """
        Either a single machine, identified by an ID, or a comma-separated list of machine IDs.
        """
        return pulumi.get(self, "machine_id")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> str:
        """
        Network to use to publish the export.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="noRootSquash")
    def no_root_squash(self) -> bool:
        """
        Disable root squashing, which is a feature of NFS. Root squash is a special mapping of the remote superuser (root) identity when using identity authentication.
        """
        return pulumi.get(self, "no_root_squash")

    @property
    @pulumi.getter
    def permissions(self) -> str:
        """
        Export permissions.
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class QosPolicyResponse(dict):
    """
    QOS policy parameters.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bandwidthGbps":
            suggest = "bandwidth_gbps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QosPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QosPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QosPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bandwidth_gbps: float):
        """
        QOS policy parameters.
        :param float bandwidth_gbps: The bandwidth permitted by the QOS policy, in gbps.
        """
        pulumi.set(__self__, "bandwidth_gbps", bandwidth_gbps)

    @property
    @pulumi.getter(name="bandwidthGbps")
    def bandwidth_gbps(self) -> float:
        """
        The bandwidth permitted by the QOS policy, in gbps.
        """
        return pulumi.get(self, "bandwidth_gbps")


@pulumi.output_type
class SnapshotReservationDetailResponse(dict):
    """
    Details about snapshot space reservation and usage on the storage volume.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "reservedSpaceGib":
            suggest = "reserved_space_gib"
        elif key == "reservedSpacePercent":
            suggest = "reserved_space_percent"
        elif key == "reservedSpaceRemainingGib":
            suggest = "reserved_space_remaining_gib"
        elif key == "reservedSpaceUsedPercent":
            suggest = "reserved_space_used_percent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SnapshotReservationDetailResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SnapshotReservationDetailResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SnapshotReservationDetailResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 reserved_space_gib: str,
                 reserved_space_percent: int,
                 reserved_space_remaining_gib: str,
                 reserved_space_used_percent: int):
        """
        Details about snapshot space reservation and usage on the storage volume.
        :param str reserved_space_gib: The space on this storage volume reserved for snapshots, shown in GiB.
        :param int reserved_space_percent: Percent of the total Volume size reserved for snapshot copies. Enabling snapshots requires reserving 20% or more of the storage volume space for snapshots. Maximum reserved space for snapshots is 40%. Setting this field will effectively set snapshot_enabled to true.
        :param str reserved_space_remaining_gib: The amount, in GiB, of available space in this storage volume's reserved snapshot space.
        :param int reserved_space_used_percent: The percent of snapshot space on this storage volume actually being used by the snapshot copies. This value might be higher than 100% if the snapshot copies have overflowed into the data portion of the storage volume.
        """
        pulumi.set(__self__, "reserved_space_gib", reserved_space_gib)
        pulumi.set(__self__, "reserved_space_percent", reserved_space_percent)
        pulumi.set(__self__, "reserved_space_remaining_gib", reserved_space_remaining_gib)
        pulumi.set(__self__, "reserved_space_used_percent", reserved_space_used_percent)

    @property
    @pulumi.getter(name="reservedSpaceGib")
    def reserved_space_gib(self) -> str:
        """
        The space on this storage volume reserved for snapshots, shown in GiB.
        """
        return pulumi.get(self, "reserved_space_gib")

    @property
    @pulumi.getter(name="reservedSpacePercent")
    def reserved_space_percent(self) -> int:
        """
        Percent of the total Volume size reserved for snapshot copies. Enabling snapshots requires reserving 20% or more of the storage volume space for snapshots. Maximum reserved space for snapshots is 40%. Setting this field will effectively set snapshot_enabled to true.
        """
        return pulumi.get(self, "reserved_space_percent")

    @property
    @pulumi.getter(name="reservedSpaceRemainingGib")
    def reserved_space_remaining_gib(self) -> str:
        """
        The amount, in GiB, of available space in this storage volume's reserved snapshot space.
        """
        return pulumi.get(self, "reserved_space_remaining_gib")

    @property
    @pulumi.getter(name="reservedSpaceUsedPercent")
    def reserved_space_used_percent(self) -> int:
        """
        The percent of snapshot space on this storage volume actually being used by the snapshot copies. This value might be higher than 100% if the snapshot copies have overflowed into the data portion of the storage volume.
        """
        return pulumi.get(self, "reserved_space_used_percent")


@pulumi.output_type
class VRFResponse(dict):
    """
    A network VRF.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "qosPolicy":
            suggest = "qos_policy"
        elif key == "vlanAttachments":
            suggest = "vlan_attachments"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VRFResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VRFResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VRFResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 qos_policy: 'outputs.QosPolicyResponse',
                 state: str,
                 vlan_attachments: Sequence['outputs.VlanAttachmentResponse']):
        """
        A network VRF.
        :param str name: The name of the VRF.
        :param 'QosPolicyResponse' qos_policy: The QOS policy applied to this VRF. The value is only meaningful when all the vlan attachments have the same QoS. This field should not be used for new integrations, use vlan attachment level qos instead. The field is left for backward-compatibility.
        :param str state: The possible state of VRF.
        :param Sequence['VlanAttachmentResponse'] vlan_attachments: The list of VLAN attachments for the VRF.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "qos_policy", qos_policy)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "vlan_attachments", vlan_attachments)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the VRF.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="qosPolicy")
    def qos_policy(self) -> 'outputs.QosPolicyResponse':
        """
        The QOS policy applied to this VRF. The value is only meaningful when all the vlan attachments have the same QoS. This field should not be used for new integrations, use vlan attachment level qos instead. The field is left for backward-compatibility.
        """
        return pulumi.get(self, "qos_policy")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The possible state of VRF.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="vlanAttachments")
    def vlan_attachments(self) -> Sequence['outputs.VlanAttachmentResponse']:
        """
        The list of VLAN attachments for the VRF.
        """
        return pulumi.get(self, "vlan_attachments")


@pulumi.output_type
class VlanAttachmentResponse(dict):
    """
    VLAN attachment details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pairingKey":
            suggest = "pairing_key"
        elif key == "peerIp":
            suggest = "peer_ip"
        elif key == "peerVlanId":
            suggest = "peer_vlan_id"
        elif key == "qosPolicy":
            suggest = "qos_policy"
        elif key == "routerIp":
            suggest = "router_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VlanAttachmentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VlanAttachmentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VlanAttachmentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pairing_key: str,
                 peer_ip: str,
                 peer_vlan_id: str,
                 qos_policy: 'outputs.QosPolicyResponse',
                 router_ip: str):
        """
        VLAN attachment details.
        :param str pairing_key: Input only. Pairing key.
        :param str peer_ip: The peer IP of the attachment.
        :param str peer_vlan_id: The peer vlan ID of the attachment.
        :param 'QosPolicyResponse' qos_policy: The QOS policy applied to this VLAN attachment. This value should be preferred to using qos at vrf level.
        :param str router_ip: The router IP of the attachment.
        """
        pulumi.set(__self__, "pairing_key", pairing_key)
        pulumi.set(__self__, "peer_ip", peer_ip)
        pulumi.set(__self__, "peer_vlan_id", peer_vlan_id)
        pulumi.set(__self__, "qos_policy", qos_policy)
        pulumi.set(__self__, "router_ip", router_ip)

    @property
    @pulumi.getter(name="pairingKey")
    def pairing_key(self) -> str:
        """
        Input only. Pairing key.
        """
        return pulumi.get(self, "pairing_key")

    @property
    @pulumi.getter(name="peerIp")
    def peer_ip(self) -> str:
        """
        The peer IP of the attachment.
        """
        return pulumi.get(self, "peer_ip")

    @property
    @pulumi.getter(name="peerVlanId")
    def peer_vlan_id(self) -> str:
        """
        The peer vlan ID of the attachment.
        """
        return pulumi.get(self, "peer_vlan_id")

    @property
    @pulumi.getter(name="qosPolicy")
    def qos_policy(self) -> 'outputs.QosPolicyResponse':
        """
        The QOS policy applied to this VLAN attachment. This value should be preferred to using qos at vrf level.
        """
        return pulumi.get(self, "qos_policy")

    @property
    @pulumi.getter(name="routerIp")
    def router_ip(self) -> str:
        """
        The router IP of the attachment.
        """
        return pulumi.get(self, "router_ip")


@pulumi.output_type
class VolumeConfigResponse(dict):
    """
    Configuration parameters for a new volume.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gcpService":
            suggest = "gcp_service"
        elif key == "lunRanges":
            suggest = "lun_ranges"
        elif key == "machineIds":
            suggest = "machine_ids"
        elif key == "nfsExports":
            suggest = "nfs_exports"
        elif key == "performanceTier":
            suggest = "performance_tier"
        elif key == "sizeGb":
            suggest = "size_gb"
        elif key == "snapshotsEnabled":
            suggest = "snapshots_enabled"
        elif key == "userNote":
            suggest = "user_note"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gcp_service: str,
                 lun_ranges: Sequence['outputs.LunRangeResponse'],
                 machine_ids: Sequence[str],
                 name: str,
                 nfs_exports: Sequence['outputs.NfsExportResponse'],
                 performance_tier: str,
                 protocol: str,
                 size_gb: int,
                 snapshots_enabled: bool,
                 type: str,
                 user_note: str):
        """
        Configuration parameters for a new volume.
        :param str gcp_service: The GCP service of the storage volume. Available gcp_service are in https://cloud.google.com/bare-metal/docs/bms-planning.
        :param Sequence['LunRangeResponse'] lun_ranges: LUN ranges to be configured. Set only when protocol is PROTOCOL_FC.
        :param Sequence[str] machine_ids: Machine ids connected to this volume. Set only when protocol is PROTOCOL_FC.
        :param str name: The name of the volume config.
        :param Sequence['NfsExportResponse'] nfs_exports: NFS exports. Set only when protocol is PROTOCOL_NFS.
        :param str performance_tier: Performance tier of the Volume. Default is SHARED.
        :param str protocol: Volume protocol.
        :param int size_gb: The requested size of this volume, in GB.
        :param bool snapshots_enabled: Whether snapshots should be enabled.
        :param str type: The type of this Volume.
        :param str user_note: User note field, it can be used by customers to add additional information for the BMS Ops team .
        """
        pulumi.set(__self__, "gcp_service", gcp_service)
        pulumi.set(__self__, "lun_ranges", lun_ranges)
        pulumi.set(__self__, "machine_ids", machine_ids)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nfs_exports", nfs_exports)
        pulumi.set(__self__, "performance_tier", performance_tier)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "size_gb", size_gb)
        pulumi.set(__self__, "snapshots_enabled", snapshots_enabled)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user_note", user_note)

    @property
    @pulumi.getter(name="gcpService")
    def gcp_service(self) -> str:
        """
        The GCP service of the storage volume. Available gcp_service are in https://cloud.google.com/bare-metal/docs/bms-planning.
        """
        return pulumi.get(self, "gcp_service")

    @property
    @pulumi.getter(name="lunRanges")
    def lun_ranges(self) -> Sequence['outputs.LunRangeResponse']:
        """
        LUN ranges to be configured. Set only when protocol is PROTOCOL_FC.
        """
        return pulumi.get(self, "lun_ranges")

    @property
    @pulumi.getter(name="machineIds")
    def machine_ids(self) -> Sequence[str]:
        """
        Machine ids connected to this volume. Set only when protocol is PROTOCOL_FC.
        """
        return pulumi.get(self, "machine_ids")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the volume config.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nfsExports")
    def nfs_exports(self) -> Sequence['outputs.NfsExportResponse']:
        """
        NFS exports. Set only when protocol is PROTOCOL_NFS.
        """
        return pulumi.get(self, "nfs_exports")

    @property
    @pulumi.getter(name="performanceTier")
    def performance_tier(self) -> str:
        """
        Performance tier of the Volume. Default is SHARED.
        """
        return pulumi.get(self, "performance_tier")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Volume protocol.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> int:
        """
        The requested size of this volume, in GB.
        """
        return pulumi.get(self, "size_gb")

    @property
    @pulumi.getter(name="snapshotsEnabled")
    def snapshots_enabled(self) -> bool:
        """
        Whether snapshots should be enabled.
        """
        return pulumi.get(self, "snapshots_enabled")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of this Volume.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userNote")
    def user_note(self) -> str:
        """
        User note field, it can be used by customers to add additional information for the BMS Ops team .
        """
        return pulumi.get(self, "user_note")


@pulumi.output_type
class VolumeResponse(dict):
    """
    A storage volume.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoGrownSizeGib":
            suggest = "auto_grown_size_gib"
        elif key == "bootVolume":
            suggest = "boot_volume"
        elif key == "currentSizeGib":
            suggest = "current_size_gib"
        elif key == "emergencySizeGib":
            suggest = "emergency_size_gib"
        elif key == "maxSizeGib":
            suggest = "max_size_gib"
        elif key == "originallyRequestedSizeGib":
            suggest = "originally_requested_size_gib"
        elif key == "performanceTier":
            suggest = "performance_tier"
        elif key == "remainingSpaceGib":
            suggest = "remaining_space_gib"
        elif key == "requestedSizeGib":
            suggest = "requested_size_gib"
        elif key == "snapshotAutoDeleteBehavior":
            suggest = "snapshot_auto_delete_behavior"
        elif key == "snapshotEnabled":
            suggest = "snapshot_enabled"
        elif key == "snapshotReservationDetail":
            suggest = "snapshot_reservation_detail"
        elif key == "snapshotSchedulePolicy":
            suggest = "snapshot_schedule_policy"
        elif key == "storageType":
            suggest = "storage_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_grown_size_gib: str,
                 boot_volume: bool,
                 current_size_gib: str,
                 emergency_size_gib: str,
                 labels: Mapping[str, str],
                 max_size_gib: str,
                 name: str,
                 notes: str,
                 originally_requested_size_gib: str,
                 performance_tier: str,
                 pod: str,
                 protocol: str,
                 remaining_space_gib: str,
                 requested_size_gib: str,
                 snapshot_auto_delete_behavior: str,
                 snapshot_enabled: bool,
                 snapshot_reservation_detail: 'outputs.SnapshotReservationDetailResponse',
                 snapshot_schedule_policy: str,
                 state: str,
                 storage_type: str):
        """
        A storage volume.
        :param str auto_grown_size_gib: The size, in GiB, that this storage volume has expanded as a result of an auto grow policy. In the absence of auto-grow, the value is 0.
        :param bool boot_volume: Whether this volume is a boot volume. A boot volume is one which contains a boot LUN.
        :param str current_size_gib: The current size of this storage volume, in GiB, including space reserved for snapshots. This size might be different than the requested size if the storage volume has been configured with auto grow or auto shrink.
        :param str emergency_size_gib: Additional emergency size that was requested for this Volume, in GiB. current_size_gib includes this value.
        :param Mapping[str, str] labels: Labels as key value pairs.
        :param str max_size_gib: Maximum size volume can be expanded to in case of evergency, in GiB.
        :param str name: The resource name of this `Volume`. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. Format: `projects/{project}/locations/{location}/volumes/{volume}`
        :param str notes: Input only. User-specified notes for new Volume. Used to provision Volumes that require manual intervention.
        :param str originally_requested_size_gib: Originally requested size, in GiB.
        :param str performance_tier: Immutable. Performance tier of the Volume. Default is SHARED.
        :param str pod: Immutable. Pod name.
        :param str protocol: Storage protocol for the Volume.
        :param str remaining_space_gib: The space remaining in the storage volume for new LUNs, in GiB, excluding space reserved for snapshots.
        :param str requested_size_gib: The requested size of this storage volume, in GiB.
        :param str snapshot_auto_delete_behavior: The behavior to use when snapshot reserved space is full.
        :param bool snapshot_enabled: Whether snapshots are enabled.
        :param 'SnapshotReservationDetailResponse' snapshot_reservation_detail: Details about snapshot space reservation and usage on the storage volume.
        :param str snapshot_schedule_policy: The name of the snapshot schedule policy in use for this volume, if any.
        :param str state: The state of this storage volume.
        :param str storage_type: The storage type for this volume.
        """
        pulumi.set(__self__, "auto_grown_size_gib", auto_grown_size_gib)
        pulumi.set(__self__, "boot_volume", boot_volume)
        pulumi.set(__self__, "current_size_gib", current_size_gib)
        pulumi.set(__self__, "emergency_size_gib", emergency_size_gib)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "max_size_gib", max_size_gib)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "notes", notes)
        pulumi.set(__self__, "originally_requested_size_gib", originally_requested_size_gib)
        pulumi.set(__self__, "performance_tier", performance_tier)
        pulumi.set(__self__, "pod", pod)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "remaining_space_gib", remaining_space_gib)
        pulumi.set(__self__, "requested_size_gib", requested_size_gib)
        pulumi.set(__self__, "snapshot_auto_delete_behavior", snapshot_auto_delete_behavior)
        pulumi.set(__self__, "snapshot_enabled", snapshot_enabled)
        pulumi.set(__self__, "snapshot_reservation_detail", snapshot_reservation_detail)
        pulumi.set(__self__, "snapshot_schedule_policy", snapshot_schedule_policy)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "storage_type", storage_type)

    @property
    @pulumi.getter(name="autoGrownSizeGib")
    def auto_grown_size_gib(self) -> str:
        """
        The size, in GiB, that this storage volume has expanded as a result of an auto grow policy. In the absence of auto-grow, the value is 0.
        """
        return pulumi.get(self, "auto_grown_size_gib")

    @property
    @pulumi.getter(name="bootVolume")
    def boot_volume(self) -> bool:
        """
        Whether this volume is a boot volume. A boot volume is one which contains a boot LUN.
        """
        return pulumi.get(self, "boot_volume")

    @property
    @pulumi.getter(name="currentSizeGib")
    def current_size_gib(self) -> str:
        """
        The current size of this storage volume, in GiB, including space reserved for snapshots. This size might be different than the requested size if the storage volume has been configured with auto grow or auto shrink.
        """
        return pulumi.get(self, "current_size_gib")

    @property
    @pulumi.getter(name="emergencySizeGib")
    def emergency_size_gib(self) -> str:
        """
        Additional emergency size that was requested for this Volume, in GiB. current_size_gib includes this value.
        """
        return pulumi.get(self, "emergency_size_gib")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels as key value pairs.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxSizeGib")
    def max_size_gib(self) -> str:
        """
        Maximum size volume can be expanded to in case of evergency, in GiB.
        """
        return pulumi.get(self, "max_size_gib")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of this `Volume`. Resource names are schemeless URIs that follow the conventions in https://cloud.google.com/apis/design/resource_names. Format: `projects/{project}/locations/{location}/volumes/{volume}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def notes(self) -> str:
        """
        Input only. User-specified notes for new Volume. Used to provision Volumes that require manual intervention.
        """
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter(name="originallyRequestedSizeGib")
    def originally_requested_size_gib(self) -> str:
        """
        Originally requested size, in GiB.
        """
        return pulumi.get(self, "originally_requested_size_gib")

    @property
    @pulumi.getter(name="performanceTier")
    def performance_tier(self) -> str:
        """
        Immutable. Performance tier of the Volume. Default is SHARED.
        """
        return pulumi.get(self, "performance_tier")

    @property
    @pulumi.getter
    def pod(self) -> str:
        """
        Immutable. Pod name.
        """
        return pulumi.get(self, "pod")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Storage protocol for the Volume.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="remainingSpaceGib")
    def remaining_space_gib(self) -> str:
        """
        The space remaining in the storage volume for new LUNs, in GiB, excluding space reserved for snapshots.
        """
        return pulumi.get(self, "remaining_space_gib")

    @property
    @pulumi.getter(name="requestedSizeGib")
    def requested_size_gib(self) -> str:
        """
        The requested size of this storage volume, in GiB.
        """
        return pulumi.get(self, "requested_size_gib")

    @property
    @pulumi.getter(name="snapshotAutoDeleteBehavior")
    def snapshot_auto_delete_behavior(self) -> str:
        """
        The behavior to use when snapshot reserved space is full.
        """
        return pulumi.get(self, "snapshot_auto_delete_behavior")

    @property
    @pulumi.getter(name="snapshotEnabled")
    def snapshot_enabled(self) -> bool:
        """
        Whether snapshots are enabled.
        """
        return pulumi.get(self, "snapshot_enabled")

    @property
    @pulumi.getter(name="snapshotReservationDetail")
    def snapshot_reservation_detail(self) -> 'outputs.SnapshotReservationDetailResponse':
        """
        Details about snapshot space reservation and usage on the storage volume.
        """
        return pulumi.get(self, "snapshot_reservation_detail")

    @property
    @pulumi.getter(name="snapshotSchedulePolicy")
    def snapshot_schedule_policy(self) -> str:
        """
        The name of the snapshot schedule policy in use for this volume, if any.
        """
        return pulumi.get(self, "snapshot_schedule_policy")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of this storage volume.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> str:
        """
        The storage type for this volume.
        """
        return pulumi.get(self, "storage_type")


