# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetWorkloadResult',
    'AwaitableGetWorkloadResult',
    'get_workload',
    'get_workload_output',
]

@pulumi.output_type
class GetWorkloadResult:
    def __init__(__self__, billing_account=None, compliance_regime=None, compliance_status=None, compliant_but_disallowed_services=None, create_time=None, display_name=None, enable_sovereign_controls=None, etag=None, kaj_enrollment_state=None, kms_settings=None, labels=None, name=None, partner=None, provisioned_resources_parent=None, resource_settings=None, resources=None, saa_enrollment_response=None):
        if billing_account and not isinstance(billing_account, str):
            raise TypeError("Expected argument 'billing_account' to be a str")
        pulumi.set(__self__, "billing_account", billing_account)
        if compliance_regime and not isinstance(compliance_regime, str):
            raise TypeError("Expected argument 'compliance_regime' to be a str")
        pulumi.set(__self__, "compliance_regime", compliance_regime)
        if compliance_status and not isinstance(compliance_status, dict):
            raise TypeError("Expected argument 'compliance_status' to be a dict")
        pulumi.set(__self__, "compliance_status", compliance_status)
        if compliant_but_disallowed_services and not isinstance(compliant_but_disallowed_services, list):
            raise TypeError("Expected argument 'compliant_but_disallowed_services' to be a list")
        pulumi.set(__self__, "compliant_but_disallowed_services", compliant_but_disallowed_services)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if enable_sovereign_controls and not isinstance(enable_sovereign_controls, bool):
            raise TypeError("Expected argument 'enable_sovereign_controls' to be a bool")
        pulumi.set(__self__, "enable_sovereign_controls", enable_sovereign_controls)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if kaj_enrollment_state and not isinstance(kaj_enrollment_state, str):
            raise TypeError("Expected argument 'kaj_enrollment_state' to be a str")
        pulumi.set(__self__, "kaj_enrollment_state", kaj_enrollment_state)
        if kms_settings and not isinstance(kms_settings, dict):
            raise TypeError("Expected argument 'kms_settings' to be a dict")
        if kms_settings is not None:
            warnings.warn("""Input only. Settings used to create a CMEK crypto key. When set, a project with a KMS CMEK key is provisioned. This field is deprecated as of Feb 28, 2022. In order to create a Keyring, callers should specify, ENCRYPTION_KEYS_PROJECT or KEYRING in ResourceSettings.resource_type field.""", DeprecationWarning)
            pulumi.log.warn("""kms_settings is deprecated: Input only. Settings used to create a CMEK crypto key. When set, a project with a KMS CMEK key is provisioned. This field is deprecated as of Feb 28, 2022. In order to create a Keyring, callers should specify, ENCRYPTION_KEYS_PROJECT or KEYRING in ResourceSettings.resource_type field.""")

        pulumi.set(__self__, "kms_settings", kms_settings)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if partner and not isinstance(partner, str):
            raise TypeError("Expected argument 'partner' to be a str")
        pulumi.set(__self__, "partner", partner)
        if provisioned_resources_parent and not isinstance(provisioned_resources_parent, str):
            raise TypeError("Expected argument 'provisioned_resources_parent' to be a str")
        pulumi.set(__self__, "provisioned_resources_parent", provisioned_resources_parent)
        if resource_settings and not isinstance(resource_settings, list):
            raise TypeError("Expected argument 'resource_settings' to be a list")
        pulumi.set(__self__, "resource_settings", resource_settings)
        if resources and not isinstance(resources, list):
            raise TypeError("Expected argument 'resources' to be a list")
        pulumi.set(__self__, "resources", resources)
        if saa_enrollment_response and not isinstance(saa_enrollment_response, dict):
            raise TypeError("Expected argument 'saa_enrollment_response' to be a dict")
        pulumi.set(__self__, "saa_enrollment_response", saa_enrollment_response)

    @property
    @pulumi.getter(name="billingAccount")
    def billing_account(self) -> str:
        """
        Optional. The billing account used for the resources which are direct children of workload. This billing account is initially associated with the resources created as part of Workload creation. After the initial creation of these resources, the customer can change the assigned billing account. The resource name has the form `billingAccounts/{billing_account_id}`. For example, `billingAccounts/012345-567890-ABCDEF`.
        """
        return pulumi.get(self, "billing_account")

    @property
    @pulumi.getter(name="complianceRegime")
    def compliance_regime(self) -> str:
        """
        Immutable. Compliance Regime associated with this workload.
        """
        return pulumi.get(self, "compliance_regime")

    @property
    @pulumi.getter(name="complianceStatus")
    def compliance_status(self) -> 'outputs.GoogleCloudAssuredworkloadsV1WorkloadComplianceStatusResponse':
        """
        Count of active Violations in the Workload.
        """
        return pulumi.get(self, "compliance_status")

    @property
    @pulumi.getter(name="compliantButDisallowedServices")
    def compliant_but_disallowed_services(self) -> Sequence[str]:
        """
        Urls for services which are compliant for this Assured Workload, but which are currently disallowed by the ResourceUsageRestriction org policy. Invoke RestrictAllowedResources endpoint to allow your project developers to use these services in their environment."
        """
        return pulumi.get(self, "compliant_but_disallowed_services")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Immutable. The Workload creation timestamp.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The user-assigned display name of the Workload. When present it must be between 4 to 30 characters. Allowed characters are: lowercase and uppercase letters, numbers, hyphen, and spaces. Example: My Workload
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enableSovereignControls")
    def enable_sovereign_controls(self) -> bool:
        """
        Optional. Indicates the sovereignty status of the given workload. Currently meant to be used by Europe/Canada customers.
        """
        return pulumi.get(self, "enable_sovereign_controls")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        Optional. ETag of the workload, it is calculated on the basis of the Workload contents. It will be used in Update & Delete operations.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="kajEnrollmentState")
    def kaj_enrollment_state(self) -> str:
        """
        Represents the KAJ enrollment state of the given workload.
        """
        return pulumi.get(self, "kaj_enrollment_state")

    @property
    @pulumi.getter(name="kmsSettings")
    def kms_settings(self) -> 'outputs.GoogleCloudAssuredworkloadsV1WorkloadKMSSettingsResponse':
        """
        Input only. Settings used to create a CMEK crypto key. When set, a project with a KMS CMEK key is provisioned. This field is deprecated as of Feb 28, 2022. In order to create a Keyring, callers should specify, ENCRYPTION_KEYS_PROJECT or KEYRING in ResourceSettings.resource_type field.
        """
        return pulumi.get(self, "kms_settings")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Optional. Labels applied to the workload.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. The resource name of the workload. Format: organizations/{organization}/locations/{location}/workloads/{workload} Read-only.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def partner(self) -> str:
        """
        Optional. Compliance Regime associated with this workload.
        """
        return pulumi.get(self, "partner")

    @property
    @pulumi.getter(name="provisionedResourcesParent")
    def provisioned_resources_parent(self) -> str:
        """
        Input only. The parent resource for the resources managed by this Assured Workload. May be either empty or a folder resource which is a child of the Workload parent. If not specified all resources are created under the parent organization. Format: folders/{folder_id}
        """
        return pulumi.get(self, "provisioned_resources_parent")

    @property
    @pulumi.getter(name="resourceSettings")
    def resource_settings(self) -> Sequence['outputs.GoogleCloudAssuredworkloadsV1WorkloadResourceSettingsResponse']:
        """
        Input only. Resource properties that are used to customize workload resources. These properties (such as custom project id) will be used to create workload resources if possible. This field is optional.
        """
        return pulumi.get(self, "resource_settings")

    @property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GoogleCloudAssuredworkloadsV1WorkloadResourceInfoResponse']:
        """
        The resources associated with this workload. These resources will be created when creating the workload. If any of the projects already exist, the workload creation will fail. Always read only.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="saaEnrollmentResponse")
    def saa_enrollment_response(self) -> 'outputs.GoogleCloudAssuredworkloadsV1WorkloadSaaEnrollmentResponseResponse':
        """
        Represents the SAA enrollment response of the given workload. SAA enrollment response is queried during GetWorkload call. In failure cases, user friendly error message is shown in SAA details page.
        """
        return pulumi.get(self, "saa_enrollment_response")


class AwaitableGetWorkloadResult(GetWorkloadResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkloadResult(
            billing_account=self.billing_account,
            compliance_regime=self.compliance_regime,
            compliance_status=self.compliance_status,
            compliant_but_disallowed_services=self.compliant_but_disallowed_services,
            create_time=self.create_time,
            display_name=self.display_name,
            enable_sovereign_controls=self.enable_sovereign_controls,
            etag=self.etag,
            kaj_enrollment_state=self.kaj_enrollment_state,
            kms_settings=self.kms_settings,
            labels=self.labels,
            name=self.name,
            partner=self.partner,
            provisioned_resources_parent=self.provisioned_resources_parent,
            resource_settings=self.resource_settings,
            resources=self.resources,
            saa_enrollment_response=self.saa_enrollment_response)


def get_workload(location: Optional[str] = None,
                 organization_id: Optional[str] = None,
                 workload_id: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkloadResult:
    """
    Gets Assured Workload associated with a CRM Node
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['organizationId'] = organization_id
    __args__['workloadId'] = workload_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:assuredworkloads/v1:getWorkload', __args__, opts=opts, typ=GetWorkloadResult).value

    return AwaitableGetWorkloadResult(
        billing_account=__ret__.billing_account,
        compliance_regime=__ret__.compliance_regime,
        compliance_status=__ret__.compliance_status,
        compliant_but_disallowed_services=__ret__.compliant_but_disallowed_services,
        create_time=__ret__.create_time,
        display_name=__ret__.display_name,
        enable_sovereign_controls=__ret__.enable_sovereign_controls,
        etag=__ret__.etag,
        kaj_enrollment_state=__ret__.kaj_enrollment_state,
        kms_settings=__ret__.kms_settings,
        labels=__ret__.labels,
        name=__ret__.name,
        partner=__ret__.partner,
        provisioned_resources_parent=__ret__.provisioned_resources_parent,
        resource_settings=__ret__.resource_settings,
        resources=__ret__.resources,
        saa_enrollment_response=__ret__.saa_enrollment_response)


@_utilities.lift_output_func(get_workload)
def get_workload_output(location: Optional[pulumi.Input[str]] = None,
                        organization_id: Optional[pulumi.Input[str]] = None,
                        workload_id: Optional[pulumi.Input[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetWorkloadResult]:
    """
    Gets Assured Workload associated with a CRM Node
    """
    ...
