/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.properties.AbstractProperty;
import net.sourceforge.pmd.properties.SingleValuePropertyDescriptor;

abstract class AbstractSingleValueProperty<T>
extends AbstractProperty<T>
implements SingleValuePropertyDescriptor<T> {
    private T defaultValue;

    protected AbstractSingleValueProperty(String theName, String theDescription, T theDefault, float theUIOrder, boolean isDefinedExternally) {
        super(theName, theDescription, theUIOrder, isDefinedExternally);
        this.defaultValue = theDefault;
    }

    @Override
    public final T defaultValue() {
        return this.defaultValue;
    }

    @Override
    public final boolean isMultiValue() {
        return false;
    }

    @Override
    public String asDelimitedString(T value) {
        return this.asString(value);
    }

    protected String asString(T value) {
        return value == null ? "" : value.toString();
    }

    @Override
    public String propertyErrorFor(Rule rule) {
        Object realValue = rule.getProperty(this);
        return realValue == null ? null : this.errorFor(realValue);
    }

    @Override
    public String errorFor(T value) {
        String typeError = this.typeErrorFor(value);
        if (typeError != null) {
            return typeError;
        }
        return this.valueErrorFor(value);
    }

    private String typeErrorFor(T value) {
        if (value != null && !this.type().isAssignableFrom(value.getClass())) {
            return value + " is not an instance of " + this.type();
        }
        return null;
    }

    protected String valueErrorFor(T value) {
        return value != null || this.defaultHasNullValue() ? null : "missing value";
    }

    private boolean defaultHasNullValue() {
        return this.defaultValue == null;
    }

    @Override
    protected final String defaultAsString() {
        return this.asString(this.defaultValue);
    }

    @Override
    public final T valueFrom(String valueString) throws IllegalArgumentException {
        return this.createFrom(valueString);
    }

    protected abstract T createFrom(String var1);
}

