/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.dfa.report;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.lang.dfa.report.AbstractReportNode;
import net.sourceforge.pmd.lang.dfa.report.ClassNode;
import net.sourceforge.pmd.lang.dfa.report.PackageNode;
import net.sourceforge.pmd.lang.dfa.report.ReportVisitor;
import net.sourceforge.pmd.lang.dfa.report.ViolationNode;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ReportHTMLPrintVisitor
extends ReportVisitor {
    private StringBuilder packageBuf = new StringBuilder(30);
    private StringBuilder classBuf = new StringBuilder(60);
    private int length;
    private String baseDir;
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");

    public ReportHTMLPrintVisitor(String baseDir) {
        this.baseDir = baseDir;
    }

    private void write(String filename, StringBuilder buf) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File(this.baseDir + FILE_SEPARATOR + filename)));
        bw.write(buf.toString(), 0, buf.length());
        IOUtils.closeQuietly((Writer)bw);
    }

    private String displayRuleViolation(RuleViolation vio) {
        StringBuilder sb = new StringBuilder(200);
        sb.append("<table border=\"0\">");
        this.renderViolationRow(sb, "Rule:", vio.getRule().getName());
        this.renderViolationRow(sb, "Description:", vio.getDescription());
        if (StringUtils.isNotBlank((CharSequence)vio.getVariableName())) {
            this.renderViolationRow(sb, "Variable:", vio.getVariableName());
        }
        if (vio.getEndLine() > 0) {
            this.renderViolationRow(sb, "Line:", vio.getEndLine() + " and " + vio.getBeginLine());
        } else {
            this.renderViolationRow(sb, "Line:", Integer.toString(vio.getBeginLine()));
        }
        sb.append("</table>");
        return sb.toString();
    }

    private void renderViolationRow(StringBuilder sb, String fieldName, String fieldData) {
        sb.append("<tr><td><b>").append(fieldName).append("</b></td><td>").append(fieldData).append("</td></tr>");
    }

    @Override
    public void visit(AbstractReportNode node) {
        if (node.getParent() == null) {
            this.packageBuf.insert(0, "<html> <head>   <title>PMD</title> </head> <body>" + PMD.EOL + "<h2>Package View</h2><table border=\"1\" align=\"center\" cellspacing=\"0\" cellpadding=\"3\"> <tr>" + PMD.EOL + "<th>Package</th><th>Class</th><th>#</th> </tr>" + PMD.EOL);
            this.length = this.packageBuf.length();
        }
        super.visit(node);
        if (node instanceof ViolationNode) {
            this.renderViolation((ViolationNode)node);
        }
        if (node instanceof ClassNode) {
            this.renderClass((ClassNode)node);
        }
        if (node instanceof PackageNode) {
            this.renderPackage((PackageNode)node);
        }
        if (node.getParent() == null) {
            this.packageBuf.append("</table> </body></html>");
            try {
                this.write("index.html", this.packageBuf);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while writing HTML report: " + e.getMessage());
            }
        }
    }

    private void renderViolation(ViolationNode vnode) {
        vnode.getParent().addNumberOfViolation(1);
        RuleViolation vio = vnode.getRuleViolation();
        this.classBuf.append("<tr> <td>" + vio.getMethodName() + "</td> <td>" + this.displayRuleViolation(vio) + "</td></tr>");
    }

    private void renderPackage(PackageNode pnode) {
        String str;
        if (pnode.getParent() == null) {
            str = "Aggregate";
        } else {
            str = pnode.getPackageName();
            pnode.getParent().addNumberOfViolation(pnode.getNumberOfViolations());
        }
        this.packageBuf.insert(this.length, "<tr><td><b>" + str + "</b></td> <td>-</td> <td>" + pnode.getNumberOfViolations() + "</td></tr>" + PMD.EOL);
    }

    private void renderClass(ClassNode cnode) {
        String str = cnode.getClassName();
        this.classBuf.insert(0, "<html><head><title>PMD - " + str + "</title></head><body>" + PMD.EOL + "<h2>Class View</h2><h3 align=\"center\">Class: " + str + "</h3><table border=\"\" align=\"center\" cellspacing=\"0\" cellpadding=\"3\"> <tr>" + PMD.EOL + "<th>Method</th><th>Violation</th> </tr>" + PMD.EOL);
        this.classBuf.append("</table> </body></html>");
        try {
            this.write(str + ".html", this.classBuf);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while writing HTML report: " + e.getMessage());
        }
        this.classBuf = new StringBuilder();
        this.packageBuf.insert(this.length, "<tr> <td>-</td> <td><a href=\"" + str + ".html\">" + str + "</a></td> <td>" + cnode.getNumberOfViolations() + "</td></tr>" + PMD.EOL);
        cnode.getParent().addNumberOfViolation(cnode.getNumberOfViolations());
    }
}

