/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cache;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import net.sourceforge.pmd.RuleViolation;
import org.apache.commons.io.IOUtils;

public class AnalysisResult {
    private final long fileChecksum;
    private final List<RuleViolation> violations;

    public AnalysisResult(long fileChecksum, List<RuleViolation> violations) {
        this.fileChecksum = fileChecksum;
        this.violations = violations;
    }

    public AnalysisResult(File sourceFile) {
        this(AnalysisResult.computeFileChecksum(sourceFile), new ArrayList<RuleViolation>());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long computeFileChecksum(File sourceFile) {
        try (CheckedInputStream stream = new CheckedInputStream(new BufferedInputStream(new FileInputStream(sourceFile)), new Adler32());){
            IOUtils.skipFully((InputStream)stream, (long)sourceFile.length());
            long l = stream.getChecksum().getValue();
            return l;
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    public long getFileChecksum() {
        return this.fileChecksum;
    }

    public List<RuleViolation> getViolations() {
        return this.violations;
    }

    public void addViolations(List<RuleViolation> violations) {
        this.violations.addAll(violations);
    }

    public void addViolation(RuleViolation ruleViolation) {
        this.violations.add(ruleViolation);
    }
}

