/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class RuleSetReference {
    private final String ruleSetFileName;
    private final boolean allRules;
    private final Set<String> excludes;

    public RuleSetReference(String theFilename, boolean allRules, Set<String> excludes) {
        this.ruleSetFileName = theFilename;
        this.allRules = allRules;
        this.excludes = Collections.unmodifiableSet(new LinkedHashSet<String>(excludes));
    }

    public RuleSetReference(String theFilename, boolean allRules) {
        this.ruleSetFileName = theFilename;
        this.allRules = allRules;
        this.excludes = Collections.emptySet();
    }

    public RuleSetReference(String theFilename) {
        this(theFilename, false);
    }

    public String getRuleSetFileName() {
        return this.ruleSetFileName;
    }

    public boolean isAllRules() {
        return this.allRules;
    }

    public Set<String> getExcludes() {
        return this.excludes;
    }
}

