/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import java.util.function.Function;
import org.reactfx.EventStream;
import org.reactfx.EventStreamBase;
import org.reactfx.Subscription;

class FlatMapStream<T, U>
extends EventStreamBase<U> {
    private final EventStream<T> source;
    private final Function<? super T, ? extends EventStream<U>> mapper;
    private Subscription mappedSubscription = Subscription.EMPTY;

    public FlatMapStream(EventStream<T> src, Function<? super T, ? extends EventStream<U>> f) {
        this.source = src;
        this.mapper = f;
    }

    @Override
    protected Subscription observeInputs() {
        Subscription s = this.source.subscribe(t -> {
            this.mappedSubscription.unsubscribe();
            this.mappedSubscription = this.mapper.apply(t).subscribe(this::emit);
        });
        return () -> {
            s.unsubscribe();
            this.mappedSubscription.unsubscribe();
            this.mappedSubscription = Subscription.EMPTY;
        };
    }
}

