/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.ArrayDeque;
import java.util.Deque;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTCatchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.BooleanProperty;
import net.sourceforge.pmd.properties.IntegerProperty;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class StdCyclomaticComplexityRule
extends AbstractJavaRule {
    public static final IntegerProperty REPORT_LEVEL_DESCRIPTOR = ((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)IntegerProperty.named((String)"reportLevel").desc("Cyclomatic Complexity reporting threshold")).range((Object)1, (Object)30)).defaultValue((Object)10)).uiOrder(1.0f)).build();
    public static final BooleanProperty SHOW_CLASSES_COMPLEXITY_DESCRIPTOR = new BooleanProperty("showClassesComplexity", "Add class average violations to the report", true, 2.0f);
    public static final BooleanProperty SHOW_METHODS_COMPLEXITY_DESCRIPTOR = new BooleanProperty("showMethodsComplexity", "Add method average violations to the report", true, 3.0f);
    private int reportLevel;
    private boolean showClassesComplexity = true;
    private boolean showMethodsComplexity = true;
    protected Deque<Entry> entryStack = new ArrayDeque<Entry>();

    public StdCyclomaticComplexityRule() {
        this.definePropertyDescriptor((PropertyDescriptor)REPORT_LEVEL_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)SHOW_CLASSES_COMPLEXITY_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)SHOW_METHODS_COMPLEXITY_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.reportLevel = (Integer)this.getProperty((PropertyDescriptor)REPORT_LEVEL_DESCRIPTOR);
        this.showClassesComplexity = (Boolean)this.getProperty((PropertyDescriptor)SHOW_CLASSES_COMPLEXITY_DESCRIPTOR);
        this.showMethodsComplexity = (Boolean)this.getProperty((PropertyDescriptor)SHOW_METHODS_COMPLEXITY_DESCRIPTOR);
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTIfStatement node, Object data) {
        this.entryStack.peek().bumpDecisionPoints();
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTCatchStatement node, Object data) {
        this.entryStack.peek().bumpDecisionPoints();
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTForStatement node, Object data) {
        this.entryStack.peek().bumpDecisionPoints();
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTDoStatement node, Object data) {
        this.entryStack.peek().bumpDecisionPoints();
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTSwitchStatement node, Object data) {
        Entry entry = this.entryStack.peek();
        int childCount = node.jjtGetNumChildren();
        int lastIndex = childCount - 1;
        for (int n = 0; n < lastIndex; ++n) {
            ASTSwitchLabel sl;
            Node childNode = node.jjtGetChild(n);
            if (!(childNode instanceof ASTSwitchLabel) || (sl = (ASTSwitchLabel)childNode).isDefault() || !((childNode = node.jjtGetChild(n + 1)) instanceof ASTBlockStatement)) continue;
            entry.bumpDecisionPoints();
        }
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTWhileStatement node, Object data) {
        this.entryStack.peek().bumpDecisionPoints();
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTConditionalExpression node, Object data) {
        if (node.isTernary()) {
            this.entryStack.peek().bumpDecisionPoints();
            super.visit(node, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        this.entryStack.push(new Entry(node));
        super.visit(node, data);
        Entry classEntry = this.entryStack.pop();
        if (this.showClassesComplexity && (classEntry.getComplexityAverage() >= this.reportLevel || classEntry.highestDecisionPoints >= this.reportLevel)) {
            this.addViolation(data, node, new String[]{"class", node.getImage(), classEntry.getComplexityAverage() + " (Highest = " + classEntry.highestDecisionPoints + ')'});
        }
        return data;
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        this.entryStack.push(new Entry(node));
        super.visit(node, data);
        Entry methodEntry = this.entryStack.pop();
        if (!this.isSuppressed(node)) {
            int methodDecisionPoints = methodEntry.decisionPoints;
            Entry classEntry = this.entryStack.peek();
            ++classEntry.methodCount;
            classEntry.bumpDecisionPoints(methodDecisionPoints);
            if (methodDecisionPoints > classEntry.highestDecisionPoints) {
                classEntry.highestDecisionPoints = methodDecisionPoints;
            }
            ASTMethodDeclarator methodDeclarator = null;
            for (int n = 0; n < node.jjtGetNumChildren(); ++n) {
                Node childNode = node.jjtGetChild(n);
                if (!(childNode instanceof ASTMethodDeclarator)) continue;
                methodDeclarator = (ASTMethodDeclarator)childNode;
                break;
            }
            if (this.showMethodsComplexity && methodEntry.decisionPoints >= this.reportLevel) {
                this.addViolation(data, node, new String[]{"method", methodDeclarator == null ? "" : methodDeclarator.getImage(), String.valueOf(methodEntry.decisionPoints)});
            }
        }
        return data;
    }

    @Override
    public Object visit(ASTEnumDeclaration node, Object data) {
        this.entryStack.push(new Entry(node));
        super.visit(node, data);
        Entry classEntry = this.entryStack.pop();
        if (classEntry.getComplexityAverage() >= this.reportLevel || classEntry.highestDecisionPoints >= this.reportLevel) {
            this.addViolation(data, node, new String[]{"class", node.getImage(), classEntry.getComplexityAverage() + "(Highest = " + classEntry.highestDecisionPoints + ')'});
        }
        return data;
    }

    @Override
    public Object visit(ASTConstructorDeclaration node, Object data) {
        this.entryStack.push(new Entry(node));
        super.visit(node, data);
        Entry constructorEntry = this.entryStack.pop();
        if (!this.isSuppressed(node)) {
            int constructorDecisionPointCount = constructorEntry.decisionPoints;
            Entry classEntry = this.entryStack.peek();
            ++classEntry.methodCount;
            classEntry.decisionPoints += constructorDecisionPointCount;
            if (constructorDecisionPointCount > classEntry.highestDecisionPoints) {
                classEntry.highestDecisionPoints = constructorDecisionPointCount;
            }
            if (this.showMethodsComplexity && constructorEntry.decisionPoints >= this.reportLevel) {
                this.addViolation(data, node, new String[]{"constructor", classEntry.node.getImage(), String.valueOf(constructorDecisionPointCount)});
            }
        }
        return data;
    }

    protected static class Entry {
        private Node node;
        private int decisionPoints = 1;
        public int highestDecisionPoints;
        public int methodCount;

        private Entry(Node node) {
            this.node = node;
        }

        public void bumpDecisionPoints() {
            ++this.decisionPoints;
        }

        public void bumpDecisionPoints(int size) {
            this.decisionPoints += size;
        }

        public int getComplexityAverage() {
            return (double)this.methodCount == 0.0 ? 1 : (int)Math.rint((double)this.decisionPoints / (double)this.methodCount);
        }
    }
}

