/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTEnumConstant;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.typeresolution.TypeHelper;
import net.sourceforge.pmd.properties.BooleanProperty;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.RegexProperty;
import net.sourceforge.pmd.util.StringUtil;

public class MethodNamingConventionsRule
extends AbstractJavaRule {
    private static final Map<String, String> DESCRIPTOR_TO_DISPLAY_NAME = new HashMap<String, String>();
    @Deprecated
    private static final BooleanProperty CHECK_NATIVE_METHODS_DESCRIPTOR = new BooleanProperty("checkNativeMethods", "deprecated! Check native methods", true, 1.0f);
    private static final RegexProperty INSTANCE_REGEX = ((RegexProperty.RegexPBuilder)MethodNamingConventionsRule.defaultProp("method").desc("Regex which applies to instance method names")).build();
    private static final RegexProperty STATIC_REGEX = MethodNamingConventionsRule.defaultProp("static").build();
    private static final RegexProperty NATIVE_REGEX = MethodNamingConventionsRule.defaultProp("native").build();
    private static final RegexProperty JUNIT3_REGEX = MethodNamingConventionsRule.defaultProp("JUnit 3 test").defaultValue("test[A-Z0-9][a-zA-Z0-9]*").build();
    private static final RegexProperty JUNIT4_REGEX = MethodNamingConventionsRule.defaultProp("JUnit 4 test").build();

    public MethodNamingConventionsRule() {
        this.definePropertyDescriptor((PropertyDescriptor)CHECK_NATIVE_METHODS_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)INSTANCE_REGEX);
        this.definePropertyDescriptor((PropertyDescriptor)STATIC_REGEX);
        this.definePropertyDescriptor((PropertyDescriptor)NATIVE_REGEX);
        this.definePropertyDescriptor((PropertyDescriptor)JUNIT3_REGEX);
        this.definePropertyDescriptor((PropertyDescriptor)JUNIT4_REGEX);
    }

    private void checkMatches(ASTMethodDeclaration node, PropertyDescriptor<Pattern> regex, Object data) {
        if (!((Pattern)this.getProperty(regex)).matcher(node.getMethodName()).matches()) {
            this.addViolation(data, (Node)node.getMethodDeclarator(), new Object[]{DESCRIPTOR_TO_DISPLAY_NAME.get(regex.name()) + " method", node.getMethodName(), ((Pattern)this.getProperty(regex)).toString()});
        }
    }

    private boolean isJunit4Test(ASTMethodDeclaration node) {
        return node.isAnnotationPresent("org.junit.Test");
    }

    private boolean isJunit3Test(ASTMethodDeclaration node) {
        if (!node.getMethodName().startsWith("test")) {
            return false;
        }
        Node parent = (Node)node.getFirstParentOfAnyType(new Class[]{ASTEnumConstant.class, ASTAllocationExpression.class, ASTAnyTypeDeclaration.class});
        if (!(parent instanceof ASTClassOrInterfaceDeclaration) || ((ASTClassOrInterfaceDeclaration)parent).isInterface()) {
            return false;
        }
        ASTClassOrInterfaceType superClass = ((ASTClassOrInterfaceDeclaration)parent).getSuperClassTypeNode();
        return superClass != null && TypeHelper.isA((TypeNode)superClass, "junit.framework.TestCase");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        if (node.isAnnotationPresent("java.lang.Override")) {
            return super.visit(node, data);
        }
        if (node.isNative()) {
            if (!((Boolean)this.getProperty((PropertyDescriptor)CHECK_NATIVE_METHODS_DESCRIPTOR)).booleanValue()) return super.visit(node, data);
            this.checkMatches(node, (PropertyDescriptor<Pattern>)NATIVE_REGEX, data);
            return super.visit(node, data);
        } else if (node.isStatic()) {
            this.checkMatches(node, (PropertyDescriptor<Pattern>)STATIC_REGEX, data);
            return super.visit(node, data);
        } else if (this.isJunit4Test(node)) {
            this.checkMatches(node, (PropertyDescriptor<Pattern>)JUNIT4_REGEX, data);
            return super.visit(node, data);
        } else if (this.isJunit3Test(node)) {
            this.checkMatches(node, (PropertyDescriptor<Pattern>)JUNIT3_REGEX, data);
            return super.visit(node, data);
        } else {
            this.checkMatches(node, (PropertyDescriptor<Pattern>)INSTANCE_REGEX, data);
        }
        return super.visit(node, data);
    }

    private static RegexProperty.RegexPBuilder defaultProp(String displayName) {
        String propName = StringUtil.toCamelCase((String)displayName, (boolean)true) + "Pattern";
        DESCRIPTOR_TO_DISPLAY_NAME.put(propName, displayName);
        return ((RegexProperty.RegexPBuilder)RegexProperty.named((String)propName).desc("Regex which applies to " + displayName.trim() + " method names")).defaultValue("[a-z][a-zA-Z0-9]+");
    }
}

