/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule;

import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.rule.regex.RegexHelper;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.StringProperty;

public class GenericLiteralCheckerRule
extends AbstractJavaRule {
    private Pattern pattern;
    private static final String PROPERTY_NAME = "regexPattern";
    private static final StringProperty REGEX_PROPERTY = new StringProperty("regexPattern", "Regular expression", "", 1.0f);

    public GenericLiteralCheckerRule() {
        this.definePropertyDescriptor((PropertyDescriptor)REGEX_PROPERTY);
    }

    private void init() {
        if (this.pattern == null) {
            String stringPattern = (String)super.getProperty((PropertyDescriptor)REGEX_PROPERTY);
            if (stringPattern != null && stringPattern.length() > 0) {
                this.pattern = Pattern.compile(stringPattern);
            } else {
                throw new IllegalArgumentException("Must provide a value for the 'regexPattern' property.");
            }
        }
    }

    @Override
    public Object visit(ASTLiteral node, Object data) {
        this.init();
        String image = node.getImage();
        if (image != null && image.length() > 0 && RegexHelper.isMatch(this.pattern, image)) {
            this.addViolation(data, node);
        }
        return data;
    }
}

