/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.Reader;
import java.io.StringReader;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.cpd.token.JavaCCTokenFilter;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.ast.TokenMgrError;
import net.sourceforge.pmd.lang.objectivec.ast.Token;
import org.apache.commons.io.IOUtils;

public class ObjectiveCTokenizer
implements Tokenizer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tokenize(SourceCode sourceCode, Tokens tokenEntries) {
        StringBuilder buffer = sourceCode.getCodeBuffer();
        StringReader reader = null;
        try {
            LanguageVersionHandler languageVersionHandler = LanguageRegistry.getLanguage((String)"Objective-C").getDefaultVersion().getLanguageVersionHandler();
            reader = new StringReader(buffer.toString());
            JavaCCTokenFilter tokenFilter = new JavaCCTokenFilter(languageVersionHandler.getParser(languageVersionHandler.getDefaultParserOptions()).getTokenManager(sourceCode.getFileName(), (Reader)reader));
            Token currentToken = (Token)tokenFilter.getNextToken();
            while (currentToken != null) {
                tokenEntries.add(new TokenEntry(currentToken.image, sourceCode.getFileName(), currentToken.beginLine));
                currentToken = (Token)tokenFilter.getNextToken();
            }
            tokenEntries.add(TokenEntry.getEOF());
            System.err.println("Added " + sourceCode.getFileName());
        }
        catch (TokenMgrError err) {
            try {
                err.printStackTrace();
                System.err.println("Skipping " + sourceCode.getFileName() + " due to parse error");
                tokenEntries.add(TokenEntry.getEOF());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)reader);
        }
        IOUtils.closeQuietly((Reader)reader);
    }
}

