/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.util.fxdesigner.DesignerRoot;
import net.sourceforge.pmd.util.fxdesigner.MainDesignerController;
import net.sourceforge.pmd.util.fxdesigner.model.ASTManager;
import net.sourceforge.pmd.util.fxdesigner.model.ParseAbortedException;
import net.sourceforge.pmd.util.fxdesigner.util.beans.SettingsOwner;
import net.sourceforge.pmd.util.fxdesigner.util.beans.SettingsPersistenceUtil;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.AvailableSyntaxHighlighters;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.CustomCodeArea;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.SyntaxHighlighter;
import net.sourceforge.pmd.util.fxdesigner.util.controls.ASTTreeItem;
import org.apache.commons.lang3.StringUtils;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.LineNumberFactory;
import org.reactfx.EventStreams;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

public class SourceEditorController
implements Initializable,
SettingsOwner {
    private final MainDesignerController parent;
    @FXML
    private Label astTitleLabel;
    @FXML
    private TreeView<Node> astTreeView;
    @FXML
    private CustomCodeArea codeEditorArea;
    private ASTManager astManager;

    public SourceEditorController(DesignerRoot owner, MainDesignerController mainController) {
        this.parent = mainController;
        this.astManager = new ASTManager(owner);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.languageVersionProperty().values().filterMap(Objects::nonNull, LanguageVersion::getLanguage).distinct().subscribe(this::updateSyntaxHighlighter);
        EventStreams.valuesOf((ObservableValue)this.astTreeView.getSelectionModel().selectedItemProperty()).filterMap(Objects::nonNull, TreeItem::getValue).subscribe(this.parent::onNodeItemSelected);
        this.codeEditorArea.setParagraphGraphicFactory(LineNumberFactory.get((GenericStyledArea)this.codeEditorArea));
    }

    public void refreshAST() {
        Node current;
        String source = this.getText();
        Node previous = this.getCompilationUnit();
        if (StringUtils.isBlank((CharSequence)source)) {
            this.astTreeView.setRoot(null);
            return;
        }
        try {
            current = this.astManager.updateCompilationUnit(source);
        }
        catch (ParseAbortedException e) {
            this.invalidateAST(true);
            return;
        }
        if (!Objects.equals(previous, current)) {
            this.parent.invalidateAst();
            this.setUpToDateCompilationUnit(current);
        }
    }

    private void setUpToDateCompilationUnit(Node node) {
        this.astTitleLabel.setText("Abstract Syntax Tree");
        ASTTreeItem root = ASTTreeItem.getRoot(node);
        this.astTreeView.setRoot((TreeItem)root);
    }

    public void shutdown() {
        this.codeEditorArea.disableSyntaxHighlighting();
    }

    private void updateSyntaxHighlighter(Language language) {
        Optional<SyntaxHighlighter> highlighter = AvailableSyntaxHighlighters.getHighlighterForLanguage(language);
        if (highlighter.isPresent()) {
            this.codeEditorArea.setSyntaxHighlightingEnabled(highlighter.get());
        } else {
            this.codeEditorArea.disableSyntaxHighlighting();
        }
    }

    public void clearNodeHighlight() {
        this.codeEditorArea.clearPrimaryStyleLayer();
    }

    public void highlightNodePrimary(Node node) {
        this.highlightNodes(Collections.singleton(node), Collections.singleton("primary-highlight"));
    }

    private void highlightNodes(Collection<? extends Node> nodes, Set<String> cssClasses) {
        for (Node node : nodes) {
            if (this.codeEditorArea.isInRange(node)) {
                this.codeEditorArea.styleCss(node, cssClasses);
                this.codeEditorArea.paintCss();
                this.codeEditorArea.moveTo(node.getBeginLine() - 1, 0);
                this.codeEditorArea.requestFollowCaret();
                continue;
            }
            this.codeEditorArea.clearPrimaryStyleLayer();
        }
    }

    public void highlightNodesSecondary(Collection<? extends Node> nodes) {
        this.highlightNodes(nodes, Collections.singleton("secondary-highlight"));
    }

    public void focusNodeInTreeView(Node node) {
        ASTTreeItem found = ((ASTTreeItem)this.astTreeView.getRoot()).findItem(node);
        if (found != null) {
            MultipleSelectionModel selectionModel = this.astTreeView.getSelectionModel();
            selectionModel.select((Object)found);
            this.astTreeView.getFocusModel().focus(selectionModel.getSelectedIndex());
        }
    }

    private void invalidateAST(boolean error) {
        this.astTitleLabel.setText("Abstract syntax tree (" + (error ? "error" : "outdated") + ")");
    }

    public void moveCaret(int line, int column) {
        this.codeEditorArea.moveTo(line, column);
        this.codeEditorArea.requestFollowCaret();
    }

    @SettingsPersistenceUtil.PersistentProperty
    public LanguageVersion getLanguageVersion() {
        return this.astManager.getLanguageVersion();
    }

    public void setLanguageVersion(LanguageVersion version) {
        this.astManager.setLanguageVersion(version);
    }

    public Var<LanguageVersion> languageVersionProperty() {
        return this.astManager.languageVersionProperty();
    }

    public Node getCompilationUnit() {
        return this.astManager.getCompilationUnit();
    }

    public Val<Node> compilationUnitProperty() {
        return this.astManager.compilationUnitProperty();
    }

    @SettingsPersistenceUtil.PersistentProperty
    public String getText() {
        return this.codeEditorArea.getText();
    }

    public void setText(String expression) {
        this.codeEditorArea.replaceText(expression);
    }

    public Val<String> textProperty() {
        return Val.wrap((ObservableValue)this.codeEditorArea.textProperty());
    }

    public void clearStyleLayers() {
        this.codeEditorArea.clearStyleLayers();
    }
}

