/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner;

import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;
import net.sourceforge.pmd.util.fxdesigner.DesignerRoot;
import net.sourceforge.pmd.util.fxdesigner.model.LogEntry;

public class EventLogController
implements Initializable {
    private final DesignerRoot designerRoot;
    @FXML
    private TableView<LogEntry> eventLogTableView;
    @FXML
    private TableColumn<LogEntry, Date> logDateColumn;
    @FXML
    private TableColumn<LogEntry, LogEntry.Category> logCategoryColumn;
    @FXML
    private TableColumn<LogEntry, String> logMessageColumn;
    @FXML
    private TextArea logDetailsTextArea;

    public EventLogController(DesignerRoot owner) {
        this.designerRoot = owner;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.logCategoryColumn.setCellValueFactory((Callback)new PropertyValueFactory("category"));
        this.logMessageColumn.setCellValueFactory((Callback)new PropertyValueFactory("message"));
        final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        this.logDateColumn.setCellValueFactory(entry -> new SimpleObjectProperty((Object)((LogEntry)entry.getValue()).getTimestamp()));
        this.logDateColumn.setCellFactory(column -> new TableCell<LogEntry, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                    this.setGraphic(null);
                } else {
                    this.setText(dateFormat.format(item));
                }
            }
        });
        this.eventLogTableView.setItems(this.designerRoot.getLogger().getLog());
        this.eventLogTableView.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> this.logDetailsTextArea.setText(newVal == null ? "" : newVal.getStackTrace()));
        this.eventLogTableView.resizeColumn(this.logMessageColumn, -1.0);
        this.logMessageColumn.prefWidthProperty().bind((ObservableValue)this.eventLogTableView.widthProperty().subtract(this.logCategoryColumn.getPrefWidth()).subtract(this.logDateColumn.getPrefWidth()).subtract(2));
        this.logDateColumn.setSortType(TableColumn.SortType.DESCENDING);
    }
}

