/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class MoreSets {
    private static final Class<?> UNMODIFIABLE_SET = Collections.unmodifiableSet(Collections.emptySet()).getClass();

    private MoreSets() {
    }

    @SafeVarargs
    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... elements) {
        LinkedHashSet set = new LinkedHashSet(elements.length);
        Collections.addAll(set, elements);
        return set;
    }

    public static boolean isImmutableSet(Set<?> set) {
        return set != null && (set instanceof ImmutableSet || set == Collections.emptySet() || set.getClass() == UNMODIFIABLE_SET);
    }

    public static <T> Set<T> toImmutableSet(Set<T> set) {
        if (MoreSets.isImmutableSet(set)) {
            return set;
        }
        return MoreSets.isNullOrEmpty(set) ? Collections.emptySet() : Collections.unmodifiableSet(set);
    }

    public static <T> Set<T> toEmptySet(Set<T> set) {
        return MoreSets.isNullOrEmpty(set) ? Collections.emptySet() : set;
    }

    public static <T> boolean isNullOrEmpty(Set<T> set) {
        return set == null || set.isEmpty();
    }

    public static <T> Collector<T, ?, Set<T>> toImmutableSet() {
        return Collectors.collectingAndThen(Collectors.toSet(), MoreSets::toImmutableSet);
    }

    public static <T> Collector<T, HashSet<T>, Set<T>> toImmutableSet(int initializedSize) {
        return Collector.of(() -> new HashSet(initializedSize), HashSet::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, MoreSets::toImmutableSet, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, HashSet<T>, Set<T>> toImmutableOrderedSet() {
        return Collector.of(LinkedHashSet::new, HashSet::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, MoreSets::toImmutableSet, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, HashSet<T>, Set<T>> toImmutableOrderedSet(int initializedSize) {
        return Collector.of(() -> new LinkedHashSet(initializedSize), HashSet::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, MoreSets::toImmutableSet, new Collector.Characteristics[0]);
    }
}

