/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.ast;

import apex.common.base.MoreStrings;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.ForControl;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.PrinterFactory;
import apex.jorje.services.printers.ast.OptionalPrinter;
import java.util.Optional;

public class ForControlPrinter
implements Printer<ForControl> {
    private final PrinterFactory factory;
    private final Printer<TypeRef> typeRefPrinter;

    public ForControlPrinter(PrinterFactory factory) {
        this.factory = factory;
        this.typeRefPrinter = factory.typeRefPrinter();
    }

    @Override
    public String print(ForControl x, final PrintContext ctx) {
        final Printer<Optional<Expr>> optionalExpr = OptionalPrinter.create(this.factory.exprPrinter(), "", " ", "");
        return x.match(new ForControl.MatchBlock<String>(){

            @Override
            public String _case(ForControl.EnhancedForControl x) {
                StringBuilder builder = new StringBuilder();
                x.type.ifPresent(value -> builder.append(ForControlPrinter.this.typeRefPrinter.print(value, ctx)).append(" "));
                assert (x.init.expr.isPresent()) : "this should not be empty";
                builder.append(ForControlPrinter.this.factory.identifiersPrinter().print(x.init.name, ctx)).append(" : ").append(ForControlPrinter.this.factory.exprPrinter().print(x.init.expr.get(), ctx));
                return builder.toString();
            }

            @Override
            public String _case(ForControl.CStyleForControl x) {
                StringBuilder builder = new StringBuilder();
                Printer<Optional<Expr>> assignmentOptionalExpr = OptionalPrinter.create(ForControlPrinter.this.factory.exprPrinter(), "", " = ", "");
                x.inits.ifPresent(value -> {
                    value.type.ifPresent(type -> builder.append(ForControlPrinter.this.typeRefPrinter.print(type, ctx)).append(" "));
                    builder.append(value.inits.stream().map(init -> ForControlPrinter.this.factory.identifiersPrinter().print(init.name, ctx) + assignmentOptionalExpr.print(init.expr, ctx)).collect(MoreStrings.ON_COMMA_AND_SPACE));
                });
                builder.append(";");
                builder.append(optionalExpr.print(x.condition, ctx));
                builder.append(";");
                builder.append(optionalExpr.print(x.control, ctx));
                return builder.toString();
            }
        });
    }
}

