/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.visibility.legacy;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.semantic.symbol.visibility.legacy.ReferenceExpressionLegacyVisibility;
import apex.jorje.semantic.symbol.visibility.legacy.loopholes.PropertyLoophole;
import apex.jorje.semantic.symbol.visibility.legacy.loopholes.PropertyLoopholes;
import apex.jorje.services.Version;

public class LegacyVisibility {
    public static boolean isPropertyVisible(AccessEvaluator accessEvaluator, AstNode referencingNode, Variable variable, Visibility.ReferencedFromTestMethod referencedFromTestMethod, Visibility.CheckType checkType) {
        return variable.getMemberType() == Member.Type.PROPERTY && (LegacyVisibility.isPropertyPublicAndVisibleToOtherNamespaces(referencingNode.getDefiningType().getCodeUnitDetails().getVersion(), variable, checkType) || LegacyVisibility.isPropertyLegacyVisible(accessEvaluator, referencingNode, variable, referencedFromTestMethod, checkType));
    }

    public static boolean isReferenceExpressionVisible(AccessEvaluator accessEvaluator, AstNode referencingNode, Variable variable, Visibility.ReferencedFromTestMethod referencedFromTestMethod, Visibility.CheckType checkType, VariableVisitor.Context context) {
        return !context.isLast && (ReferenceExpressionLegacyVisibility.isReferenceExpressionVisiblePre182(accessEvaluator, referencingNode.getDefiningType(), variable, referencedFromTestMethod, checkType) || ReferenceExpressionLegacyVisibility.isSObjectReferenceExpressionVisible(referencingNode, context.referenceType));
    }

    private static boolean isPropertyPublicAndVisibleToOtherNamespaces(Version referencingTypeVersion, Variable property, Visibility.CheckType checkType) {
        ModifierGroup accessorModifiers = property.accept(Visibility.GET_VARIABLE_MODIFIERS, checkType);
        return accessorModifiers.has(ModifierTypeInfos.PUBLIC) && referencingTypeVersion.isLessThan(Version.V160);
    }

    private static boolean isPropertyLegacyVisible(AccessEvaluator accessEvaluator, AstNode referencingNode, Variable property, Visibility.ReferencedFromTestMethod referencedFromTestMethod, Visibility.CheckType checkType) {
        for (PropertyLoophole loophole : PropertyLoopholes.ALL) {
            Version definingTypeVersion = property.getDefiningType().getCodeUnitDetails().getVersion();
            Version referencingTypeVersion = referencingNode.getDefiningType().getCodeUnitDetails().getVersion();
            boolean isLoopholeApplicable = loophole.isApplicableForCheckType(checkType) && loophole.isApplicableForDefiningTypeVersion(definingTypeVersion) && loophole.isApplicableForReferencingTypeVersion(referencingTypeVersion);
            if (!isLoopholeApplicable || !loophole.isVisibleThroughLoophole(accessEvaluator, property, referencingNode, referencedFromTestMethod)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMemberTestVisibleViaLegacyBehavior(TypeInfo referencingType, Member member, Visibility.ReferencedFromTestMethod referencedFromTestMethod) {
        Version referencingTypeVersion = referencingType.getCodeUnitDetails().getVersion();
        Version memberVersion = member.getDefiningType().getCodeUnitDetails().getVersion();
        if (referencingTypeVersion.isGreaterThan(Version.COMPILER_RELEASE) || memberVersion.isGreaterThan(Version.COMPILER_RELEASE)) {
            return false;
        }
        TypeInfo memberDefiningType = member.getDefiningType();
        return LegacyVisibility.isStaticFieldOrMethod(member) && Visibility.isMemberTestVisible(referencingType, memberDefiningType, memberDefiningType.getModifiers(), referencedFromTestMethod);
    }

    private static boolean isStaticFieldOrMethod(Member member) {
        Member.Type memberType = member.getMemberType();
        return (memberType == Member.Type.FIELD || memberType == Member.Type.METHOD) && member.getModifiers().has(ModifierTypeInfos.STATIC);
    }
}

