/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.visibility;

import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.StandardAnnotationsUtil;
import apex.jorje.semantic.bcl.validators.JavaSfdcOnlyAnnotation;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.compiler.sfdc.PlaceholderOrgPerm;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;

public class VisibilityUtil {
    public static int getScore(ModifierGroup modifiers) {
        if (modifiers.has(ModifierTypeInfos.GLOBAL)) {
            return 4;
        }
        if (modifiers.has(ModifierTypeInfos.PUBLIC)) {
            return 3;
        }
        if (modifiers.has(ModifierTypeInfos.PROTECTED)) {
            return 2;
        }
        return 0;
    }

    public static ModifierTypeInfo getHighestVisibilityModifier(ModifierGroup modifiers) {
        if (modifiers.has(ModifierTypeInfos.GLOBAL)) {
            return ModifierTypeInfos.GLOBAL;
        }
        if (modifiers.has(ModifierTypeInfos.PUBLIC)) {
            return ModifierTypeInfos.PUBLIC;
        }
        if (modifiers.has(ModifierTypeInfos.PROTECTED)) {
            return ModifierTypeInfos.PROTECTED;
        }
        return ModifierTypeInfos.PRIVATE;
    }

    public static boolean isLowerForOverride(ModifierGroup parent, ModifierGroup child) {
        int parentScore = VisibilityUtil.getScore(parent);
        int childScore = VisibilityUtil.getScore(child);
        int modifiedParentScore = parentScore == 4 ? 3 : parentScore;
        return modifiedParentScore > childScore;
    }

    public static boolean isTypeSfdcOnlyVisible(SymbolResolver symbols, TypeInfo referencingType, TypeInfo targetType) {
        return !targetType.getModifiers().has(AnnotationTypeInfos.SFDC_ONLY) || VisibilityUtil.isApexTrusted(symbols.getAccessEvaluator(), referencingType);
    }

    static boolean isApexTrusted(AccessEvaluator accessEvaluator, TypeInfo type) {
        return type.getCodeUnitDetails().isTrusted() || accessEvaluator.hasInternalSfdc();
    }

    static boolean isMemberSfdcOnlyVisible(AccessEvaluator accessEvaluator, TypeInfo referencingType, TypeInfo memberDefiningType, ModifierGroup memberModifiers, JavaSfdcOnlyAnnotation methodJavaSfdcOnlyAnnotation) {
        if (methodJavaSfdcOnlyAnnotation != null) {
            if (methodJavaSfdcOnlyAnnotation.isAllowOnlyInTesting() && !accessEvaluator.isRunningTests()) {
                return false;
            }
            if (methodJavaSfdcOnlyAnnotation.isAllowOnlyInRealTesting() && !accessEvaluator.isReallyRunningTests()) {
                return false;
            }
            if (accessEvaluator.isSfdc()) {
                return true;
            }
            if (methodJavaSfdcOnlyAnnotation.isAllowTesting() && accessEvaluator.isRunningTests()) {
                return true;
            }
            if (methodJavaSfdcOnlyAnnotation.isAllowInternalSfdc() && accessEvaluator.hasInternalSfdc()) {
                return true;
            }
            if (methodJavaSfdcOnlyAnnotation.isAllowTrustedApplications() && accessEvaluator.isTrustedApplication(referencingType)) {
                return true;
            }
            if (methodJavaSfdcOnlyAnnotation.isAllowInApexFiles() && accessEvaluator.isAccessibleSystemNamespace(referencingType.getNamespace())) {
                return true;
            }
            return methodJavaSfdcOnlyAnnotation.isAllowPrivate() && accessEvaluator.hasPrivateApi() && accessEvaluator.hasLocalizedTranslation();
        }
        if (memberDefiningType.getModifiers().has(AnnotationTypeInfos.SFDC_ONLY) && !VisibilityUtil.isApexTrusted(accessEvaluator, referencingType) && !StandardAnnotationsUtil.isSfdcOnlyExplicitlyDisabled(memberModifiers)) {
            return false;
        }
        return !StandardAnnotationsUtil.isSfdcOnlyEnabled(memberModifiers) || VisibilityUtil.isApexTrusted(accessEvaluator, referencingType);
    }

    public static boolean isMethodPrivateApiVisible(AccessEvaluator accessEvaluator, ModifierGroup methodModifiers, ModifierGroup methodDefiningTypeModifiers) {
        return !methodModifiers.has(AnnotationTypeInfos.PRIVATE_API) && !methodDefiningTypeModifiers.has(AnnotationTypeInfos.PRIVATE_API) || accessEvaluator.hasPermission(PlaceholderOrgPerm.PRIVATE_API);
    }

    static boolean isMethodAllowCertifiedApexVisible(TypeInfo referencingType, AccessEvaluator accessEvaluator, ModifierGroup methodModifiers, ModifierGroup methodDefiningTypeModifiers) {
        return !methodModifiers.has(AnnotationTypeInfos.ALLOW_CERTIFIED_APEX) && !methodDefiningTypeModifiers.has(AnnotationTypeInfos.ALLOW_CERTIFIED_APEX) || accessEvaluator.isTrustedApplication(referencingType);
    }
}

