/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.parent;

import apex.jorje.semantic.exception.SemanticException;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import apex.jorje.semantic.symbol.type.parent.ParentTableFactory;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import apex.jorje.services.exception.CompilationException;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collection;

final class DuplicateGenericInterfaceCalculator {
    private DuplicateGenericInterfaceCalculator() {
    }

    public static void calculate(TypeInfo type, Multimap<TypeInfo, CompilationException> errors) {
        TypeInfo superType = type.parents().superType();
        Collection<TypeInfo> interfaces = type.parents().immediateInterfaces();
        if (type.getCodeUnitDetails().getVersion().isGreaterThanOrEqual(Version.V180) && !interfaces.isEmpty()) {
            ImmutableSet<TypeInfo> superInterfaceTypes = type.getUnitType() == UnitType.INTERFACE ? Iterables.getOnlyElement(interfaces).parents().allInterfaces() : (superType != null ? ParentTableFactory.getVersionedInterfaces(type, superType) : ImmutableSet.of());
            for (TypeInfo superInterfaceType : superInterfaceTypes) {
                TypeInfo superRootType = GenericTypeInfoUtil.getRootType(superInterfaceType);
                for (TypeInfo myInterface : interfaces) {
                    TypeInfo rootType = GenericTypeInfoUtil.getRootType(myInterface);
                    if (!TypeInfoEquivalence.isEquivalent(superRootType, rootType) || TypeInfoEquivalence.isEquivalent(superInterfaceType, myInterface)) continue;
                    errors.put(type, new SemanticException(type.getCodeUnitDetails().getLoc(), I18nSupport.getLabel("generic.interface.already.implemented", rootType)));
                }
            }
        }
    }
}

