/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.common;

import apex.common.collect.MoreIterables;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;

public class CollectionTypeInfoUtil {
    private CollectionTypeInfoUtil() {
    }

    public static TypeInfo getElementType(TypeInfo type) {
        assert (CollectionTypeInfoUtil.isCollection(type) || CollectionTypeInfoUtil.isIterableOrIterator(type)) : type + " is not a collection";
        return MoreIterables.getOnlyElement(type.getTypeArguments());
    }

    private static boolean isIterableOrIterator(TypeInfo type) {
        TypeInfo rootType = GenericTypeInfoUtil.getRootType(type);
        return TypeInfoEquivalence.isEquivalent(InternalTypeInfos.SYSTEM_ITERABLE, rootType) || TypeInfoEquivalence.isEquivalent(InternalTypeInfos.SYSTEM_ITERATOR, rootType);
    }

    public static TypeInfo getKeyType(TypeInfo type) {
        assert (CollectionTypeInfoUtil.isMap(type));
        return type.getTypeArguments().get(0);
    }

    public static TypeInfo getValueType(TypeInfo type) {
        assert (CollectionTypeInfoUtil.isMap(type));
        return type.getTypeArguments().get(1);
    }

    public static boolean isSet(TypeInfo type) {
        return type.getBasicType() == BasicType.SET;
    }

    public static boolean isList(TypeInfo type) {
        return type.getBasicType() == BasicType.LIST;
    }

    public static boolean isQueryResultList(TypeInfo type) {
        return CollectionTypeInfoUtil.isList(type) && GenericTypeInfoUtil.asGenericType(type).isQueryResultList();
    }

    public static boolean isMap(TypeInfo type) {
        return type.getBasicType() == BasicType.MAP;
    }

    public static boolean isCollection(TypeInfo type) {
        return CollectionTypeInfoUtil.isSet(type) || CollectionTypeInfoUtil.isList(type);
    }

    public static boolean isMapOrCollection(TypeInfo type) {
        return CollectionTypeInfoUtil.isCollection(type) || CollectionTypeInfoUtil.isMap(type);
    }
}

