/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.common.iterable.CaseInsensitiveMap;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierOrAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.WrapperTypeInfos;
import apex.jorje.services.exception.UnhandledException;
import java.lang.reflect.Field;
import java.util.Map;

public final class TypeInfoTables {
    public static final Map<String, TypeInfo> TYPES_BY_BYTECODE_NAME;
    public static final Map<String, TypeInfo> TYPES_BY_APEX_NAME;
    public static final Map<String, ModifierOrAnnotationTypeInfo> ANNOTATION_TYPES;
    public static final Map<String, ModifierTypeInfo> MODIFIER_TYPES;
    public static final Map<String, TypeInfo> WRAPPER_TYPES;

    private TypeInfoTables() {
    }

    public static <T extends TypeInfo> Map<String, T> bytecodeNameMap(Class<?> clazz, Class<T> assignable) {
        Field[] fields = clazz.getFields();
        CaseInsensitiveMap.Builder<TypeInfo> builder = CaseInsensitiveMap.builder();
        for (Field field : fields) {
            if (!assignable.isAssignableFrom(field.getType())) continue;
            try {
                TypeInfo type = (TypeInfo)assignable.cast(field.get(null));
                builder.put(type.getBytecodeName(), type);
            }
            catch (Exception x) {
                throw new UnhandledException("Error in table initialization", x);
            }
        }
        return builder.build();
    }

    private static <T extends TypeInfo> Map<String, T> apexNameMap(Class<?> clazz, Class<T> assignable) {
        Field[] fields = clazz.getFields();
        CaseInsensitiveMap.Builder<TypeInfo> builder = CaseInsensitiveMap.builder();
        for (Field field : fields) {
            if (!assignable.isAssignableFrom(field.getType())) continue;
            try {
                TypeInfo type = (TypeInfo)assignable.cast(field.get(null));
                builder.put(type.getApexName(), type);
            }
            catch (Exception x) {
                throw new UnhandledException("Error in table initialization", x);
            }
        }
        return builder.build();
    }

    static {
        Field[] fields = TypeInfos.class.getFields();
        CaseInsensitiveMap.Builder<TypeInfo> bytecodeNameBuilder = CaseInsensitiveMap.builder();
        CaseInsensitiveMap.Builder<TypeInfo> apexNameBuilder = CaseInsensitiveMap.builder();
        for (Field field : fields) {
            if (!TypeInfo.class.isAssignableFrom(field.getType())) continue;
            try {
                TypeInfo type = (TypeInfo)field.get(null);
                bytecodeNameBuilder.put(type.getBytecodeName(), type);
                apexNameBuilder.put(type.getApexName(), type);
            }
            catch (Exception x) {
                throw new UnhandledException("Error in table initialization", x);
            }
        }
        bytecodeNameBuilder.put("void", TypeInfos.VOID);
        bytecodeNameBuilder.put("system.id", TypeInfos.VOID);
        TYPES_BY_BYTECODE_NAME = bytecodeNameBuilder.build();
        TYPES_BY_APEX_NAME = apexNameBuilder.build();
        WRAPPER_TYPES = TypeInfoTables.bytecodeNameMap(WrapperTypeInfos.class, TypeInfo.class);
        ANNOTATION_TYPES = TypeInfoTables.apexNameMap(AnnotationTypeInfos.class, ModifierOrAnnotationTypeInfo.class);
        MODIFIER_TYPES = TypeInfoTables.apexNameMap(ModifierTypeInfos.class, ModifierTypeInfo.class);
    }
}

