/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.common.base.MoreStrings;
import apex.jorje.data.JadtFactory;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.SObjectMethods;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.symbol.type.AbstractTypeInfo;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.SObjectMetadata;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.parent.ParentTable;
import apex.jorje.semantic.symbol.type.parent.ParentTableFactory;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;

public class SObjectTypeInfo
extends AbstractTypeInfo {
    private static final ModifierGroup DEPRECATED_GLOBAL_FINAL = ModifierGroup.builder().addModifiers(ModifierTypeInfos.GLOBAL, ModifierTypeInfos.FINAL).addAnnotationAndResolve(JadtFactory.annotation(AnnotationTypeInfos.DEPRECATED.getApexName())).build().resolve();
    private static final Supplier<MethodsForEmit> GENERIC_METHODS_FOR_EMIT = Suppliers.memoize(() -> new MethodsForEmit(TypeInfos.SOBJECT));
    private final MethodsForEmit methodsForEmit;
    protected SObjectMetadata metadata;
    public static final ParentTable SHARED_PARENT_TABLE = ParentTableFactory.create(TypeInfos.SOBJECT);

    private SObjectTypeInfo(Builder builder) {
        super(builder);
        this.methodsForEmit = new MethodsForEmit(this);
        this.metadata = builder.metadata;
    }

    protected SObjectTypeInfo(AbstractTypeInfo.Builder builder) {
        super(builder);
        this.methodsForEmit = null;
        this.metadata = null;
    }

    public static MethodsForEmit getGenericMethodsForEmit() {
        return GENERIC_METHODS_FOR_EMIT.get();
    }

    public static Builder builder() {
        return new Builder();
    }

    public MethodsForEmit getMethodsForEmit() {
        return this.methodsForEmit;
    }

    public SObjectMetadata getMetadata() {
        return this.metadata;
    }

    public String getApexNameSansNamespace() {
        if (!Namespace.isEmptyOrNull(this.getNamespace())) {
            String namespacePrefix = this.getNamespace().toString() + "_";
            if (this.getApexName().startsWith(namespacePrefix)) {
                return this.getApexName().substring(namespacePrefix.length());
            }
        }
        return this.getApexName();
    }

    @Override
    public String getBytecodeName() {
        if (this.metadata == null) {
            return super.getBytecodeName();
        }
        TypeInfo unionAllType = this.metadata.getUnionParentType(this);
        return unionAllType != this ? unionAllType.getBytecodeName() : super.getBytecodeName();
    }

    @Override
    public String getTypeSignature() {
        if (this.metadata == null) {
            return super.getTypeSignature();
        }
        TypeInfo unionAllType = this.metadata.getUnionParentType(this);
        return unionAllType != this ? unionAllType.getTypeSignature() : super.getTypeSignature();
    }

    public String getSubEntityBytecodeNameForCreation() {
        return super.getBytecodeName();
    }

    @Override
    public <T> T accept(TypeInfoVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static class MethodsForEmit {
        private final TypeInfo type;
        private AsmMethod getRegularValue;
        private AsmMethod getValue;
        private AsmMethod getAggregate;
        private AsmMethod getAggregateForSelect;
        private AsmMethod setValue;

        private MethodsForEmit(TypeInfo type) {
            this.type = type;
        }

        public AsmMethod getRegularValueMethod() {
            return this.getRegularValue == null ? (this.getRegularValue = AsmMethod.builder().invokeVirtual().setDefiningTypeAsBytecodeName(this.type).setFunction("getRegularValue").setSignature((TypeInfo)TypeInfos.OBJECT, (TypeInfo)TypeInfos.STRING).build()) : this.getRegularValue;
        }

        public AsmMethod getValueMethod() {
            return this.getValue == null ? (this.getValue = AsmMethod.builder().invokeVirtual().setDefiningTypeAsBytecodeName(this.type).setFunction("getValue").setSignature((TypeInfo)TypeInfos.OBJECT, (TypeInfo)TypeInfos.STRING).build()) : this.getValue;
        }

        public AsmMethod getAggregateMethod() {
            return this.getAggregate == null ? (this.getAggregate = AsmMethod.builder().invokeVirtual().setDefiningTypeAsBytecodeName(this.type).setFunction("getAggregate").setSignature((TypeInfo)TypeInfos.OBJECT, TypeInfos.STRING, TypeInfos.STRING).build()) : this.getAggregate;
        }

        public AsmMethod getAggregateForSelectMethod() {
            return this.getAggregateForSelect == null ? (this.getAggregateForSelect = AsmMethod.builder().invokeVirtual().setDefiningTypeAsBytecodeName(this.type).setFunction("getAggregateForSelect").setSignature((TypeInfo)InternalTypeInfos.DATABASE_QUERY_LOCATOR, TypeInfos.STRING, TypeInfos.STRING).build()) : this.getAggregateForSelect;
        }

        public AsmMethod setValueMethod() {
            return this.setValue == null ? (this.setValue = AsmMethod.builder().invokeVirtual().setDefiningTypeAsBytecodeName(this.type).setFunction("setValue").setSignature((TypeInfo)TypeInfos.VOID, TypeInfos.OBJECT, TypeInfos.STRING).build()) : this.setValue;
        }
    }

    public static class Builder
    extends AbstractTypeInfo.Builder<Builder, SObjectTypeInfo> {
        private SObjectMetadata metadata;
        private boolean isDeprecated;

        protected Builder() {
        }

        public Builder setMetadata(SObjectMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setDeprecated(boolean isDeprecated) {
            this.isDeprecated = isDeprecated;
            return this;
        }

        @Override
        public SObjectTypeInfo build() {
            assert (Strings.isNullOrEmpty(this.getNamespace().toString()) || MoreStrings.startsWithIgnoreCase(this.getApexName(), this.getNamespace().toString()) || MoreStrings.startsWithIgnoreCase(this.getApexName(), "localmodule" + this.getNamespace())) : "Apex name doesn't start with namespace.\nNamespace: " + this.getNamespace() + "\nApex name: " + this.getApexName();
            this.setParents(SHARED_PARENT_TABLE);
            this.setMethods(SObjectMethods.get());
            this.setUnitType(UnitType.CLASS);
            this.setModifiers(this.isDeprecated ? DEPRECATED_GLOBAL_FINAL : ModifierGroups.GLOBAL_FINAL);
            this.setBasicType(BasicType.SOBJECT);
            return new SObjectTypeInfo(this);
        }

        @Override
        public Builder setBytecodeName(String bytecodeName) {
            super.setBytecodeName("com/salesforce/api/entity/" + bytecodeName);
            return this;
        }
    }
}

