/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.services.Version;
import javax.xml.namespace.QName;

public enum BasicType {
    INTEGER(BasicType.builder().setXmlType(new QName("", "int"))),
    LONG(BasicType.builder().setXmlType(new QName("", "long"))),
    DOUBLE(BasicType.builder().setXmlType(new QName("", "double"))),
    DECIMAL(BasicType.builder().setXmlType(new QName("", "decimal"))),
    BOOLEAN(BasicType.builder().setXmlType(new QName("", "boolean"))),
    STRING(BasicType.builder().setXmlType(new QName("", "string"))),
    VOID,
    APEX_OBJECT(BasicType.builder().setXmlType(new QName("", "anyType"))),
    LIST,
    SET,
    MAP,
    TIME(BasicType.builder().setXmlType(new QName("", "time")).setMinVersion(Version.V154)),
    DATE(BasicType.builder().setXmlType(new QName("", "date"))),
    DATE_TIME(BasicType.builder().setXmlType(new QName("", "dateTime"))),
    OBJECT(BasicType.builder().setXmlType(new QName("", "anyType"))),
    ID(BasicType.builder().setXmlType(new QName("", "ID"))),
    BLOB(BasicType.builder().setXmlType(new QName("", "double"))),
    NULL,
    ANNOTATION,
    SOBJECT(BasicType.builder().setXmlType(new QName("", "sObject"))),
    JAVA,
    CURRENCY,
    VF_COMPONENT,
    FLOW_INTERVIEW,
    MODIFIER;

    private final QName xmlType;
    private final Version minVersion;

    private BasicType() {
        this(BasicType.builder());
    }

    private BasicType(Builder builder) {
        this.minVersion = builder.minVersion;
        this.xmlType = builder.xmlType;
    }

    private static Builder builder() {
        return new Builder();
    }

    public QName getXmlType() {
        return this.xmlType;
    }

    public boolean isIntegerOrLong() {
        return this == INTEGER || this == LONG;
    }

    public boolean isNumber() {
        return this == INTEGER || this == LONG || this == DOUBLE || this == DECIMAL;
    }

    public boolean isScalarOrVoid() {
        switch (this) {
            case BLOB: 
            case INTEGER: 
            case LONG: 
            case DOUBLE: 
            case DECIMAL: 
            case BOOLEAN: 
            case STRING: 
            case ID: 
            case VOID: 
            case TIME: 
            case DATE: 
            case DATE_TIME: {
                return true;
            }
        }
        return false;
    }

    public boolean isApexObject() {
        return this == APEX_OBJECT || this == VF_COMPONENT || this == FLOW_INTERVIEW;
    }

    public boolean isDynamic() {
        return this == VF_COMPONENT || this == FLOW_INTERVIEW;
    }

    public boolean allowsInequality() {
        return this.isNumber() || this.isDateOrTime() || this == STRING || this == ID;
    }

    public boolean isDateOrTime() {
        return this == DATE || this == DATE_TIME || this == TIME;
    }

    public boolean isReference() {
        return this == SOBJECT || this == JAVA || this == LIST || this == SET || this == MAP || this == APEX_OBJECT || this == OBJECT;
    }

    public boolean isColumnType() {
        return this.xmlType != null && this != SOBJECT;
    }

    public boolean canBeCastOrInstanceOf() {
        return this.isReference() || this.isColumnType() || this == NULL;
    }

    public Version getMinVersion() {
        return this.minVersion;
    }

    private static class Builder {
        private QName xmlType = null;
        private Version minVersion = Version.MIN;

        public Builder setXmlType(QName xmlType) {
            this.xmlType = xmlType;
            return this;
        }

        public Builder setMinVersion(Version minVersion) {
            this.minVersion = minVersion;
            return this;
        }
    }
}

