/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver.rules;

import apex.jorje.semantic.common.iterable.SuperTypeIterable;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.sfdc.PlaceholderOrgPerm;
import apex.jorje.semantic.symbol.resolver.StandardSymbolResolver;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.resolver.rules.OnePartTypeNameResolveRules;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.VersionedTypeInfos;
import apex.jorje.semantic.symbol.type.common.ExceptionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.services.Version;

final class TypeNameResolveUtil {
    static final String BASE_EXCEPTION = "exception";
    static final String APEX_PAGES = Namespaces.APEX_PAGES.getNameLower();
    static final String SYSTEM = Namespaces.SYSTEM.getNameLower();
    static final String SCHEMA = Namespaces.SCHEMA.getNameLower();
    private static final String ARRAY_EXCEPTION = "arrayexception";
    private static final String LIST_EXCEPTION = "listexception";

    private TypeNameResolveUtil() {
    }

    static TypeInfo lookupInBuiltInNamespace(StandardSymbolResolver symbols, TypeInfo referencingType, Namespace namespace, String name) {
        return symbols.find(referencingType, TypeNameResolveUtil.createBuiltInCandidate(namespace, name));
    }

    static String createBuiltInCandidate(Namespace namespace, String name) {
        return Namespace.isEmptyOrNull(namespace) ? "com/salesforce/api/" + name : TypeNameResolveUtil.createTypeWithThreeParts("com/salesforce/api", namespace.getBytecodeNameLower(), name);
    }

    static TypeInfo lookupInBuiltInException(StandardSymbolResolver symbols, TypeInfo referencingType, Namespace namespace, String name) {
        Version version = referencingType.getCodeUnitDetails().getVersion();
        if (ARRAY_EXCEPTION.equals(name) || LIST_EXCEPTION.equals(name)) {
            return version.isLessThanOrEqual(Version.V148) ? VersionedTypeInfos.ARRAY_EXCEPTION : VersionedTypeInfos.LIST_EXCEPTION;
        }
        TypeInfo exceptionType = symbols.find(referencingType, TypeNameResolveUtil.createExceptionCandidate(namespace, name));
        if (exceptionType == null) {
            return null;
        }
        if (!ExceptionTypeInfoUtil.canExceptionBeCaught(exceptionType) && version.isLessThanOrEqual(Version.V164)) {
            return VersionedTypeInfos.EXCEPTION_PRE_V156;
        }
        return exceptionType;
    }

    static String createExceptionCandidate(Namespace namespace, String name) {
        return Namespaces.SYSTEM.equals(namespace) || Namespace.isEmptyOrNull(namespace) ? "com/salesforce/api/exception/" + name : TypeNameResolveUtil.createTypeWithThreeParts("com/salesforce/api/exception", namespace.getBytecodeNameLower(), name);
    }

    static boolean hasVfComponentTypes(StandardSymbolResolver symbols, TypeInfo referencingType) {
        return symbols.getAccessEvaluator().isReservedNamespace(referencingType.getNamespace()) || symbols.getAccessEvaluator().hasPermission(PlaceholderOrgPerm.VISUAL_FORCE_APEX_TESTING) || Version.V172.isLessThanOrEqual(referencingType.getCodeUnitDetails().getVersion());
    }

    static TypeInfo filterToEnum(Version version, TypeInfo candidateType, boolean checkEnums) {
        if (candidateType == null || !checkEnums) {
            return candidateType;
        }
        if (version.isGreaterThanOrEqual(Version.V174) || candidateType.getUnitType() == UnitType.ENUM) {
            return candidateType;
        }
        return null;
    }

    static TypeInfo getInnerType(SymbolResolver symbols, TypeInfo enclosingType, TypeInfo referencingType, String name) {
        String innerTypeName = TypeNameResolveUtil.createInnerType(enclosingType.getBytecodeName().toLowerCase(), name);
        return symbols.get(enclosingType.getBytecodeName()) != null ? symbols.get(innerTypeName) : symbols.getSymbolProvider().find(symbols, referencingType, innerTypeName);
    }

    static String createInnerType(String outer, String inner) {
        return outer + "$" + inner;
    }

    static String createInnerTypeWithNamespace(Namespace namespace, String outer, String inner) {
        if (Namespace.isEmptyOrNull(namespace)) {
            return TypeNameResolveUtil.createInnerType(outer, inner);
        }
        return namespace.getBytecodeNameLower() + "/" + outer + "$" + inner;
    }

    static String createInnerTypeWithFourParts(String prefix, String namespace, String outer, String inner) {
        return prefix + "/" + namespace + "/" + outer + "$" + inner;
    }

    static String createTypeWithNamespace(Namespace namespace, String outer) {
        if (Namespace.isEmptyOrNull(namespace)) {
            return outer;
        }
        return namespace.getBytecodeNameLower() + "/" + outer;
    }

    static String createTypeWithThreeParts(String prefix, String namespace, String outer) {
        return prefix + "/" + namespace + "/" + outer;
    }

    static class InnerTypeViaSubTypeUtil {
        private InnerTypeViaSubTypeUtil() {
        }

        public static TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, TypeInfo subType, String innerTypeName) {
            if (!subType.isResolved()) {
                return null;
            }
            TypeInfo innerType = OnePartTypeNameResolveRules.InnerTypeOfParentType.INSTANCE.lookup(symbols, subType, innerTypeName);
            if (innerType != null) {
                TypeInfo enclosingType = TypeInfoUtil.getTopLevel(innerType);
                for (TypeInfo referenceParentType : new SuperTypeIterable(referencingType)) {
                    if (enclosingType != referenceParentType) continue;
                    return innerType;
                }
            }
            return null;
        }
    }
}

