/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver;

import apex.jorje.data.Identifier;
import apex.jorje.data.Locations;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.common.iterable.ExtendedTypeIterable;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldTable;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.resolver.interceptors.LegacyEarlyBindInterceptor;
import apex.jorje.semantic.symbol.resolver.interceptors.LegacyEarlyBindInterceptors;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreLists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class VariableResolver {
    private final SymbolResolver symbols;
    private final TypeInfo referencingType;
    private final LegacyEarlyBindInterceptor sobjectInterceptor;

    public VariableResolver(SymbolResolver symbols, TypeInfo referencingType) {
        this(symbols, referencingType, LegacyEarlyBindInterceptors.SObjectEarlyBindInterceptor.get());
    }

    @VisibleForTesting
    VariableResolver(SymbolResolver symbols, TypeInfo referencingType, LegacyEarlyBindInterceptor sobjectInterceptor) {
        this.symbols = symbols;
        this.referencingType = referencingType;
        this.sobjectInterceptor = sobjectInterceptor;
    }

    private FieldTable.LookupMode getMode(IdentifierContext startContext, TypeInfo type, boolean isLast) {
        IdentifierContext context = startContext != IdentifierContext.NONE || type == this.referencingType ? startContext : (this.symbols.staticContext().get() ? IdentifierContext.STATIC : IdentifierContext.OBJECT);
        switch (context) {
            case STATIC: {
                return isLast ? FieldTable.LookupMode.STATIC_VARIABLE : FieldTable.LookupMode.STATIC_REFERENCE;
            }
            case OBJECT: {
                return isLast ? FieldTable.LookupMode.INSTANCE_VARIABLE : FieldTable.LookupMode.INSTANCE_REFERENCE;
            }
        }
        return this.symbols.staticContext().get() ? (isLast ? FieldTable.LookupMode.STATIC_VARIABLE_LOCALS_OKAY : FieldTable.LookupMode.STATIC_REFERENCE_LOCALS_OKAY) : (isLast ? FieldTable.LookupMode.INSTANCE_VARIABLE_LOCALS_OKAY : FieldTable.LookupMode.INSTANCE_REFERENCE_LOCALS_OKAY);
    }

    public Variable lookup(ReferenceType referenceType, IdentifierContext context, TypeInfo type, Identifier name) {
        FieldTable.LookupMode currentMode = this.getMode(context, type, true);
        return this.lookup(referenceType, context, currentMode, type, name);
    }

    public List<Variable> lookup(ReferenceType referenceType, IdentifierContext context, TypeInfo type, List<Identifier> names) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        int lastIndex = names.size() - 1;
        IdentifierContext currentContext = context;
        TypeInfo currentType = type;
        for (int i = 0; i < names.size(); ++i) {
            Identifier name = names.get(i);
            boolean isLast = i == lastIndex && referenceType == ReferenceType.METHOD;
            FieldTable.LookupMode currentMode = this.getMode(currentContext, type, isLast);
            Variable variable = this.lookup(referenceType, currentContext, currentMode, currentType, name);
            if (variable == null) break;
            currentContext = IdentifierContext.OBJECT;
            currentType = variable.getType();
            variables.add(variable);
        }
        return MoreLists.toImmutableList(variables);
    }

    private Variable lookup(ReferenceType referenceType, IdentifierContext context, FieldTable.LookupMode mode, TypeInfo type, Identifier name) {
        if (mode.areLocalsAllowed()) {
            LocalInfo localInfo = this.symbols.variables().lookup(name.getValue(), name.getLoc());
            if (localInfo != null) {
                return localInfo;
            }
            return this.walkParents(context, mode, type, name, !mode.isLast(), referenceType);
        }
        if (mode.areStaticsFirst()) {
            return type.fields().get(this.symbols, this.referencingType, name.getValue(), mode);
        }
        return this.walkParents(context, mode, type, name, true, referenceType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FieldInfo walkParents(IdentifierContext context, FieldTable.LookupMode lookupMode, TypeInfo type, Identifier name, boolean instanceOnly, ReferenceType referenceType) {
        boolean staticsOkay = lookupMode.areLocalsAllowed() || !instanceOnly;
        FieldInfo firstBind = null;
        for (TypeInfo current : this.getParents(context, type)) {
            FieldInfo staticEnclosingField;
            FieldInfo fieldInfo = current.fields().get(this.symbols, this.referencingType, name.getValue(), lookupMode);
            if (fieldInfo != null) {
                if (instanceOnly && !fieldInfo.getModifiers().has(ModifierTypeInfos.STATIC)) {
                    return fieldInfo;
                }
                if (staticsOkay) {
                    if (!this.isLowPrecedenceField(context, type, current, fieldInfo, referenceType, name)) return fieldInfo;
                    firstBind = fieldInfo;
                } else if (lookupMode.isLast() && firstBind == null) {
                    firstBind = fieldInfo;
                }
            }
            if ((staticEnclosingField = this.getStaticFieldFromEnclosingType(lookupMode, name, staticsOkay, current)) != null) {
                if (referenceType != ReferenceType.METHOD || !this.isLowPrecedenceField(context, type, current, staticEnclosingField, referenceType, name)) return staticEnclosingField;
                firstBind = staticEnclosingField;
            }
            staticsOkay = this.shouldContinueCheckingForStatics(instanceOnly, staticsOkay, referenceType);
        }
        return firstBind;
    }

    private boolean shouldContinueCheckingForStatics(boolean instanceOnly, boolean staticsOkay, ReferenceType referenceType) {
        return referenceType == ReferenceType.METHOD ? staticsOkay : !instanceOnly;
    }

    private FieldInfo getStaticFieldFromEnclosingType(FieldTable.LookupMode lookupMode, Identifier name, boolean staticsOkay, TypeInfo current) {
        FieldInfo enclosingField;
        if (staticsOkay && TypeInfoUtil.isInnerType(current) && (enclosingField = current.getEnclosingType().fields().get(this.symbols, this.referencingType, name.getValue(), FieldTable.LookupMode.switchToStatic(lookupMode))) != null && enclosingField.getModifiers().has(ModifierTypeInfos.STATIC)) {
            return enclosingField;
        }
        return null;
    }

    private Iterable<TypeInfo> getParents(IdentifierContext context, TypeInfo startType) {
        if (context == IdentifierContext.STATIC || context == IdentifierContext.NONE && this.symbols.staticContext().get()) {
            return ImmutableList.of(startType);
        }
        return new ExtendedTypeIterable(startType);
    }

    private boolean isLowPrecedenceField(IdentifierContext context, TypeInfo startType, TypeInfo parent, FieldInfo fieldInfo, ReferenceType referenceType, Identifier name) {
        return startType == parent && fieldInfo.getModifiers().has(ModifierTypeInfos.STATIC) && (context == IdentifierContext.OBJECT || context == IdentifierContext.NONE && !this.symbols.staticContext().get()) && (referenceType == ReferenceType.METHOD || !Locations.lessThanOrEqual(fieldInfo.getLoc(), name.getLoc()));
    }

    public StaticResult lookupStatic(ReferenceType referenceType, List<Identifier> names) {
        StaticResult earlyBind = null;
        int size = names.size();
        for (int i = 1; i <= 4 && i < size; ++i) {
            TypeInfo type = this.symbols.lookupTypeInfoIdentifiers(this.referencingType, names.subList(0, i));
            List<Identifier> tail = names.subList(i, names.size());
            if (earlyBind == null && this.applyEarlyBindInterceptors(referenceType, tail, type)) {
                earlyBind = new StaticResult(i, ImmutableList.of(), Optional.of(type));
                continue;
            }
            List<Variable> variables = this.lookup(referenceType, IdentifierContext.STATIC, type, tail);
            if (variables.isEmpty()) continue;
            return new StaticResult(i, variables, Optional.empty());
        }
        return MoreObjects.firstNonNull(earlyBind, StaticResult.EMPTY);
    }

    private boolean applyEarlyBindInterceptors(ReferenceType callerReferenceType, List<Identifier> remainingTerms, TypeInfo type) {
        return type.isResolved() && this.sobjectInterceptor.applies(callerReferenceType, remainingTerms, type);
    }

    public static class StaticResult {
        private static final StaticResult EMPTY = new StaticResult(-1, Collections.emptyList(), Optional.empty());
        private final int position;
        private final List<Variable> variables;
        private final Optional<TypeInfo> legacyEarlyBoundType;

        private StaticResult(int position, List<Variable> variables, Optional<TypeInfo> legacyEarlyBoundType) {
            this.position = position;
            this.variables = variables;
            this.legacyEarlyBoundType = legacyEarlyBoundType;
        }

        public int getPosition() {
            return this.position;
        }

        public List<Variable> getVariables() {
            return this.variables;
        }

        public Optional<TypeInfo> getLegacyEarlyBoundType() {
            return this.legacyEarlyBoundType;
        }
    }
}

