/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver;

import apex.common.base.Result;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.common.iterable.SuperTypeIterable;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodLookupMode;
import apex.jorje.semantic.symbol.member.method.signature.SignatureUtil;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import java.util.List;

class MethodResolver {
    private final TypeInfo referencingType;

    MethodResolver(TypeInfo referencingType) {
        this.referencingType = referencingType;
    }

    Result<MethodInfo> lookup(IdentifierContext context, TypeInfo type, String methodName, List<TypeInfo> parameterTypes) {
        if (SignatureUtil.isConstructor(methodName)) {
            return type.methods().getApproximate(this.referencingType, methodName, parameterTypes, MethodLookupMode.CONSTRUCTORS);
        }
        Result<MethodInfo> result = Result.none();
        switch (context) {
            case OBJECT: 
            case NONE: {
                result = this.lookupInstance(type, methodName, parameterTypes);
                if (result.hasResult()) {
                    return result;
                }
                result = this.lookupStatic(type, methodName, parameterTypes);
                break;
            }
            case STATIC: {
                result = this.lookupStatic(type, methodName, parameterTypes);
                if (result.hasResult()) {
                    return result;
                }
                result = this.lookupInstance(type, methodName, parameterTypes);
            }
        }
        if (result.hasResult()) {
            return result;
        }
        return this.lookupStaticInEnclosingType(type, methodName, parameterTypes);
    }

    private Result<MethodInfo> lookupStaticInEnclosingType(TypeInfo type, String methodName, List<TypeInfo> parameterTypes) {
        for (TypeInfo parent : new SuperTypeIterable(type)) {
            Result<MethodInfo> result;
            if (!TypeInfoUtil.isInnerType(parent) || !(result = this.lookupStatic(parent.getEnclosingType(), methodName, parameterTypes)).hasResult()) continue;
            return result;
        }
        return Result.none();
    }

    private Result<MethodInfo> lookupStatic(TypeInfo type, String methodName, List<TypeInfo> parameterTypes) {
        if (type.getBasicType() == BasicType.SOBJECT) {
            return type.methods().getApproximate(this.referencingType, methodName, parameterTypes, MethodLookupMode.STATICS);
        }
        for (TypeInfo current : new SuperTypeIterable(type)) {
            Result<MethodInfo> method = current.methods().getApproximate(this.referencingType, methodName, parameterTypes, MethodLookupMode.STATICS);
            if (!method.hasResult()) continue;
            return method;
        }
        return Result.none();
    }

    private Result<MethodInfo> lookupInstance(TypeInfo type, String methodName, List<TypeInfo> parameterTypes) {
        Result<MethodInfo> x = type.virtualMethods().getApproximate(this.referencingType, methodName, parameterTypes, MethodLookupMode.INSTANCE);
        if (x.hasResult()) {
            return x;
        }
        if (type.getUnitType() == UnitType.INTERFACE) {
            for (TypeInfo parent : type.parents().allInterfaces()) {
                Result<MethodInfo> result = parent.methods().getApproximate(this.referencingType, methodName, parameterTypes, MethodLookupMode.INSTANCE);
                if (!result.hasResult()) continue;
                return result;
            }
        }
        return Result.none();
    }
}

