/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.jorje.semantic.symbol.member.variable.SObjectFieldInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;

public final class VariableUtil {
    private static final VariableVisitor<Boolean, Void> CAN_BE_EDITABLE = new VariableVisitor.Default<Boolean, Void>(){

        @Override
        public Boolean _default(Variable info, Void context) {
            return false;
        }

        @Override
        public Boolean visit(SObjectFieldInfo info, Void context) {
            switch (info.getCategory()) {
                case REGULAR: {
                    return true;
                }
                case FOREIGN_KEY: {
                    return true;
                }
                case AGGREGATE: {
                    return false;
                }
                case ID_LIST: {
                    return true;
                }
            }
            throw new UnsupportedOperationException("unknown category: " + (Object)((Object)info.getCategory()));
        }
    };
    private static final VariableVisitor<Boolean, Void> IS_FOREIGN_KEY = new VariableVisitor.Default<Boolean, Void>(){

        @Override
        public Boolean _default(Variable info, Void context) {
            return false;
        }

        @Override
        public Boolean visit(SObjectFieldInfo info, Void context) {
            return info.getCategory() == SObjectFieldInfo.Category.FOREIGN_KEY;
        }
    };

    private VariableUtil() {
    }

    public static boolean isForeignKey(Variable variable) {
        return variable.accept(IS_FOREIGN_KEY, VariableVisitor.Context.NONE);
    }

    public static boolean canBeEditable(Variable variable) {
        return variable.accept(CAN_BE_EDITABLE, VariableVisitor.Context.NONE);
    }
}

