/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.jorje.data.Location;
import apex.jorje.semantic.ast.ProfilingType;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.DmlOperation;
import apex.jorje.semantic.bcl.validators.BuiltInMethodValidator;
import apex.jorje.semantic.bcl.validators.JavaSfdcOnlyAnnotation;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.InvocationType;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodNameMangler;
import apex.jorje.semantic.symbol.member.method.signature.Signature;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;

public class VirtualMethodInfo
implements MethodInfo {
    private final MethodInfo method;
    private String canonicalName;
    private String mangledCanonicalName;
    private Set<MethodInfo> methodInterfaces;

    private VirtualMethodInfo(MethodInfo method) {
        this.method = method;
        this.canonicalName = method.getCanonicalName();
        this.mangledCanonicalName = method.getMangledCanonicalName();
        this.methodInterfaces = ImmutableSet.of();
    }

    public static VirtualMethodInfo create(MethodInfo method) {
        return method instanceof VirtualMethodInfo ? new VirtualMethodInfo(((VirtualMethodInfo)method).method) : new VirtualMethodInfo(method);
    }

    @Override
    public List<TypeInfo> getParameterTypes() {
        return this.method.getParameterTypes();
    }

    @Override
    public TypeInfo getReturnType() {
        return this.method.getReturnType();
    }

    @Override
    public Signature getSignature() {
        return this.method.getSignature();
    }

    @Override
    public Signature getEmitSignature() {
        return this.method.getEmitSignature();
    }

    @Override
    public InvocationType getInvocationType() {
        return this.method.getInvocationType();
    }

    @Override
    public JavaSfdcOnlyAnnotation getJavaSfdcOnlyAnnotation() {
        return this.method.getJavaSfdcOnlyAnnotation();
    }

    @Override
    public List<Parameter> getParameters() {
        return this.method.getParameters();
    }

    @Override
    public boolean isConstructor() {
        return this.method.isConstructor();
    }

    @Override
    public boolean isPropertyAccessor() {
        return this.method.isPropertyAccessor();
    }

    @Override
    public boolean isStaticInitialization() {
        return this.method.isStaticInitialization();
    }

    @Override
    public String getCanonicalName() {
        return this.canonicalName;
    }

    @Override
    public void setCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
        this.mangledCanonicalName = MethodNameMangler.getMangledName(this, canonicalName);
    }

    @Override
    public Set<MethodInfo> getMethodInterfaces() {
        return this.methodInterfaces;
    }

    @Override
    public void setMethodInterfaces(Set<MethodInfo> methodInterfaces) {
        this.methodInterfaces = methodInterfaces;
    }

    @Override
    public Generated getGenerated() {
        return this.method.getGenerated();
    }

    @Override
    public boolean hasReturnValue() {
        return this.method.hasReturnValue();
    }

    @Override
    public AsmMethod.Builder getAsmMethodBuilder() {
        return this.method.getAsmMethodBuilder();
    }

    @Override
    public AsmMethod getAsmMethod() {
        return this.method.getAsmMethod();
    }

    @Override
    public String getMangledName() {
        return this.method.getMangledName();
    }

    @Override
    public String getMangledCanonicalName() {
        return this.mangledCanonicalName;
    }

    @Override
    public ProfilingType getProfilingType() {
        return this.method.getProfilingType();
    }

    @Override
    public boolean isDuckTyped() {
        return this.method.isDuckTyped();
    }

    @Override
    public List<BuiltInMethodValidator> getValidators() {
        return this.method.getValidators();
    }

    @Override
    public boolean needsReturnTypeConversion() {
        return this.method.needsReturnTypeConversion();
    }

    @Override
    public DmlOperation getDmlOperation() {
        return this.method.getDmlOperation();
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.method.getDefiningType();
    }

    @Override
    public Member.Type getMemberType() {
        return this.method.getMemberType();
    }

    @Override
    public ModifierGroup getModifiers() {
        return this.method.getModifiers();
    }

    @Override
    public Location getLoc() {
        return this.method.getLoc();
    }

    public String toString() {
        return this.getSignature().toString();
    }
}

