/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.common.base.Initializer;
import apex.common.base.Initializers;
import apex.common.base.MoreStrings;
import apex.common.base.Result;
import apex.common.base.VoidResult;
import apex.common.collect.MoreCollections;
import apex.jorje.semantic.common.iterable.HashedMap;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.member.method.MemoizingMethodTable;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodLookupMode;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.MethodUtil;
import apex.jorje.semantic.symbol.member.method.signature.Signature;
import apex.jorje.semantic.symbol.member.method.signature.SignatureUtil;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.services.I18nSupport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Equivalence;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;

public class StandardMethodTable
extends MemoizingMethodTable {
    private static final MethodLookupMap EMPTY_MAP = new MethodLookupMap();
    public static final Initializer<MethodTable, TypeInfo> EMPTY = Initializers.ofInstance(new StandardMethodTable().resolve());
    private static final Equivalence<Signature> SIGNATURE_WRAPPER = new Equivalence<Signature>(){

        @Override
        protected boolean doEquivalent(@Nonnull Signature signature, @Nonnull Signature other) {
            return signature.equalsSignature(other);
        }

        @Override
        protected int doHash(@Nonnull Signature signature) {
            return signature.hashCodeSignature();
        }

        public String toString() {
            return "eq";
        }
    };
    private final Map<Equivalence.Wrapper<Signature>, MethodInfo> methods;
    private MethodLookupMap staticMethodLookupMap;
    private MethodLookupMap instanceMethodLookupMap;
    private MethodLookupMap userConstructorLookupMap;
    private MethodLookupMap systemConstructorLookupMap;
    private Optional<MethodInfo> staticCloneMethod = Optional.empty();
    private boolean resolved = false;

    public StandardMethodTable() {
        this.methods = new LinkedHashMap<Equivalence.Wrapper<Signature>, MethodInfo>();
        this.staticMethodLookupMap = EMPTY_MAP;
        this.instanceMethodLookupMap = EMPTY_MAP;
        this.userConstructorLookupMap = EMPTY_MAP;
        this.systemConstructorLookupMap = EMPTY_MAP;
    }

    @Override
    public Result<MethodInfo> getApproximate(TypeInfo referencingType, String methodName, List<TypeInfo> parameterTypes, MethodLookupMode mode) {
        assert (this.resolved) : "can't get methods until method table is resolved";
        switch (mode) {
            case CONSTRUCTORS: {
                assert (SignatureUtil.isConstructor(methodName)) : "Asked to look up a constructor for a signature that was not a constructor";
                Result<MethodInfo> result = this.getApproximate(referencingType, this.userConstructorLookupMap, methodName, parameterTypes);
                if (result.hasResult()) {
                    return result;
                }
                return this.getApproximate(referencingType, this.systemConstructorLookupMap, methodName, parameterTypes);
            }
            case STATICS: {
                return this.getApproximate(referencingType, this.staticMethodLookupMap, methodName, parameterTypes);
            }
            case INSTANCE: {
                return this.getApproximate(referencingType, this.instanceMethodLookupMap, methodName, parameterTypes);
            }
        }
        throw new UnexpectedCodePathException("unexpected mode: " + (Object)((Object)mode));
    }

    @Override
    public MethodInfo get(Signature signature) {
        return this.methods.get(SIGNATURE_WRAPPER.wrap(signature));
    }

    @Override
    public MethodInfo remove(Signature signature) {
        assert (!this.resolved) : "can't remove methods after method table is resolved";
        return this.methods.remove(SIGNATURE_WRAPPER.wrap(signature));
    }

    @Override
    public Result<Void> addNoDuplicatesAllowed(MethodInfo method) {
        assert (!this.resolved) : "can't add methods after method table is resolved";
        if (method.getModifiers().has(ModifierTypeInfos.STATIC) && method.getParameters().isEmpty() && "clone".equalsIgnoreCase(method.getName())) {
            if (this.staticCloneMethod.isPresent()) {
                return this.createError(method);
            }
            this.staticCloneMethod = Optional.of(method);
            return VoidResult.of();
        }
        if (this.methods.containsKey(SIGNATURE_WRAPPER.wrap(method.getSignature()))) {
            return this.createError(method);
        }
        this.methods.put(SIGNATURE_WRAPPER.wrap(MethodUtil.getUnreifiedMethod(method).getSignature()), method);
        return VoidResult.of();
    }

    @Override
    public Result<Void> addDuplicatesAllowed(MethodInfo method) {
        assert (!this.resolved) : "can't add methods after method table is resolved";
        MethodInfo parent = this.methods.get(SIGNATURE_WRAPPER.wrap(method.getSignature()));
        VoidResult result = VoidResult.of();
        if (parent != null && !TypeInfoEquivalence.isEquivalent(parent.getReturnType(), method.getReturnType())) {
            result = VoidResult.error(I18nSupport.getLabel("method.types.clash", method.getReturnType(), parent.getReturnType(), method.getDefiningType()));
        }
        this.methods.put(SIGNATURE_WRAPPER.wrap(method.getSignature()), method);
        return result;
    }

    @Override
    public MethodTable resolve() {
        if (this.resolved) {
            return this;
        }
        this.resolved = true;
        if (!this.getStatics().isEmpty()) {
            this.staticMethodLookupMap = new MethodLookupMap();
            this.setupLookupHashMap(this.getStatics(), this.staticMethodLookupMap);
        }
        if (!this.getInstance().isEmpty()) {
            this.instanceMethodLookupMap = new MethodLookupMap();
            this.setupLookupHashMap(this.getInstance(), this.instanceMethodLookupMap);
        }
        if (!this.getUserConstructors().isEmpty()) {
            this.userConstructorLookupMap = new MethodLookupMap();
            this.setupLookupHashMap(this.getUserConstructors(), this.userConstructorLookupMap);
        }
        if (!this.getSystemConstructors().isEmpty()) {
            this.systemConstructorLookupMap = new MethodLookupMap();
            this.setupLookupHashMap(this.getSystemConstructors(), this.systemConstructorLookupMap);
        }
        return this;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public Collection<MethodInfo> all() {
        return this.staticCloneMethod.map(methodInfo -> MoreCollections.prependCollection(methodInfo, this.methods.values())).orElseGet(this.methods::values);
    }

    private Result<Void> createError(MethodInfo method) {
        return VoidResult.error(I18nSupport.getLabel("method.already.exists", method.getSignature().getName(), method.getSignature(), method.getDefiningType()));
    }

    private void setupLookupHashMap(Collection<MethodInfo> methods, MethodLookupMap lookupMap) {
        for (MethodInfo method : methods) {
            Signature signature = method.getSignature();
            Map parameterCountMap = lookupMap.computeIfAbsent(signature.getName(), key -> new HashMap());
            LinkedList<MethodInfo> collection = (LinkedList<MethodInfo>)parameterCountMap.get(signature.getParameterTypes().size());
            if (collection == null) {
                collection = new LinkedList<MethodInfo>();
                collection.add(method);
                parameterCountMap.put(signature.getParameterTypes().size(), collection);
                continue;
            }
            collection.add(method);
        }
    }

    private Result<MethodInfo> getApproximate(TypeInfo referencingType, MethodLookupMap lookupMap, String methodName, List<TypeInfo> parameterTypes) {
        Result<MethodInfo> currentBest = Result.none();
        int[] currentBestDistance = null;
        boolean hasAmbiguousBind = false;
        Map parameterCountMap = (Map)lookupMap.get(methodName);
        if (parameterCountMap == null || parameterCountMap.get(parameterTypes.size()) == null) {
            return Result.none();
        }
        Collection methods = (Collection)parameterCountMap.get(parameterTypes.size());
        for (MethodInfo method : methods) {
            int[] candidateDistance = Distance.get().getDistanceForMethods(referencingType, parameterTypes, method.getParameterTypes());
            if (candidateDistance == null) continue;
            int distanceDiff = Distance.get().isCloser(candidateDistance, currentBestDistance);
            if (distanceDiff < 0) {
                currentBest = Result.of(method);
                currentBestDistance = candidateDistance;
                hasAmbiguousBind = false;
                continue;
            }
            if (distanceDiff != 0) continue;
            hasAmbiguousBind = true;
        }
        return hasAmbiguousBind ? Result.error(I18nSupport.getLabel("ambiguous.method.signature", SignatureUtil.createStringRepresentation(null, methodName, TypeInfos.VOID, parameterTypes))) : currentBest;
    }

    @VisibleForTesting
    static class MethodLookupMap
    extends HashedMap<String, Map<Integer, Collection<MethodInfo>>> {
        private static final long serialVersionUID = -6290065748361410529L;

        MethodLookupMap() {
        }

        @Override
        protected int hash(Object key) {
            assert (key instanceof String) : "key must be a non-null string";
            String methodName = (String)key;
            return MoreStrings.lowerCaseHashCode(methodName);
        }

        @Override
        protected boolean isEqualKey(Object left, Object right) {
            assert (left instanceof String && right instanceof String) : "keys must be non-null strings";
            if (left == right) {
                return true;
            }
            String leftMethodName = (String)left;
            String rightMethodName = (String)right;
            return MoreStrings.equalsIgnoreCase(leftMethodName, rightMethodName);
        }
    }
}

