/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.StandardMethodTable;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.collect.MoreLists;

public class MethodTableFactory {
    private MethodTableFactory() {
    }

    public static MethodTable create(MethodInfo ... methods) {
        return MethodTableFactory.create(new StandardMethodTable(), MoreLists.asImmutableList(methods));
    }

    public static MethodTable create(TypeInfo superType, MethodInfo ... methods) {
        StandardMethodTable table = new StandardMethodTable();
        if (superType != null) {
            for (MethodInfo method : superType.methods().getInstance()) {
                table.addNoDuplicatesAllowed(method).throwIfError();
            }
        }
        return MethodTableFactory.create(table, MoreLists.asImmutableList(methods));
    }

    public static MethodTable create(MethodTable table, Iterable<MethodInfo> methods) {
        for (MethodInfo method : methods) {
            table.addNoDuplicatesAllowed(method).throwIfError();
        }
        return table.resolve();
    }
}

