/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.common.base.WeakStringInterner;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.signature.Signature;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import java.util.List;
import java.util.stream.Collectors;

public class MethodNameMangler {
    static String mangleOnlyListSetMap(TypeInfo type) {
        if (type.getTypeArguments().isEmpty()) {
            return MethodNameMangler.mangle(type.getApexName(), 0);
        }
        String mangledApexName = MethodNameMangler.mangle(GenericTypeInfoUtil.getRootType(type).getApexName(), 0);
        if (!CollectionTypeInfoUtil.isMapOrCollection(type)) {
            return mangledApexName;
        }
        return type.getTypeArguments().stream().map(MethodNameMangler::mangleOnlyListSetMap).collect(Collectors.joining("$$c", mangledApexName + "$$l", "$$r"));
    }

    static String mangleAnyType(TypeInfo type) {
        if (type.getTypeArguments().isEmpty()) {
            return MethodNameMangler.mangle(type.getApexName(), MethodNameMangler.getNamespaceLength(type));
        }
        String mangledTypeName = MethodNameMangler.mangle(GenericTypeInfoUtil.getRootType(type).getApexName(), MethodNameMangler.getNamespaceLength(type));
        return type.getTypeArguments().stream().map(MethodNameMangler::mangleAnyType).collect(Collectors.joining("$$c", mangledTypeName + "$$l", "$$r"));
    }

    private static int getNamespaceLength(TypeInfo type) {
        int length = type.getNamespace().toString().length();
        return length == 0 || type.getBasicType() != BasicType.APEX_OBJECT || !type.getCodeUnitDetails().isApexSourceBased() ? 0 : length + 1;
    }

    static String mangle(String name, int start) {
        StringBuilder builder = new StringBuilder();
        block8: for (int i = start; i < name.length(); ++i) {
            char ch = name.charAt(i);
            switch (ch) {
                case '<': {
                    builder.append("$$l");
                    continue block8;
                }
                case '>': {
                    builder.append("$$r");
                    continue block8;
                }
                case ',': {
                    builder.append("$$c");
                    continue block8;
                }
                case '.': {
                    builder.append("$$d");
                    continue block8;
                }
                case ':': {
                    builder.append("$$o");
                    continue block8;
                }
                case ' ': {
                    continue block8;
                }
                default: {
                    builder.append(ch);
                }
            }
        }
        return builder.toString();
    }

    private static String createMangledName(String name, TypeInfo returnType, List<TypeInfo> parameterTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append(name).append("_r").append(MethodNameMangler.mangleOnlyListSetMap(returnType));
        for (int i = 0; i < parameterTypes.size(); ++i) {
            builder.append("_").append(i).append(MethodNameMangler.mangleOnlyListSetMap(parameterTypes.get(i)));
        }
        assert (builder.length() < 65536) : "The java class file format has a max method length limit of 64k";
        return WeakStringInterner.get().intern(builder.toString());
    }

    private static boolean hasFastCallType(TypeInfo returnType, List<TypeInfo> parameterTypes) {
        return TypeInfoUtil.isFastCallType(returnType) || TypeInfoUtil.hasFastCallType(parameterTypes);
    }

    static boolean hasFastCallType(Signature signature) {
        return MethodNameMangler.hasFastCallType(signature.getReturnType(), signature.getParameterTypes());
    }

    public static String getMangledName(MethodInfo methodInfo, String name) {
        return MethodNameMangler.isMangledName(methodInfo) ? MethodNameMangler.createMangledName(name, methodInfo.getReturnType(), methodInfo.getParameterTypes()) : name;
    }

    public static String getMangledName(String name, TypeInfo returnType, List<TypeInfo> parameterTypes) {
        return MethodNameMangler.hasFastCallType(returnType, parameterTypes) ? MethodNameMangler.createMangledName(name, returnType, parameterTypes) : name;
    }

    public static boolean isMangledName(MethodInfo methodInfo) {
        return methodInfo.getGenerated().isUserDefined && !methodInfo.isConstructor() && MethodNameMangler.hasFastCallType(methodInfo.getSignature());
    }

    public static String getGenericInterfaceMangled(TypeInfo interfaceType, String name) {
        StringBuilder builder = new StringBuilder();
        builder.append(MethodNameMangler.mangleAnyType(interfaceType));
        builder.append("_i");
        builder.append(name);
        assert (builder.length() < 65536) : "The java class file format has a max method length limit of 64k";
        return WeakStringInterner.get().intern(builder.toString());
    }
}

