/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.common.base.Initializer;
import apex.common.base.Initializers;
import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import com.google.common.collect.Collections2;
import com.google.common.collect.MoreLists;
import java.util.Collection;
import java.util.function.Predicate;

public abstract class MemoizingMethodTable
implements MethodTable {
    private static final Predicate<MethodInfo> STATICS_ONLY = method -> method.getModifiers().has(ModifierTypeInfos.STATIC);
    private static final Predicate<MethodInfo> CONSTRUCTORS_ONLY = MethodInfo::isConstructor;
    private static final Predicate<MethodInfo> INSTANCE_ONLY = CONSTRUCTORS_ONLY.or(STATICS_ONLY).negate();
    private static final Predicate<MethodInfo> STATICS_AND_INSTANCE = CONSTRUCTORS_ONLY.negate();
    private static final Predicate<MethodInfo> USER_CONSTRUCTORS = method -> method.isConstructor() && method.getGenerated().isUserDefined;
    private static final Predicate<MethodInfo> SYSTEM_CONSTRUCTORS = method -> method.isConstructor() && !method.getGenerated().isUserDefined;
    private final Initializer<Collection<MethodInfo>, MethodTable> staticsOnlyInitializer = Initializers.memoize(methods -> methods.all().stream().filter(STATICS_ONLY).collect(MoreLists.toImmutableList()));
    private final Initializer<Collection<MethodInfo>, MethodTable> constructorsOnlyInitializer = Initializers.memoize(methods -> methods.all().stream().filter(CONSTRUCTORS_ONLY).collect(MoreLists.toImmutableList()));
    private final Initializer<Collection<MethodInfo>, MethodTable> instanceOnlyInitializer = Initializers.memoize(methods -> methods.all().stream().filter(INSTANCE_ONLY).collect(MoreLists.toImmutableList()));
    private final Initializer<Collection<MethodInfo>, MethodTable> staticsAndInstanceInitializer = Initializers.memoize(methods -> methods.all().stream().filter(STATICS_AND_INSTANCE).collect(MoreLists.toImmutableList()));
    private final Initializer<Collection<MethodInfo>, MethodTable> userConstructorsInitializer = Initializers.memoize(methods -> methods.all().stream().filter(USER_CONSTRUCTORS).collect(MoreLists.toImmutableList()));
    private final Initializer<Collection<MethodInfo>, MethodTable> systemConstructorsInitializer = Initializers.memoize(methods -> methods.all().stream().filter(SYSTEM_CONSTRUCTORS).collect(MoreLists.toImmutableList()));

    @SfdcCalled
    public MemoizingMethodTable() {
    }

    @Override
    public Collection<MethodInfo> getConstructors() {
        return this.isResolved() ? this.constructorsOnlyInitializer.get(this) : Collections2.filter(this.all(), CONSTRUCTORS_ONLY::test);
    }

    @Override
    public Collection<MethodInfo> getUserConstructors() {
        return this.isResolved() ? this.userConstructorsInitializer.get(this) : Collections2.filter(this.all(), USER_CONSTRUCTORS::test);
    }

    @Override
    public Collection<MethodInfo> getSystemConstructors() {
        return this.isResolved() ? this.systemConstructorsInitializer.get(this) : Collections2.filter(this.all(), SYSTEM_CONSTRUCTORS::test);
    }

    @Override
    public boolean hasConstructors() {
        return !this.getConstructors().isEmpty();
    }

    @Override
    public Collection<MethodInfo> getStatics() {
        return this.isResolved() ? this.staticsOnlyInitializer.get(this) : Collections2.filter(this.all(), STATICS_ONLY::test);
    }

    @Override
    public Collection<MethodInfo> getInstance() {
        return this.isResolved() ? this.instanceOnlyInitializer.get(this) : Collections2.filter(this.all(), INSTANCE_ONLY::test);
    }

    @Override
    public Collection<MethodInfo> getStaticsAndInstance() {
        return this.isResolved() ? this.staticsAndInstanceInitializer.get(this) : Collections2.filter(this.all(), STATICS_AND_INSTANCE::test);
    }
}

