/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common.iterable;

import apex.common.base.MoreStrings;
import apex.common.base.WeakStringInterner;
import com.google.common.collect.MoreSets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class CaseInsensitiveSet
extends HashSet<String> {
    private static final long serialVersionUID = 8120768894597055645L;

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean contains(Object value) {
        return value instanceof String && super.contains(MoreStrings.toLowerCase((String)value));
    }

    @Override
    public boolean add(String string) {
        return super.add(WeakStringInterner.get().intern(MoreStrings.toLowerCase(string)));
    }

    @Override
    public boolean remove(Object value) {
        return value instanceof String ? Boolean.valueOf(super.remove(MoreStrings.toLowerCase((String)value))) : null;
    }

    @Override
    public boolean addAll(Collection<? extends String> collection) {
        boolean retValue = false;
        for (String string : collection) {
            retValue |= this.add(string);
        }
        return retValue;
    }

    public static class Builder {
        private final Set<String> set = new CaseInsensitiveSet();

        public Builder add(String value) {
            this.set.add(value);
            return this;
        }

        public Builder addAll(Collection<String> values) {
            this.set.addAll(values);
            return this;
        }

        public Set<String> build() {
            return MoreSets.toImmutableSet(this.set);
        }
    }
}

