/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.bcl.validators;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.validators.BuiltInMethodValidator;
import apex.jorje.semantic.symbol.member.method.signature.Signature;
import apex.jorje.semantic.symbol.member.method.signature.SignatureFactory;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.services.I18nSupport;
import java.util.stream.Collectors;

public class DecimalToDoubleValidator
implements BuiltInMethodValidator {
    private static final DecimalToDoubleValidator FIRST_PARAMETER_KEY_INSTANCE = new DecimalToDoubleValidator(0, 0);
    private static final DecimalToDoubleValidator SECOND_PARAMETER_KEY_INSTANCE = new DecimalToDoubleValidator(0, 1);
    private static final DecimalToDoubleValidator VALUE_INSTANCE = new DecimalToDoubleValidator(1, 1);
    private final int typeArgumentIndex;
    private final int parameterIndex;

    private DecimalToDoubleValidator(int typeArgumentIndex, int parameterIndex) {
        this.typeArgumentIndex = typeArgumentIndex;
        this.parameterIndex = parameterIndex;
    }

    static boolean isValid(TypeInfo parameterType, TypeInfo argumentType, TypeInfo referencingType) {
        return Distance.get().canAssign(referencingType, argumentType, parameterType) || TypeInfoEquivalence.isEquivalent(parameterType, TypeInfos.DOUBLE) && TypeInfoEquivalence.isEquivalent(argumentType, TypeInfos.DECIMAL);
    }

    public static BuiltInMethodValidator getKey() {
        return FIRST_PARAMETER_KEY_INSTANCE;
    }

    public static BuiltInMethodValidator getKeySecondParameter() {
        return SECOND_PARAMETER_KEY_INSTANCE;
    }

    public static BuiltInMethodValidator getValue() {
        return VALUE_INSTANCE;
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope, MethodCallExpression expression) {
        if (scope.getErrors().isInvalid(expression)) {
            return;
        }
        boolean isValid = DecimalToDoubleValidator.isValid(expression.getMethod().getDefiningType().getTypeArguments().get(this.typeArgumentIndex), expression.getInputParameters().get(this.parameterIndex).getType(), expression.getDefiningType());
        if (!isValid) {
            Signature signature = SignatureFactory.create(expression.getMethodName(), (TypeInfo)TypeInfos.VOID, expression.getInputParameters().stream().map(Expression::getType).collect(Collectors.toList()));
            scope.getErrors().markInvalid((AstNode)expression, I18nSupport.getLabel("invalid.method.not.found", signature, expression.getReferenceType()));
        }
    }
}

