/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor.reference;

import apex.jorje.semantic.ast.expression.ReferenceContext;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.ast.visitor.reference.ReferenceInfo;
import apex.jorje.semantic.ast.visitor.reference.ReferenceVisitor;
import apex.jorje.semantic.bcl.DmlOperation;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.naming.TypeNameFactory;

class VariableReferenceUtil {
    private static final VariableReferenceUtil INSTANCE = new VariableReferenceUtil();

    private VariableReferenceUtil() {
    }

    static VariableReferenceUtil get() {
        return INSTANCE;
    }

    void variableVisit(ReferenceVisitor referenceVisitor, Variable variable, ReferenceContext referenceContext, ReferenceType referenceType, boolean isReferencedViaForeignKey, boolean isLast) {
        TypeInfo variableDefiningType = variable.getDefiningType();
        if (variableDefiningType.getBasicType() == BasicType.SOBJECT) {
            this.handleSObjectFieldReferences(referenceVisitor, variable, referenceContext, referenceType, isReferencedViaForeignKey, isLast);
        } else {
            this.handleNonSObjectFieldReferences(variable, referenceContext, referenceVisitor);
        }
    }

    private void handleNonSObjectFieldReferences(Variable variable, ReferenceContext referenceContext, ReferenceVisitor referenceVisitor) {
        if (!variable.getModifiers().has(ModifierTypeInfos.STATIC)) {
            return;
        }
        TypeInfo variableDefiningType = variable.getDefiningType();
        boolean isFullyQualified = TypeNameFactory.isFullyQualified(referenceContext.getStaticNumberOfNamesBound(), referenceVisitor.getReferencingType(), variableDefiningType);
        if (!isFullyQualified) {
            return;
        }
        if (variable.getMemberType() == Member.Type.FIELD || variable.getMemberType() == Member.Type.PROPERTY || variable.getMemberType() == Member.Type.DYNAMIC) {
            referenceVisitor.checkAndAddVariableRelationship(variableDefiningType, variable.getLoc(), ReferenceInfo.builder().setVariable(variable).setReferencedViaForeignKey(false).build());
        }
    }

    private void handleSObjectFieldReferences(ReferenceVisitor referenceVisitor, Variable variable, ReferenceContext referenceContext, ReferenceType referenceType, boolean isReferencedViaForeignKey, boolean isLast) {
        TypeInfo variableDefiningType = variable.getDefiningType();
        boolean isRowCause = TypeInfoEquivalence.isEquivalent(variable.getType(), InternalTypeInfos.SCHEMA_SOBJECT_ROW_CAUSE);
        if (isRowCause) {
            return;
        }
        if (variable.getMemberType() == Member.Type.FIELD || variable.getMemberType() == Member.Type.PROPERTY || variable.getMemberType() == Member.Type.DYNAMIC) {
            DmlOperation dmlOperation = referenceVisitor.isEditable(variable, referenceType == ReferenceType.STORE);
            referenceVisitor.checkAndAddVariableRelationship(variableDefiningType, variable.getLoc(), ReferenceInfo.builder().setVariable(variable).setReferencedViaForeignKey(isReferencedViaForeignKey).setDmlOperation(dmlOperation).setLast(isLast).build());
        }
    }
}

