/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor;

import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.statement.BlockStatement;
import apex.jorje.semantic.ast.statement.DoLoopStatement;
import apex.jorje.semantic.ast.statement.ForLoopStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.statement.WhileLoopStatement;
import apex.jorje.semantic.ast.statement.foreachstatement.ForEachStatement;
import apex.jorje.semantic.ast.visitor.SymbolScope;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodUtil;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import com.google.common.collect.Queues;
import java.util.Deque;
import java.util.List;
import javax.xml.ws.Holder;

public class ValidationScope
extends SymbolScope {
    private final Deque<Holder<Integer>> blocks = Queues.newArrayDeque();
    private final Deque<List<Statement>> classStatements = Queues.newArrayDeque();
    private Integer looping = 0;
    private MethodInfo method;

    public ValidationScope(SymbolResolver symbols, Errors errors) {
        super(symbols, errors);
    }

    @Override
    public void push(UserClass node) {
        super.push(node);
        this.classStatements.push(node.getStatements());
    }

    @Override
    public void pop(UserClass node) {
        this.classStatements.pop();
        super.pop(node);
    }

    @Override
    public void push(BlockStatement node) {
        super.push(node);
        this.blocks.push((Holder<Integer>)new Holder((Object)0));
    }

    @Override
    public void pop(BlockStatement node) {
        this.blocks.pop();
        super.pop(node);
    }

    @Override
    public void push(ForEachStatement node) {
        super.push(node);
        Integer n = this.looping;
        Integer n2 = this.looping = Integer.valueOf(this.looping + 1);
    }

    @Override
    public void pop(ForEachStatement node) {
        Integer n = this.looping;
        Integer n2 = this.looping = Integer.valueOf(this.looping - 1);
        super.pop(node);
    }

    @Override
    public void push(ForLoopStatement node) {
        super.push(node);
        Integer n = this.looping;
        Integer n2 = this.looping = Integer.valueOf(this.looping + 1);
    }

    @Override
    public void pop(ForLoopStatement node) {
        Integer n = this.looping;
        Integer n2 = this.looping = Integer.valueOf(this.looping - 1);
        super.pop(node);
    }

    @Override
    public void push(Method node) {
        super.push(node);
        this.method = node.getMethodInfo();
    }

    @Override
    public void pop(Method node) {
        this.method = null;
        super.pop(node);
    }

    public void pushAnonymousPseudoBlock() {
        this.blocks.push((Holder<Integer>)new Holder((Object)0));
    }

    public void popAnonymousPseudoBlock() {
        this.blocks.pop();
    }

    @Override
    public void push(DoLoopStatement node) {
        super.push(node);
        Integer n = this.looping;
        Integer n2 = this.looping = Integer.valueOf(this.looping + 1);
    }

    @Override
    public void pop(DoLoopStatement node) {
        Integer n = this.looping;
        Integer n2 = this.looping = Integer.valueOf(this.looping - 1);
        super.pop(node);
    }

    @Override
    public void push(WhileLoopStatement node) {
        super.push(node);
        Integer n = this.looping;
        Integer n2 = this.looping = Integer.valueOf(this.looping + 1);
    }

    @Override
    public void pop(WhileLoopStatement node) {
        Integer n = this.looping;
        Integer n2 = this.looping = Integer.valueOf(this.looping - 1);
        super.pop(node);
    }

    public MethodInfo getMethod() {
        return this.method;
    }

    public boolean isTestMethod() {
        return this.method != null && this.method.getModifiers().isTest();
    }

    public boolean isLooping() {
        return this.looping > 0;
    }

    public void incrementBlock() {
        Holder<Integer> holder = this.blocks.peek();
        Integer n = (Integer)holder.value;
        holder.value = (Integer)holder.value + 1;
        Integer n2 = holder.value;
    }

    public boolean isTopLevelBlock() {
        return this.blocks.size() == 1;
    }

    public boolean isFirstStatementInBlock() {
        return (Integer)this.blocks.peek().value == 0;
    }

    public boolean isOutsideMethod() {
        return MethodUtil.isInitializationBlock(this.method);
    }

    public List<Statement> getClassStatements() {
        return this.classStatements.peek();
    }
}

