/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;

public abstract class Statement
implements AstNode {
    public static final Statement NOOP = new Statement(){

        @Override
        public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        }

        public String toString() {
            return "Noop Statement";
        }

        @Override
        public TypeInfo getDefiningType() {
            throw new UnexpectedCodePathException();
        }

        @Override
        public void validate(SymbolResolver symbols, ValidationScope scope) {
        }

        @Override
        public void emit(Emitter emitter) {
        }
    };
    public static final Statement INVALID = new Statement(){

        @Override
        public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        }

        public String toString() {
            return "Invalid Statement";
        }

        @Override
        public void validate(SymbolResolver symbols, ValidationScope scope) {
            scope.getErrors().markInvalid(this);
        }

        @Override
        public void emit(Emitter emitter) {
        }

        @Override
        public TypeInfo getDefiningType() {
            throw new UnexpectedCodePathException();
        }
    };
    private final TypeInfo definingType;
    private boolean returnable;

    private Statement() {
        this((AstNode)null);
    }

    protected Statement(AstNode definingNode) {
        this.definingType = definingNode == null ? null : definingNode.getDefiningType();
        this.returnable = false;
    }

    public final void setReturnable() {
        this.returnable = true;
    }

    public final boolean isReturnable() {
        return this.returnable;
    }

    public final void setReturnable(Statement statement) {
        this.returnable = statement.isReturnable();
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.definingType;
    }
}

