/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Location;
import apex.jorje.data.ast.AssignmentOp;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.ForInit;
import apex.jorje.data.ast.ForInits;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.data.ast.VariableDecl;
import apex.jorje.data.ast.VariableDecls;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.statement.ForLoopStatement;
import apex.jorje.semantic.ast.statement.Statement;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

class ForLoopInitFactory {
    private ForLoopInitFactory() {
    }

    public static List<Statement> create(ForLoopStatement definingNode, Location loc, Optional<ForInits> forInits) {
        return forInits.map(value -> value == null || value.type == null ? ImmutableList.of() : value.type.map(typeRef -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ForInit forInit : value.inits) {
                assert (forInit.name.size() == 1) : "for index variable has an illegal dot in an indentifier";
                builder.add(VariableDecl._VariableDecl(forInit.name.get(0), forInit.expr));
            }
            return ImmutableList.of(AstNodes.get().create((AstNode)definingNode, Stmnt._VariableDeclStmnt(VariableDecls._VariableDecls(ImmutableList.of(), typeRef, (List<VariableDecl>)((Object)builder.build())))));
        }).orElseGet(() -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ForInit forInit : value.inits) {
                Expr.VariableExpr declaration = new Expr.VariableExpr(Optional.empty(), forInit.name);
                Expr.VariableExpr assignment = forInit.expr.isPresent() ? Expr._AssignmentExpr(declaration, AssignmentOp.EQUALS, forInit.expr.get()) : declaration;
                Stmnt.ExpressionStmnt stmnt = (Stmnt.ExpressionStmnt)Stmnt._ExpressionStmnt(loc, assignment);
                builder.add(AstNodes.get().create((AstNode)definingNode, stmnt));
            }
            return builder.build();
        })).orElse(ImmutableList.of());
    }
}

