/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.rule;

import apex.jorje.semantic.ast.modifier.rule.AnnotationContextRule;
import apex.jorje.semantic.ast.modifier.rule.AnnotationRuleUtil;
import apex.jorje.semantic.ast.modifier.rule.FieldContext;
import apex.jorje.semantic.ast.modifier.rule.MethodContext;
import apex.jorje.semantic.ast.modifier.rule.TypeContext;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.ScalarTypeInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.Iterables;

public class RemoteActionContextRule
implements AnnotationContextRule {
    private static final RemoteActionContextRule INSTANCE = new RemoteActionContextRule();

    private RemoteActionContextRule() {
    }

    public static RemoteActionContextRule get() {
        return INSTANCE;
    }

    public static TypeInfoVisitor<Boolean> createParameterVisitor(AccessEvaluator accessEvaluator) {
        return new ParameterTypeVisitor(accessEvaluator);
    }

    public static TypeInfoVisitor<Boolean> createReturnVisitor(AccessEvaluator accessEvaluator) {
        return new ReturnTypeVisitor(accessEvaluator);
    }

    @Override
    public void validate(MethodContext context) {
        if (context.getModifiers().has(ModifierTypeInfos.PUBLIC) && context.getSymbols().getAccessEvaluator().isGlobalComponent(context.getDefiningType())) {
            context.addNodeError(I18nSupport.getLabel("invalid.public.remote.action"));
            return;
        }
        TypeInfoVisitor<Boolean> parameterVisitor = context.getSymbols().getCompilerService().getRemoteActionParameterVisitor();
        TypeInfoVisitor<Boolean> returnVisitor = context.getSymbols().getCompilerService().getRemoteActionReturnVisitor();
        AnnotationRuleUtil.validate(context, AnnotationTypeInfos.REMOTE_ACTION, parameterVisitor, returnVisitor);
    }

    @Override
    public void validate(FieldContext context) {
        TypeInfoVisitor<Boolean> returnVisitor = context.getSymbols().getCompilerService().getRemoteActionReturnVisitor();
        AnnotationRuleUtil.validate(context, AnnotationTypeInfos.REMOTE_ACTION, returnVisitor);
    }

    @Override
    public void validate(TypeContext context) {
    }

    private static boolean isApexSourceBasedAndNotException(TypeInfo type) {
        return type.getCodeUnitDetails().isApexSourceBased() && !TypeInfoEquivalence.isEquivalent(type, TypeInfos.EXCEPTION);
    }

    private static class ParameterTypeVisitor
    extends TypeInfoVisitor.Default<Boolean> {
        private final AccessEvaluator evaluator;

        private ParameterTypeVisitor(AccessEvaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        protected Boolean _default(TypeInfo type) {
            return false;
        }

        @Override
        public Boolean visit(StandardTypeInfo type) {
            return RemoteActionContextRule.isApexSourceBasedAndNotException(type) && this.isDeserializableOrNotConnectApi(type) && !type.getBasicType().isDynamic();
        }

        @Override
        public Boolean visit(ScalarTypeInfo type) {
            return type.getBasicType().isScalarOrVoid() || type.getBasicType() == BasicType.SOBJECT || type.getBasicType() == BasicType.OBJECT;
        }

        @Override
        public Boolean visit(GenericTypeInfo type) {
            if (CollectionTypeInfoUtil.isList(type) || CollectionTypeInfoUtil.isMap(type)) {
                return type.getTypeArguments().stream().allMatch(this::isDeserializableOrNotConnectApi);
            }
            if (CollectionTypeInfoUtil.isSet(type)) {
                return !AnnotationRuleUtil.isConnectApiAndNotBatchResult(Iterables.getOnlyElement(type.getTypeArguments()));
            }
            return this.isSupportedParameterUserType(type);
        }

        private boolean isSupportedParameterUserType(GenericTypeInfo type) {
            return RemoteActionContextRule.isApexSourceBasedAndNotException(type) && this.isDeserializableOrNotConnectApi(type);
        }

        @Override
        public Boolean visit(InternalTypeInfo type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean visit(SObjectTypeInfo type) {
            return true;
        }

        private boolean isDeserializableOrNotConnectApi(TypeInfo type) {
            return !AnnotationRuleUtil.isConnectApiAndNotBatchResult(type) || AnnotationRuleUtil.hasConnectDeserializer(this.evaluator, type);
        }
    }

    private static class ReturnTypeVisitor
    extends TypeInfoVisitor.Default<Boolean> {
        private final AccessEvaluator evaluator;

        private ReturnTypeVisitor(AccessEvaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        protected Boolean _default(TypeInfo type) {
            return false;
        }

        @Override
        public Boolean visit(StandardTypeInfo type) {
            return (RemoteActionContextRule.isApexSourceBasedAndNotException(type) && ReturnTypeVisitor.isSerializableOrNotConnectApi(type) || this.evaluator.hasRemoteAction(type)) && !type.getBasicType().isDynamic();
        }

        @Override
        public Boolean visit(ScalarTypeInfo type) {
            return type.getBasicType().isScalarOrVoid() || type.getBasicType() == BasicType.SOBJECT || type.getBasicType() == BasicType.OBJECT;
        }

        @Override
        public Boolean visit(GenericTypeInfo type) {
            if (CollectionTypeInfoUtil.isList(type) || CollectionTypeInfoUtil.isMap(type)) {
                return type.getTypeArguments().stream().allMatch(ReturnTypeVisitor::isSerializableOrNotConnectApi);
            }
            if (CollectionTypeInfoUtil.isSet(type)) {
                return !AnnotationRuleUtil.isConnectApiAndNotBatchResult(Iterables.getOnlyElement(type.getTypeArguments()));
            }
            return ReturnTypeVisitor.isSupportedReturnUserType(type);
        }

        private static boolean isSupportedReturnUserType(GenericTypeInfo type) {
            return RemoteActionContextRule.isApexSourceBasedAndNotException(type) && ReturnTypeVisitor.isSerializableOrNotConnectApi(type);
        }

        @Override
        public Boolean visit(InternalTypeInfo type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean visit(SObjectTypeInfo type) {
            return true;
        }

        private static boolean isSerializableOrNotConnectApi(TypeInfo type) {
            return !AnnotationRuleUtil.isConnectApiAndNotBatchResult(type) || AnnotationRuleUtil.hasConnectSerializer(type);
        }
    }
}

