/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.Modifier;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.modifier.Annotation;
import apex.jorje.semantic.ast.modifier.Annotations;
import apex.jorje.semantic.ast.modifier.Modifier;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.ast.modifier.Modifiers;
import apex.jorje.semantic.symbol.type.ModifierTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class ModifierGroupBuilder {
    private static final Function<ModifierTypeInfo, Modifier> TO_AST = type -> Modifiers.get().createModifier(Locations.NONE, (ModifierTypeInfo)type);
    private final List<Modifier> modifiers;
    private List<Annotation> annotations;
    private Location loc = Locations.NONE;

    ModifierGroupBuilder() {
        this.modifiers = new ArrayList<Modifier>();
        this.annotations = ImmutableList.of();
    }

    ModifierGroupBuilder addModifiers(List<Modifier> modifiers) {
        this.modifiers.addAll(modifiers);
        return this;
    }

    private void addModifiers(Modifier modifier) {
        this.modifiers.add(modifier);
    }

    public ModifierGroupBuilder addModifiers(ModifierTypeInfo modifier) {
        this.modifiers.add(TO_AST.apply(modifier));
        return this;
    }

    public ModifierGroupBuilder addModifiers(ModifierTypeInfo modifier1, ModifierTypeInfo modifier2) {
        this.modifiers.add(TO_AST.apply(modifier1));
        this.modifiers.add(TO_AST.apply(modifier2));
        return this;
    }

    public ModifierGroupBuilder addModifiers(ModifierTypeInfo modifier1, ModifierTypeInfo modifier2, ModifierTypeInfo modifier3) {
        this.modifiers.add(TO_AST.apply(modifier1));
        this.modifiers.add(TO_AST.apply(modifier2));
        this.modifiers.add(TO_AST.apply(modifier3));
        return this;
    }

    public ModifierGroupBuilder addModifiers(ModifierTypeInfo modifier1, ModifierTypeInfo modifier2, ModifierTypeInfo modifier3, ModifierTypeInfo modifier4) {
        this.modifiers.add(TO_AST.apply(modifier1));
        this.modifiers.add(TO_AST.apply(modifier2));
        this.modifiers.add(TO_AST.apply(modifier3));
        this.modifiers.add(TO_AST.apply(modifier4));
        return this;
    }

    public ModifierGroupBuilder addModifierTypes(List<ModifierTypeInfo> modifiers) {
        modifiers.stream().map(TO_AST).forEach(this.modifiers::add);
        return this;
    }

    public ModifierGroupBuilder addIntersectionOfModifiers(ModifierGroup originalModifiers, ModifierTypeInfo ... modifiers) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ModifierTypeInfo modifier : modifiers) {
            if (!originalModifiers.has(modifier)) continue;
            builder.add(modifier);
        }
        return this.addModifierTypes((List<ModifierTypeInfo>)((Object)builder.build()));
    }

    public ModifierGroupBuilder removeModifiers(ModifierTypeInfo removedModifier) {
        for (int i = this.modifiers.size() - 1; i >= 0; --i) {
            if (!Objects.equals(removedModifier, this.modifiers.get(i).getModifierType())) continue;
            this.modifiers.remove(i);
            return this;
        }
        return this;
    }

    public ModifierGroupBuilder removeModifiers(Set<ModifierTypeInfo> removedModifiers) {
        for (int i = this.modifiers.size() - 1; i >= 0; --i) {
            if (!removedModifiers.contains(this.modifiers.get(i).getModifierType())) continue;
            this.modifiers.remove(i);
        }
        return this;
    }

    public ModifierGroupBuilder removeAllVisibilityModifiers() {
        return this.removeModifiers(ModifierGroups.VISIBILITY_MODIFIERS);
    }

    public ModifierGroupBuilder addAnnotations(List<Annotation> annotations) {
        if (annotations.isEmpty()) {
            return this;
        }
        this.getOrCreateAnnotations().addAll(annotations);
        return this;
    }

    public ModifierGroupBuilder addAnnotation(Annotation annotation) {
        this.getOrCreateAnnotations().add(annotation);
        return this;
    }

    private List<Annotation> getOrCreateAnnotations() {
        if (this.annotations.isEmpty()) {
            this.annotations = new ArrayList<Annotation>();
        }
        return this.annotations;
    }

    public ModifierGroupBuilder addAnnotationAndResolve(Modifier.Annotation ... annotations) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Modifier.Annotation annotation : annotations) {
            builder.add(Annotations.resolve(new Annotation(annotation)));
        }
        return this.addAnnotations((List<Annotation>)((Object)builder.build()));
    }

    public ModifierGroupBuilder addAstModifiers(apex.jorje.data.ast.Modifier value) {
        return this.addAstModifiers(ImmutableList.of(value));
    }

    public ModifierGroupBuilder addAstModifiers(List<apex.jorje.data.ast.Modifier> modifiers) {
        for (apex.jorje.data.ast.Modifier modifier : AstNodes.filterNotNull(modifiers)) {
            modifier._switch(new Modifier.SwitchBlock(){

                @Override
                public void _case(Modifier.TestMethodModifier x) {
                    ModifierGroupBuilder.this.addModifiers(Modifiers.get().createModifier(x.loc, ModifierTypeInfos.TEST_METHOD));
                }

                @Override
                public void _case(Modifier.GlobalModifier x) {
                    ModifierGroupBuilder.this.addModifiers(Modifiers.get().createModifier(x.loc, ModifierTypeInfos.GLOBAL));
                }

                @Override
                public void _case(Modifier.WebServiceModifier x) {
                    ModifierGroupBuilder.this.addModifiers(Modifiers.get().createModifier(x.loc, ModifierTypeInfos.WEB_SERVICE));
                    ModifierGroupBuilder.this.addModifiers(Modifiers.get().createModifier(x.loc, ModifierTypeInfos.GLOBAL));
                }

                @Override
                public void _case(Modifier.PublicModifier x) {
                    ModifierGroupBuilder.this.addModifiers(Modifiers.get().createModifier(x.loc, ModifierTypeInfos.PUBLIC));
                }

                @Override
                public void _case(Modifier.PrivateModifier x) {
                    ModifierGroupBuilder.this.addModifiers(Modifiers.get().createModifier(x.loc, ModifierTypeInfos.PRIVATE));
                }

                @Override
                public void _case(Modifier.ProtectedModifier x) {
                    ModifierGroupBuilder.this.addModifiers(Modifiers.get().createModifier(x.loc, ModifierTypeInfos.PROTECTED));
                }

                @Override
                public void _case(Modifier.WithSharingModifier x) {
                    ModifierGroupBuilder.this.addModifiers(Modifiers.get().createModifier(x.loc, ModifierTypeInfos.WITH_SHARING));
                }

                @Override
                public void _case(Modifier.WithoutSharingModifier x) {
                    ModifierGroupBuilder.this.addModifiers(Modifiers.get().createModifier(x.loc, ModifierTypeInfos.WITHOUT_SHARING));
                }

                @Override
                public void _case(Modifier.StaticModifier x) {
                    ModifierGroupBuilder.this.addModifiers(Modifiers.get().createModifier(x.loc, ModifierTypeInfos.STATIC));
                }

                @Override
                public void _case(Modifier.TransientModifier x) {
                    ModifierGroupBuilder.this.addModifiers(Modifiers.get().createModifier(x.loc, ModifierTypeInfos.TRANSIENT));
                }

                @Override
                public void _case(Modifier.AbstractModifier x) {
                    ModifierGroupBuilder.this.addModifiers(Modifiers.get().createModifier(x.loc, ModifierTypeInfos.ABSTRACT));
                }

                @Override
                public void _case(Modifier.FinalModifier x) {
                    ModifierGroupBuilder.this.addModifiers(Modifiers.get().createModifier(x.loc, ModifierTypeInfos.FINAL));
                }

                @Override
                public void _case(Modifier.OverrideModifier x) {
                    ModifierGroupBuilder.this.addModifiers(Modifiers.get().createModifier(x.loc, ModifierTypeInfos.OVERRIDE));
                }

                @Override
                public void _case(Modifier.VirtualModifier x) {
                    ModifierGroupBuilder.this.addModifiers(Modifiers.get().createModifier(x.loc, ModifierTypeInfos.VIRTUAL));
                }

                @Override
                public void _case(Modifier.Annotation x) {
                    ModifierGroupBuilder.this.addAnnotation(AstNodes.get().create(x));
                }
            });
        }
        return this;
    }

    public ModifierGroup build() {
        return new ModifierGroup(this);
    }

    public List<Modifier> getModifiers() {
        return this.modifiers;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public Location getLoc() {
        return this.loc;
    }

    public ModifierGroupBuilder setLoc(Location loc) {
        this.loc = loc;
        return this;
    }

    int getJavaModifiers() {
        int javaModifiers = 0;
        for (Modifier modifier : this.modifiers) {
            javaModifiers |= modifier.getModifierType().getOpcode();
        }
        if ((javaModifiers & 1) > 0) {
            javaModifiers &= 0xFFFFFFFB;
            javaModifiers &= 0xFFFFFFFD;
        }
        if ((javaModifiers & 4) > 0) {
            javaModifiers &= 0xFFFFFFFD;
        }
        return javaModifiers;
    }
}

