/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.AnnotationParameter;
import apex.jorje.data.ast.AnnotationValue;
import apex.jorje.data.ast.Modifier;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.modifier.AnnotationParameter;
import apex.jorje.semantic.ast.modifier.ModifierOrAnnotation;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.common.iterable.CaseInsensitiveMap;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.AnnotationProperty;
import apex.jorje.semantic.symbol.type.ModifierOrAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoTables;
import apex.jorje.semantic.symbol.type.UnresolvedTypeInfoFactory;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;

public class Annotation
extends ModifierOrAnnotation {
    public static final String VALUE = "value";
    private final Modifier.Annotation astAnnotation;
    private final Map<String, AnnotationParameter> parameters;
    private final boolean canIgnoreIfInvalid;

    public Annotation(final Modifier.Annotation astAnnotation) {
        this.astAnnotation = astAnnotation;
        final CaseInsensitiveMap<AnnotationParameter> parameters = new CaseInsensitiveMap<AnnotationParameter>();
        boolean canIgnoreIfInvalid = false;
        for (apex.jorje.data.ast.AnnotationParameter parameter : AstNodes.filterNotNull(astAnnotation.parameters)) {
            canIgnoreIfInvalid |= parameter.match(new AnnotationParameter.MatchBlock<Boolean>(){

                @Override
                public Boolean _case(AnnotationParameter.AnnotationString x) {
                    assert (astAnnotation.parameters.size() == 1);
                    parameters.put(Annotation.VALUE, AnnotationParameter.create(Annotation.this, x.loc, Annotation.VALUE, AnnotationValue._StringAnnotationValue(x.loc, x.value)));
                    return true;
                }

                @Override
                public Boolean _case(AnnotationParameter.AnnotationKeyValue x) {
                    parameters.put(x.key.getValue(), AnnotationParameter.create(Annotation.this, x.loc, x.key.getValue(), x.value));
                    return false;
                }
            }).booleanValue();
        }
        this.canIgnoreIfInvalid = canIgnoreIfInvalid;
        this.parameters = parameters;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            for (AnnotationParameter parameter : this.parameters.values()) {
                parameter.traverse(visitor, scope);
            }
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        Errors errors = scope.getErrors();
        if (!this.getType().isResolved()) {
            if (!this.canIgnoreIfInvalid) {
                errors.markInvalid((AstNode)this, I18nSupport.getLabel("invalid.unresolved.annotation", this.astAnnotation.name.getValue()));
            }
            return;
        }
        for (AnnotationParameter parameter : this.parameters.values()) {
            parameter.validate(symbols, scope);
        }
        Predicate<AnnotationProperty> missingProperty = property -> !this.parameters.containsKey(property.getName());
        Predicate<AnnotationProperty> isRequired = AnnotationProperty::isRequired;
        this.getType().getProperties().values().stream().filter(missingProperty.and(isRequired)).forEach(property -> scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("annotation.property.missing", property.getName())));
        if (errors.isInvalid(this.parameters.values())) {
            errors.markInvalid(this);
        }
    }

    @Override
    public void emit(Emitter emitter) {
        if (this.getType().isBytecodeVisible() && !this.canIgnoreIfInvalid) {
            emitter.getAnnotationVisitor().get().getAnnotationVisitor().visit(this.getType().getBytecodeName(), (Object)true);
            if (this.getType().emitProperties()) {
                this.parameters.values().stream().sorted(AnnotationParameter.NAME_COMPARATOR).forEach(parameter -> parameter.emit(emitter));
            }
        }
    }

    @Override
    public TypeInfo getDefiningType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Location getLoc() {
        return this.astAnnotation.loc;
    }

    public void resolve(Version version) {
        if (this.getType() != null) {
            return;
        }
        ModifierOrAnnotationTypeInfo standardTypeInfo = TypeInfoTables.ANNOTATION_TYPES.get(this.astAnnotation.name.getValue());
        this.setType(MoreObjects.firstNonNull(standardTypeInfo, UnresolvedTypeInfoFactory.getAnnotation()));
        Predicate<AnnotationProperty> missingProperty = property -> !this.parameters.containsKey(property.getName());
        Predicate<AnnotationProperty> hasDefault = AnnotationProperty::hasDefaultValue;
        this.getType().getProperties().values().stream().filter(missingProperty.and(hasDefault)).forEach(property -> {
            AnnotationParameter parameter = AnnotationParameter.createDefault(this, Locations.NONE, property.getName(), AnnotationValue._StringAnnotationValue(Locations.NONE, property.getDefaultValue().get(version).toString()));
            this.parameters.put(property.getName(), parameter);
        });
    }

    public String toString() {
        return this.astAnnotation.toString();
    }

    @Override
    public AnnotationParameter getParameter(String name) {
        return this.parameters.get(name);
    }

    public Collection<AnnotationParameter> getParameters() {
        return this.parameters.values();
    }
}

