/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.Emit;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.TypeStack;
import apex.jorje.semantic.ast.member.MethodEmit;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.member.SystemModeEmit;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierNode;
import apex.jorje.semantic.ast.statement.MethodBlockStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.SystemEmitMethods;
import apex.jorje.semantic.common.IdeCalled;
import apex.jorje.semantic.common.util.VersionUtil;
import apex.jorje.semantic.symbol.member.IdentifierValidator;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodUtil;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfoBuilder;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.member.variable.LocalVariableScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import java.util.Optional;

public class Method
implements AstNode {
    public static final int MAX_PARAMETERS = 32;
    private final TypeInfo definingType;
    private final StandardMethodInfoBuilder builder;
    private final ModifierNode modifiers;
    private final LocalVariableScope locals;
    private final MethodBlockStatement body;
    private final ModifierGroup modifiersInfo;
    private MethodInfo methodInfo;

    Method(AstNode definingNode, StandardMethodInfoBuilder builder, Statement root) {
        this.definingType = definingNode.getDefiningType();
        this.builder = builder;
        this.modifiers = new ModifierNode(this, builder.getModifiers());
        this.modifiersInfo = builder.getModifiers();
        this.locals = new LocalVariableScope();
        this.body = new MethodBlockStatement(this, root);
    }

    @IdeCalled
    public Location getBodyLocation() {
        return this.body.getLoc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        scope.push(this);
        try {
            if (visitor.visit(this, scope)) {
                this.modifiers.traverse(visitor, scope);
                for (Parameter parameter : this.builder.getParameters()) {
                    parameter.traverse(visitor, scope);
                }
                this.body.traverse(visitor, scope);
            }
            visitor.visitEnd(this, scope);
        }
        finally {
            scope.pop(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void validate(SymbolResolver symbols, ValidationScope scope) {
        scope.push(this);
        try {
            if (this.methodInfo.getGenerated().isUserDefined && !this.methodInfo.isConstructor()) {
                scope.getErrors().addIfError((AstNode)this, this.methodInfo.getLoc(), IdentifierValidator.builder(this.getDefiningType(), MethodUtil.getNameForValidation(this.methodInfo), IdentifierValidator.Type.METHOD).validate());
            }
            if (!Visibility.isTypeVisible(symbols.getAccessEvaluator(), this.getDefiningType(), this.methodInfo.getReturnType(), Visibility.ReferencedFromTestMethod.NO, Visibility.CheckGenericTypeArguments.YES)) {
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("type.not.visible", this.methodInfo.getReturnType()));
            }
            for (Parameter parameter : this.methodInfo.getParameters()) {
                parameter.validate(symbols, scope);
            }
            if (this.methodInfo.getParameters().size() > 32) {
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.number.parameters", 32));
                return;
            }
            this.modifiers.validate(symbols, scope);
            if (MethodUtil.isIllegalConstructorName(this.definingType, this.methodInfo)) {
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.constructor.name", this.builder.getName().getValue()));
                return;
            }
            if (!this.modifiersInfo.has(ModifierTypeInfos.ABSTRACT)) {
                this.body.validate(symbols, scope);
                if (!this.body.hasBody()) {
                    scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("method.must.have.body"));
                }
                if (!this.body.isReturnable() && this.methodInfo.hasReturnValue() && VersionUtil.get(this).isGreaterThanOrEqual(Version.V146)) {
                    scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.return.non.void", this.methodInfo.getReturnType()));
                }
            } else if (this.body.hasBody()) {
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("abstract.methods.cannot.have.body"));
            }
        }
        finally {
            scope.pop(this);
        }
    }

    @Override
    public void emit(Emitter myEmitter) {
        assert (this.methodInfo.getGenerated().isEmitted) : "method should not be emitted";
        Emit body = emitter -> {
            TypeStack.TypeContext context = emitter.getTypeStack().peek();
            for (LocalInfo variable : this.locals.all()) {
                variable.getPosition(emitter);
            }
            if (!this.modifiersInfo.has(ModifierTypeInfos.ABSTRACT)) {
                if (!this.modifiersInfo.isTestOrTestSetup() && this.methodInfo.getGenerated().emitAdditionalCodeLocations) {
                    emitter.emitAdditionalCodeLocation(this.methodInfo.getLoc(), context.getType().getBytecodeName());
                }
                if ((TypeInfoUtil.isInTestClass(this.methodInfo) || this.modifiersInfo.isTest()) && this.methodInfo.getGenerated().isUserDefined) {
                    emitter.push(Locations.NONE, this.modifiersInfo.isTest());
                    emitter.box(TypeInfos.BOOLEAN);
                    emitter.emit(Locations.NONE, SystemEmitMethods.ENSURE_TEST_CONTEXT);
                }
                if (this.methodInfo.getGenerated().isUserDefined) {
                    SystemModeEmit.emitter().withType(context.getType()).withBody(this.body).withSetupTestLimits(!this.methodInfo.isConstructor()).emit(emitter);
                } else {
                    this.body.emit(emitter);
                }
                if (!this.body.isLastStatementReturnable()) {
                    if (!this.methodInfo.hasReturnValue()) {
                        emitter.emit(Locations.NONE, 177);
                    } else if (VersionUtil.get(emitter).isLessThan(Version.V146)) {
                        emitter.emit(Locations.NONE, 1);
                        emitter.emit(Locations.NONE, 176);
                    }
                }
            }
        };
        new MethodEmit(this.methodInfo, body).emit(myEmitter);
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.definingType;
    }

    @Override
    public Location getLoc() {
        return this.builder.getLoc();
    }

    public MethodInfo getMethodInfo() {
        assert (this.methodInfo != null) : "method hasn't been resolved: " + this.builder.getName();
        return this.methodInfo;
    }

    public void resolve(SymbolResolver symbols) {
        if (this.methodInfo != null) {
            return;
        }
        this.builder.getReturnType().resolve(symbols, this.getDefiningType());
        for (Parameter parameter : this.builder.getParameters()) {
            parameter.resolve(symbols);
        }
        this.methodInfo = this.builder.build();
    }

    public TypeRef getReturnTypeRef() {
        return this.builder.getReturnType().getRef();
    }

    public LocalVariableScope getLocals() {
        return this.locals;
    }

    public ModifierGroup getModifiers() {
        return this.modifiersInfo;
    }

    public ModifierNode getModifiersNode() {
        return this.modifiers;
    }

    public String toString() {
        return Optional.ofNullable(this.methodInfo).map(Object::toString).orElse(this.builder.toString());
    }
}

