/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Identifier;
import apex.jorje.semantic.ast.expression.ReferenceExpression;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.ast.expression.StaticLabelBind;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.member.variable.DynamicFieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldTable;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;

class SpecialStaticExpression {
    SpecialStaticExpression() {
    }

    public static Variable get(ValidationScope validationScope, ReferenceExpression referenceExpression, TypeInfo referencingType, ReferenceType reference, List<Identifier> names, Identifier lastName) {
        boolean isMethodCall;
        boolean bl = isMethodCall = reference == ReferenceType.METHOD;
        if (names.isEmpty() || isMethodCall && names.size() < 2) {
            return null;
        }
        return SpecialStaticExpression.get(validationScope, referenceExpression, referencingType, names, isMethodCall ? Iterables.getLast(names) : lastName, isMethodCall ? names.size() - 1 : names.size());
    }

    private static Variable get(ValidationScope validationScope, ReferenceExpression referenceExpression, TypeInfo referencingType, List<Identifier> names, Identifier lastName, int size) {
        String lastNameLower = lastName.getValue().toLowerCase();
        String firstLower = names.get(0).getValue().toLowerCase();
        String secondLower = size > 1 ? names.get(1).getValue().toLowerCase() : null;
        String thirdLower = size > 2 ? names.get(2).getValue().toLowerCase() : null;
        SymbolResolver symbols = validationScope.getSymbols();
        if (Objects.equals("quickaction", firstLower)) {
            String entity = size == 2 ? secondLower : "";
            return SpecialStaticExpression.bindToQuickAction(symbols, referencingType, entity, lastName, lastNameLower);
        }
        if (size > 1 && Objects.equals("system", firstLower) && Objects.equals("quickaction", secondLower)) {
            String entity = size == 3 ? thirdLower : "";
            return SpecialStaticExpression.bindToQuickAction(symbols, referencingType, entity, lastName, lastNameLower);
        }
        Variable label = StaticLabelBind.bindToLabel(validationScope, referenceExpression, referencingType, names, lastName, size, firstLower, secondLower);
        if (label != null) {
            return label;
        }
        if (names.size() > 2 && "schema".equals(firstLower)) {
            return SpecialStaticExpression.bindToSObjectField(symbols, referencingType, secondLower, lastNameLower);
        }
        if (names.size() > 1) {
            return SpecialStaticExpression.bindToSObjectField(symbols, referencingType, firstLower, lastNameLower);
        }
        return null;
    }

    private static Variable bindToSObjectField(SymbolResolver symbols, TypeInfo referencingType, String entity, String lastNameLower) {
        TypeInfo sObjectType = symbols.getSymbolProvider().getSObjectType(referencingType, entity);
        if (sObjectType != null) {
            return sObjectType.fields().get(symbols, referencingType, lastNameLower, FieldTable.LookupMode.STATIC_VARIABLE);
        }
        return null;
    }

    private static Variable bindToQuickAction(SymbolResolver symbols, TypeInfo referencingType, String entity, Identifier quickActionName, String quickActionNameLower) {
        String fullName = symbols.getSymbolProvider().getQuickAction(referencingType, entity, quickActionNameLower);
        if (fullName != null) {
            return ((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)((DynamicFieldInfo.Builder)DynamicFieldInfo.builder().setDefiningType(InternalTypeInfos.SYSTEM_QUICK_ACTION)).setType(TypeInfos.STRING)).setModifiers(ModifierGroups.GLOBAL_STATIC)).setName(quickActionName.getValue())).setLoadEmitter((emitter, info, context) -> emitter.push(context.loc, fullName)).build();
        }
        return null;
    }
}

