/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.common.base.Result;
import apex.jorje.data.Identifier;
import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.Expr;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.BuiltInMethodMapper;
import apex.jorje.semantic.ast.expression.EmptyReferenceExpression;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.ExpressionUtil;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.expression.MethodCallInterceptor;
import apex.jorje.semantic.ast.expression.MethodCallInterceptors;
import apex.jorje.semantic.ast.expression.ReferenceContext;
import apex.jorje.semantic.ast.expression.ReferenceExpression;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.SymbolScope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.SObjectEmitMethods;
import apex.jorje.semantic.bcl.SystemEmitMethods;
import apex.jorje.semantic.bcl.validators.BuiltInMethodValidator;
import apex.jorje.semantic.common.I18nSupplierWithMethodSignature;
import apex.jorje.semantic.common.iterator.EqualPairIterator;
import apex.jorje.semantic.common.iterator.Pair;
import apex.jorje.semantic.common.util.VersionUtil;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.signature.Signature;
import apex.jorje.semantic.symbol.member.method.signature.SignatureFactory;
import apex.jorje.semantic.symbol.member.method.signature.SignatureUtil;
import apex.jorje.semantic.symbol.member.variable.VariableEmitLoadVisitor;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.WrapperTypeInfos;
import apex.jorje.semantic.symbol.type.common.ExceptionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeEraser;
import apex.jorje.semantic.symbol.visibility.MethodCallVisibility;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.semantic.symbol.visibility.VisibleApiVersionUtil;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.MoreLists;
import java.util.Collection;
import java.util.List;

public class MethodCallExpression
extends Expression {
    private static final List<MethodCallInterceptor> INTERCEPTORS = ImmutableList.of(new MethodCallInterceptors.AddError(), new MethodCallInterceptors.GetQueryLocator(), new MethodCallInterceptors.IsFuture(), new MethodCallInterceptors.IsUserGenericInterface());
    private static final Signature GET_DML_FIELDS = SignatureFactory.create("getDmlFields", (TypeInfo)TypeInfos.VOID, TypeInfos.INTEGER);
    private static final Signature GET_DML_FIELD_NAMES = SignatureFactory.create("getDmlFieldNames", (TypeInfo)TypeInfos.VOID, TypeInfos.INTEGER);
    private final List<Expression> inputParameters;
    private final Identifier name;
    private final ReferenceContext reference;
    private MethodInfo method;

    public MethodCallExpression(AstNode definingNode, Expr.MethodCallExpr expr) {
        super(definingNode);
        this.reference = ReferenceExpression.create(this, ReferenceType.METHOD, expr.dottedExpr, MoreLists.removeLast(expr.names), null);
        this.name = Iterables.getLast(expr.names);
        this.inputParameters = AstNodes.get().createExpressions(this, expr.inputParameters);
    }

    static TypeInfo convertReturnTypeForFastCall(TypeInfo type) {
        return TypeInfoEquivalence.isEquivalent(GenericTypeInfoUtil.getRootType(type), WrapperTypeInfos.SYSTEM_LIST_ITERATOR) ? InternalTypeInfos.SYSTEM_ITERATOR : type;
    }

    private static IdentifierContext calculateIdentifierContext(ReferenceContext reference, SymbolResolver symbols) {
        return EmptyReferenceExpression.isEmptyReference(reference) && symbols.staticContext().get() ? IdentifierContext.STATIC : reference.getContext();
    }

    @VisibleForTesting
    static boolean shouldRemapGetDmlFields(String methodName, List<TypeInfo> parameterTypes, TypeInfo definingType, TypeInfo expressionType) {
        return Version.V152.isGreaterThanOrEqual(definingType.getCodeUnitDetails().getVersion()) && ExceptionTypeInfoUtil.isException(expressionType) && SignatureUtil.equalsSignature(GET_DML_FIELDS.getName(), methodName, GET_DML_FIELDS.getParameterTypes(), parameterTypes);
    }

    public Identifier getNameUsed() {
        return this.name;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            if (scope instanceof SymbolScope) {
                SymbolResolver symbols = ((SymbolScope)scope).getSymbols();
                symbols.variables().setAllowLazyDeclaration(this.allowLazyDeclaration());
                this.reference.getExpression().traverse(visitor, scope);
                symbols.variables().clearAllowLazyDeclaration();
            } else {
                this.reference.getExpression().traverse(visitor, scope);
            }
            for (Expression actualParameter : this.inputParameters) {
                actualParameter.traverse(visitor, scope);
            }
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        Collection<TypeInfo> parameterTypes;
        String methodName;
        symbols.variables().setAllowLazyDeclaration(this.allowLazyDeclaration());
        try {
            this.reference.getExpression().validate(symbols, scope);
        }
        finally {
            symbols.variables().clearAllowLazyDeclaration();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Expression expression : this.inputParameters) {
            expression.validate(symbols, scope);
            builder.add(expression.getType());
        }
        ImmutableCollection inputParameterTypes = builder.build();
        Errors errors = scope.getErrors();
        if (errors.isInvalid(this.inputParameters) || errors.isInvalid(this.reference.getExpression())) {
            errors.markInvalid(this);
            return;
        }
        if (MethodCallExpression.shouldRemapGetDmlFields(this.name.getValue(), (List<TypeInfo>)((Object)inputParameterTypes), this.getDefiningType(), this.getReferenceType())) {
            methodName = GET_DML_FIELD_NAMES.getName();
            parameterTypes = GET_DML_FIELD_NAMES.getParameterTypes();
        } else {
            methodName = this.name.getValue();
            parameterTypes = inputParameterTypes;
        }
        Result<MethodInfo> result = symbols.lookupMethodInfo(this.getDefiningType(), MethodCallExpression.calculateIdentifierContext(this.reference, symbols), this.getReferenceType(), methodName, (List<TypeInfo>)parameterTypes);
        if (scope.getErrors().addIfError((AstNode)this, result, I18nSupplierWithMethodSignature.create("invalid.method.not.found", null, methodName, TypeInfos.VOID, parameterTypes, this.getReferenceType()))) {
            return;
        }
        this.method = result.get();
        List<String> visibilityErrors = MethodCallVisibility.calculate(this.getDefiningType(), symbols.getAccessEvaluator(), Visibility.ReferencedFromTestMethod.fromBoolean(scope.isTestMethod()), this.method);
        if (!visibilityErrors.isEmpty()) {
            scope.getErrors().markInvalid((AstNode)this, visibilityErrors);
            return;
        }
        scope.getErrors().addIfError((AstNode)this, this.getLoc(), VisibleApiVersionUtil.checkApiVisible(symbols.getAccessEvaluator(), this.getDefiningType(), this.method.getName(), this.method.getModifiers(), Member.Type.METHOD));
        for (BuiltInMethodValidator validator : this.method.getValidators()) {
            validator.validate(symbols, scope, this);
        }
        if (scope.getErrors().isInvalid(this)) {
            return;
        }
        this.calculateAdditionalErrors(symbols, scope);
        this.setType(TypeInfoUtil.getRealType(symbols, this.getDefiningType(), this.method.getReturnType()));
    }

    private void calculateAdditionalErrors(SymbolResolver symbols, ValidationScope scope) {
        if (this.method.getModifiers().has(ModifierTypeInfos.ABSTRACT) && ExpressionUtil.isSuperVariableExpression(this.reference.getDottedExpression()) && VersionUtil.get(this).isGreaterThan(Version.V172)) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.abstract.method.call", this.method, this.getReferenceType()));
        }
        if (this.method.getModifiers().has(ModifierTypeInfos.STATIC) && this.reference.getContext() == IdentifierContext.OBJECT) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.static.method.context", this.method, this.getReferenceType()));
        }
        if (!this.method.getModifiers().has(ModifierTypeInfos.STATIC) && this.reference.getContext() == IdentifierContext.STATIC) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.non.static.method.context", this.method, this.getReferenceType()));
        }
        if (!this.method.getModifiers().has(ModifierTypeInfos.STATIC) && symbols.staticContext().get() && this.reference.getContext() == IdentifierContext.NONE) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.non.static.method.context", this.method, this.getReferenceType()));
        }
    }

    @Override
    public void emit(Emitter emitter) {
        AsmMethod asmMethod;
        boolean originalSuppressLocation = emitter.getSuppressLocation();
        if (this.method.getName().equalsIgnoreCase("debug") && TypeInfoEquivalence.isEquivalent(InternalTypeInfos.SYSTEM, this.method.getDefiningType())) {
            emitter.setSuppressLocation(true);
        }
        for (MethodCallInterceptor interceptor : INTERCEPTORS) {
            if (!interceptor.shouldIntercept(this)) continue;
            interceptor.intercept(this, emitter);
            this.finishCall(emitter);
            return;
        }
        this.emitReferenceExpression(emitter);
        MethodInfo proxy = emitter.getProxyMethodTable().get(this.getLoc(), this.getDefiningType(), this.getReferenceType(), this.method);
        if (this.reference.getContext() == IdentifierContext.NONE && !this.method.getModifiers().has(ModifierTypeInfos.STATIC)) {
            emitter.emitVar(this.name.getLoc(), 25, 0);
        }
        this.emitParameters(emitter);
        if (proxy != null) {
            emitter.emit(this.name.getLoc(), proxy.getAsmMethod());
            this.convertReturnTypeIfNecessary(emitter);
        } else if (TypeInfoUtil.isFastCallType(this.getReferenceType())) {
            emitter.emit(this.name.getLoc(), this.method.getAsmMethodBuilder().setDefiningTypeAsBytecodeMethodName(GenericTypeInfoUtil.getRootType(this.method.getDefiningType())).build());
            if (!this.isTopLevel() && this.method.hasReturnValue() && !TypeInfoEquivalence.isEquivalent(this.method.getReturnType(), TypeInfos.OBJECT) && !this.method.isDuckTyped()) {
                TypeInfo convertedType = MethodCallExpression.convertReturnTypeForFastCall(this.method.getReturnType());
                String bytecodeName = emitter.enforceNewEmitBehavior() ? TypeEraser.eraseBytecodeName(convertedType, TypeEraser.CustomErasureType.UNION_SUB_ENTITY) : TypeEraser.eraseBytecodeName(convertedType);
                emitter.push(Locations.NONE, bytecodeName);
                emitter.emit(Locations.NONE, SystemEmitMethods.CONVERT);
            }
        } else if (ExpressionUtil.isSuperVariableExpression(this.reference.getDottedExpression())) {
            if (this.method.getModifiers().has(ModifierTypeInfos.ABSTRACT)) {
                emitter.emit(this.name.getLoc(), 87);
                for (int i = 0; i < this.getInputParameters().size(); ++i) {
                    emitter.emit(this.name.getLoc(), 87);
                }
                if (!this.isTopLevel() && this.method.hasReturnValue()) {
                    emitter.emit(this.name.getLoc(), 1);
                }
                return;
            }
            emitter.emit(this.name.getLoc(), this.method.getAsmMethodBuilder().setDefiningTypeAsBytecodeName(this.getReferenceType()).invokeSpecial().build());
        } else if (this.getReferenceType().getBasicType() == BasicType.OBJECT) {
            if (this.method.getName().equalsIgnoreCase("equals")) {
                emitter.emit(this.name.getLoc(), SystemEmitMethods.EQUALS_METHOD);
            } else if (this.method.getName().equalsIgnoreCase("hashCode")) {
                emitter.emit(this.name.getLoc(), SystemEmitMethods.HASH_CODE_METHOD);
            } else {
                emitter.emit(this.name.getLoc(), this.method.getAsmMethod());
            }
        } else if (this.getReferenceType().getBasicType().isApexObject()) {
            this.method.getProfilingType().emit(emitter, this);
            asmMethod = !this.method.getModifiers().has(ModifierTypeInfos.STATIC) ? this.method.getAsmMethodBuilder().setDefiningTypeAsBytecodeMethodName(this.getReferenceType()).build() : this.method.getAsmMethod();
            emitter.emit(this.name.getLoc(), asmMethod);
            this.convertReturnTypeIfNecessary(emitter);
        } else if (this.getReferenceType().getBasicType() == BasicType.JAVA) {
            emitter.emit(this.name.getLoc(), this.method.getAsmMethod());
        } else if (this.getReferenceType().getBasicType() == BasicType.SOBJECT) {
            asmMethod = SObjectEmitMethods.mapToStatic(this.method);
            emitter.emit(this.name.getLoc(), asmMethod);
            if (!TypeInfoEquivalence.isEquivalent(asmMethod.signature.getReturnType(), this.method.getReturnType())) {
                TypeConversion.emitOrCheckCast(this.name.getLoc(), emitter, asmMethod.signature.getReturnType(), this.method.getReturnType());
            }
        } else {
            this.method.getProfilingType().emit(emitter, this);
            new BuiltInMethodMapper().emit(this.name.getLoc(), emitter, this.method);
        }
        this.finishCall(emitter);
        emitter.setSuppressLocation(originalSuppressLocation);
    }

    @Override
    public Location getLoc() {
        return this.name.getLoc();
    }

    public String getMethodName() {
        return this.name.getValue();
    }

    void convertReturnTypeIfNecessary(Emitter emitter) {
        if (this.method.needsReturnTypeConversion()) {
            this.convertReturnType(emitter);
        }
    }

    void convertReturnType(Emitter emitter) {
        TypeConversion.emit(this.name.getLoc(), emitter, TypeInfos.OBJECT, this.method.getReturnType());
    }

    private void finishCall(Emitter emitter) {
        if (this.isTopLevel() && this.method.hasReturnValue()) {
            emitter.emit(this.name.getLoc(), 87);
        }
        if (!this.isTopLevel() && !this.method.hasReturnValue()) {
            emitter.emit(this.name.getLoc(), 1);
        }
    }

    void emitParameters(Emitter emitter) {
        for (Pair<Expression, TypeInfo> pair : EqualPairIterator.iterable(this.inputParameters, this.method.getEmitSignature().getParameterTypes())) {
            ((Expression)pair.left).emit(emitter);
            TypeConversion.emit(this.name.getLoc(), emitter, ((Expression)pair.left).getType(), (TypeInfo)pair.right);
        }
    }

    private boolean allowLazyDeclaration() {
        return Version.V174.isGreaterThanOrEqual(VersionUtil.get(this));
    }

    public MethodInfo getMethod() {
        return this.method;
    }

    public List<Expression> getInputParameters() {
        return this.inputParameters;
    }

    public void emitReferenceExpression(Emitter emitter) {
        try {
            emitter.getVariableVisitors().push(new VariableEmitLoadVisitor(this, emitter));
            this.reference.getExpression().emit(emitter);
        }
        finally {
            emitter.getVariableVisitors().pop();
        }
    }

    public ReferenceContext getReferenceContext() {
        return this.reference;
    }

    public TypeInfo getReferenceType() {
        return this.reference.getType(this);
    }
}

