/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.ast.BooleanOp;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.expression.ArrayLoadExpression;
import apex.jorje.semantic.ast.expression.ArrayStoreExpression;
import apex.jorje.semantic.ast.expression.BinaryExpression;
import apex.jorje.semantic.ast.expression.BooleanExpression;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.LiteralExpression;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.NewListInitExpression;
import apex.jorje.semantic.ast.expression.SoqlExpression;
import apex.jorje.semantic.ast.expression.SoslExpression;
import apex.jorje.semantic.ast.expression.SuperVariableExpression;
import apex.jorje.semantic.ast.expression.ThisVariableExpression;
import apex.jorje.semantic.ast.expression.TriggerVariableExpression;
import apex.jorje.semantic.ast.statement.FieldDeclaration;
import apex.jorje.semantic.ast.statement.VariableDeclaration;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.BooleanScope;
import apex.jorje.semantic.ast.visitor.ValueScope;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;

public class ExpressionUtil {
    private static final AstVisitor<ValueScope<LiteralExpression>> GET_LITERAL = new AstVisitor<ValueScope<LiteralExpression>>(){

        @Override
        public void visitEnd(LiteralExpression node, ValueScope<LiteralExpression> scope) {
            scope.setValue(node);
        }
    };
    private static final AstVisitor<BooleanScope> IS_LITERAL = new AstVisitor<BooleanScope>(){

        @Override
        public void visitEnd(LiteralExpression node, BooleanScope scope) {
            scope.setValue(true);
        }
    };
    private static final AstVisitor<ValueScope<MethodCallExpression>> GET_METHOD_CALL = new AstVisitor<ValueScope<MethodCallExpression>>(){

        @Override
        public void visitEnd(MethodCallExpression node, ValueScope<MethodCallExpression> scope) {
            scope.setValue(node);
        }
    };
    private static final AstVisitor<ValueScope<SoqlExpression>> GET_SOQL = new AstVisitor<ValueScope<SoqlExpression>>(){

        @Override
        public void visitEnd(SoqlExpression node, ValueScope<SoqlExpression> scope) {
            scope.setValue(node);
        }
    };
    private static final AstVisitor<BooleanScope> IS_SUPER = new AstVisitor<BooleanScope>(){

        @Override
        public void visitEnd(SuperVariableExpression node, BooleanScope scope) {
            scope.setValue(true);
        }
    };
    private static final AstVisitor<BooleanScope> IS_THIS_OR_SUPER = new AstVisitor<BooleanScope>(){

        @Override
        public void visitEnd(ThisVariableExpression node, BooleanScope scope) {
            scope.setValue(true);
        }

        @Override
        public void visitEnd(SuperVariableExpression node, BooleanScope scope) {
            scope.setValue(true);
        }
    };
    private static final AstVisitor<BooleanScope> IS_SOQL = new AstVisitor<BooleanScope>(){

        @Override
        public void visitEnd(SoqlExpression node, BooleanScope scope) {
            scope.setValue(true);
        }
    };
    private static final AstVisitor<BooleanScope> IS_SOQL_OR_SOSL = new AstVisitor<BooleanScope>(){

        @Override
        public void visitEnd(SoqlExpression node, BooleanScope scope) {
            scope.setValue(true);
        }

        @Override
        public void visitEnd(SoslExpression node, BooleanScope scope) {
            scope.setValue(true);
        }
    };
    private static final AstVisitor<BooleanScope> IS_ARRAY_STORE = new AstVisitor<BooleanScope>(){

        @Override
        public void visitEnd(ArrayStoreExpression node, BooleanScope scope) {
            scope.setValue(true);
        }
    };
    private static final AstVisitor<ValueScope<BooleanExpression>> GET_BOOLEAN = new AstVisitor<ValueScope<BooleanExpression>>(){

        @Override
        public void visitEnd(BooleanExpression node, ValueScope<BooleanExpression> scope) {
            scope.setValue(node);
        }
    };
    private static final AstVisitor<ValueScope<BinaryExpression>> GET_BINARY = new AstVisitor<ValueScope<BinaryExpression>>(){

        @Override
        public void visitEnd(BinaryExpression node, ValueScope<BinaryExpression> scope) {
            scope.setValue(node);
        }
    };
    private static final AstVisitor<ValueScope<BooleanOp>> GET_TYPE_FROM_EXPRESSION = new AstVisitor<ValueScope<BooleanOp>>(){

        @Override
        public void visitEnd(BooleanExpression node, ValueScope<BooleanOp> scope) {
            scope.setValue(node.getOp());
        }
    };
    private static final AstVisitor<BooleanScope> IS_INITIAL_STORE = new AstVisitor<BooleanScope>(){

        @Override
        public void visitEnd(FieldDeclaration node, BooleanScope scope) {
            scope.setValue(true);
        }

        @Override
        public void visitEnd(VariableDeclaration node, BooleanScope scope) {
            scope.setValue(true);
        }
    };
    private static final AstVisitor<BooleanScope> IS_LIST_INIT_WITH_SIZE = new AstVisitor<BooleanScope>(){

        @Override
        public boolean visit(NewListInitExpression node, BooleanScope scope) {
            return TypeInfoEquivalence.isEquivalent(node.getInit().getType(), TypeInfos.INTEGER);
        }
    };
    private static final AstVisitor<BooleanScope> IS_ASSIGNABLE_EXPRESSION = new AstVisitor<BooleanScope>(){

        @Override
        public void visitEnd(ArrayLoadExpression arrayLoadExpression, BooleanScope scope) {
            boolean isAssignableTriggerVariableExpression = BooleanScope.evaluate(arrayLoadExpression.getInnerExpression(), IS_ASSIGNABLE_TRIGGER_VARIABLE_EXPRESSION, true);
            scope.setValue(isAssignableTriggerVariableExpression);
        }
    };
    private static final AstVisitor<BooleanScope> IS_ASSIGNABLE_TRIGGER_VARIABLE_EXPRESSION = new AstVisitor<BooleanScope>(){

        @Override
        public void visitEnd(TriggerVariableExpression triggerVariableExpression, BooleanScope scope) {
            scope.setValue(triggerVariableExpression.isAssignable());
        }
    };

    private ExpressionUtil() {
    }

    static BooleanExpression getBooleanExpression(Expression expression) {
        BooleanExpression concreteExpression = ValueScope.evaluate(expression, GET_BOOLEAN, null);
        if (concreteExpression == null) {
            throw new UnexpectedCodePathException();
        }
        return concreteExpression;
    }

    static BinaryExpression getBinaryExpression(Expression expression) {
        BinaryExpression concreteExpression = ValueScope.evaluate(expression, GET_BINARY, null);
        if (concreteExpression == null) {
            throw new UnexpectedCodePathException();
        }
        return concreteExpression;
    }

    public static LiteralExpression getLiteralExpression(Expression expression) {
        LiteralExpression concreteExpression = ValueScope.evaluate(expression, GET_LITERAL, null);
        if (concreteExpression == null) {
            throw new UnexpectedCodePathException();
        }
        return concreteExpression;
    }

    public static MethodCallExpression getMethodCallExpression(Expression expression) {
        MethodCallExpression concreteExpression = ValueScope.evaluate(expression, GET_METHOD_CALL, null);
        if (concreteExpression == null) {
            throw new UnexpectedCodePathException();
        }
        return concreteExpression;
    }

    public static SoqlExpression getSoqlExpression(Expression expression) {
        SoqlExpression concreteExpression = ValueScope.evaluate(expression, GET_SOQL, null);
        if (concreteExpression == null) {
            throw new UnexpectedCodePathException();
        }
        return concreteExpression;
    }

    static boolean isSuperVariableExpression(Expression expression) {
        return BooleanScope.evaluate(expression, IS_SUPER, false);
    }

    static boolean isThisOrSuperVariableExpression(Expression expression) {
        return BooleanScope.evaluate(expression, IS_THIS_OR_SUPER, false);
    }

    public static boolean isSoqlExpression(Expression expression) {
        return BooleanScope.evaluate(expression, IS_SOQL, false);
    }

    static boolean isArrayStoreExpression(Expression expression) {
        return BooleanScope.evaluate(expression, IS_ARRAY_STORE, false);
    }

    public static boolean isLiteralExpression(Expression expression) {
        return BooleanScope.evaluate(expression, IS_LITERAL, false);
    }

    static boolean isSoqlOrSosl(Expression expression) {
        return BooleanScope.evaluate(expression, IS_SOQL_OR_SOSL, false);
    }

    static BooleanOp getBooleanOp(Expression expression) {
        return ValueScope.evaluate(expression, GET_TYPE_FROM_EXPRESSION, null);
    }

    static boolean isInitialStore(AstNode node) {
        return BooleanScope.evaluate(node, IS_INITIAL_STORE, false);
    }

    static boolean isAssignableExpression(Expression expression) {
        return BooleanScope.evaluate(expression, IS_ASSIGNABLE_EXPRESSION, true);
    }

    static boolean isListInitWithSize(Expression expression) {
        return BooleanScope.evaluate(expression, IS_LIST_INIT_WITH_SIZE, false);
    }
}

