/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Identifier;
import apex.jorje.data.Identifiers;
import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.ast.expression.StaticLabelBind;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.SystemEmitMethods;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldTable;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableEmitLoadVisitor;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.resolver.VariableResolver;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.UnresolvedErrorCalculator;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeEraser;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;
import java.util.List;
import java.util.Optional;

public class ClassRefExpression
extends Expression {
    private final Location loc;
    private final TypeRef typeRef;
    private TypeInfo type;
    private Optional<Variable> field;

    public ClassRefExpression(AstNode definingNode, Expr.ClassRefExpr x) {
        super(definingNode);
        this.loc = x.loc;
        this.typeRef = x.type;
        this.field = Optional.empty();
    }

    static TypeInfo lookupType(SymbolResolver symbols, TypeInfo referenceType, TypeRef typeRef) {
        int minSize;
        String innerTypeName;
        TypeInfo innerType;
        List<Identifier> names = typeRef.getNames();
        if (typeRef.getTypeArguments().isEmpty() && (innerType = symbols.get(innerTypeName = referenceType.getBytecodeName() + "$" + names.get(0).getValue())) != null) {
            return innerType;
        }
        TypeInfo type = symbols.lookupTypeInfo(referenceType, typeRef, ReferenceType.CLASS);
        if (type.isResolved() || !typeRef.getTypeArguments().isEmpty()) {
            return type;
        }
        VariableResolver resolver = new VariableResolver(symbols, referenceType);
        int size = typeRef.getNames().size();
        for (int i = minSize = Math.min(size, 4); i > 0; --i) {
            TypeInfo currentType = symbols.lookupTypeInfoIdentifiers(referenceType, names.subList(0, i), ReferenceType.CLASS);
            if (!currentType.isResolved() || i >= minSize) continue;
            List<Identifier> tail = names.subList(i, i + 1);
            List<Variable> variables = resolver.lookup(ReferenceType.LOAD, IdentifierContext.STATIC, currentType, tail);
            if (variables.isEmpty()) {
                return currentType;
            }
            if (i + 1 != minSize) continue;
            return SObjectTypeInfoUtil.isConcreteSObject(currentType) ? currentType : type;
        }
        return type;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        visitor.visit(this, scope);
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        Errors errors = scope.getErrors();
        if (this.typeRef == null) {
            errors.markInvalid(this);
            return;
        }
        this.type = ClassRefExpression.lookupType(symbols, this.getDefiningType(), this.typeRef);
        if (!this.type.isResolved() && this.typeRef.getTypeArguments().isEmpty()) {
            Identifier labelNamedClass = Identifiers.newIdentifier(this.loc, "class");
            Variable label = StaticLabelBind.bindToLabel(scope, this, this.getDefiningType(), this.typeRef.getNames(), labelNamedClass, this.typeRef.getNames().size());
            if (label != null) {
                this.setType(label.getType());
                this.field = Optional.of(label);
                return;
            }
            if (errors.isInvalid(this)) {
                return;
            }
        } else if (TypeInfoEquivalence.isEquivalent(this.type, symbols.getPageTypeInfo())) {
            FieldInfo page = symbols.getPageTypeInfo().fields().get(symbols, this.getDefiningType(), "class", FieldTable.LookupMode.STATIC_VARIABLE);
            if (page != null) {
                this.setType(page.getType());
                this.field = Optional.of(page);
                return;
            }
            errors.markInvalid((AstNode)this, I18nSupport.getLabel("page.does.not.exist", "class"));
            return;
        }
        if (!this.type.isResolved()) {
            errors.markInvalid((AstNode)this, UnresolvedErrorCalculator.getErrors(this.type));
            return;
        }
        if (!Visibility.isTypeVisible(symbols.getAccessEvaluator(), this.getDefiningType(), this.type, Visibility.ReferencedFromTestMethod.fromBoolean(scope.isTestMethod()), Visibility.CheckGenericTypeArguments.YES)) {
            errors.markInvalid((AstNode)this, I18nSupport.getLabel("type.not.visible", this.type));
            return;
        }
        TypeInfo type = symbols.lookupTypeInfo(this.getDefiningType(), InternalTypeInfos.SYSTEM_TYPE);
        this.setType(type);
    }

    @Override
    public void emit(Emitter emitter) {
        if (this.field.isPresent()) {
            VariableVisitor.Context context = new VariableVisitor.Context(this.loc);
            VariableEmitLoadVisitor visitor = new VariableEmitLoadVisitor(this, emitter);
            this.field.get().accept(visitor, context);
            return;
        }
        emitter.push(this.loc, TypeEraser.eraseBytecodeName(this.type, emitter.enforceNewEmitBehavior() ? TypeEraser.CustomErasureType.UNION_SUB_ENTITY : TypeEraser.CustomErasureType.REGULAR));
        emitter.emit(Locations.NONE, SystemEmitMethods.GET_TYPE_TOKEN);
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public TypeInfo getClassType() {
        return this.type;
    }

    public TypeRef getTypeRef() {
        return this.typeRef;
    }

    public Optional<Variable> getVariable() {
        return this.field;
    }
}

